/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.vp8;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodecExt;
import org.jitsi.impl.neomedia.codec.video.vp8.DePacketizer;
import org.jitsi.util.Logger;

public class Packetizer
extends AbstractCodecExt {
    private static final Logger logger = Logger.getLogger(Packetizer.class);
    static final int MAX_SIZE = 1350;
    private boolean firstPacket = true;

    public Packetizer() {
        super("VP8 Packetizer", VideoFormat.class, (Format[])new VideoFormat[]{new VideoFormat("VP8/rtp")});
        this.inputFormats = new VideoFormat[]{new VideoFormat("VP8")};
    }

    protected void doClose() {
    }

    protected void doOpen() {
        if (logger.isTraceEnabled()) {
            logger.trace("Opened VP8 packetizer");
        }
    }

    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        int offset;
        byte[] output;
        if (inputBuffer.isDiscard() || ((byte[])inputBuffer.getData()).length == 0) {
            outputBuffer.setDiscard(true);
            return 0;
        }
        int pdMaxLen = 6;
        if (inputBuffer.getLength() <= 1350) {
            output = this.validateByteArraySize(outputBuffer, inputBuffer.getLength() + 6);
            offset = 6;
        } else {
            output = this.validateByteArraySize(outputBuffer, 1356);
            offset = 6;
        }
        int len = inputBuffer.getLength() <= 1350 ? inputBuffer.getLength() : 1350;
        System.arraycopy((byte[])inputBuffer.getData(), inputBuffer.getOffset(), output, offset, len);
        byte[] pd = DePacketizer.VP8PayloadDescriptor.create(this.firstPacket);
        System.arraycopy(pd, 0, output, offset - pd.length, pd.length);
        outputBuffer.setFormat((Format)new VideoFormat("VP8/rtp"));
        outputBuffer.setOffset(offset -= pd.length);
        outputBuffer.setLength(len + pd.length);
        if (inputBuffer.getLength() <= 1350) {
            this.firstPacket = true;
            return 0;
        }
        this.firstPacket = false;
        inputBuffer.setLength(inputBuffer.getLength() - 1350);
        inputBuffer.setOffset(inputBuffer.getOffset() + 1350);
        return 2;
    }

    class VP8PayloadDescriptor {
        public static final int NOT_SET = -1;
        byte I;
        byte K;
        int KEYIDX = -1;
        byte L;
        byte N;
        byte PartID;
        int PictureID = -1;
        byte S;
        byte T;
        int TID = -1;
        int TL0PICIDX = -1;
        byte X;
        int Y = -1;

        VP8PayloadDescriptor() {
        }

        public byte[] getPayloadDescriptor() {
            int len = this.getSizeInBytes();
            byte[] pd = new byte[len];
            int idx = 0;
            pd[idx] = (byte)(this.PartID + 16 * this.S + 32 * this.N);
            if (this.PictureID != -1 || this.TL0PICIDX != -1 || this.TID != -1 || this.Y != -1 || this.KEYIDX != -1) {
                int n = idx;
                pd[n] = (byte)(pd[n] + 128);
            }
            if (++idx == len) {
                return pd;
            }
            pd[idx] = 0;
            if (this.PictureID != -1) {
                int n = idx;
                pd[n] = (byte)(pd[n] | 0x80);
            }
            if (this.TL0PICIDX != -1) {
                int n = idx;
                pd[n] = (byte)(pd[n] | 0x60);
            }
            if (this.TID != -1 || this.Y != -1) {
                int n = idx;
                pd[n] = (byte)(pd[n] | 0x20);
            }
            if (this.KEYIDX != -1) {
                int n = idx;
                pd[n] = (byte)(pd[n] | 0x10);
            }
            if (this.PictureID != -1) {
                ++idx;
                if (this.PictureID < 128) {
                    pd[idx] = (byte)this.PictureID;
                } else {
                    pd[idx] = (byte)(this.PictureID >> 8 | 0x80);
                    pd[++idx] = (byte)(this.PictureID % 256);
                }
            }
            if (this.TL0PICIDX != -1) {
                pd[++idx] = (byte)this.TL0PICIDX;
            }
            if (this.TID != -1 || this.Y != -1 || this.KEYIDX != -1) {
                pd[++idx] = 0;
                if (this.TID != -1) {
                    pd[idx] = (byte)(this.TID << 6);
                }
                if (this.Y != -1) {
                    int n = idx;
                    pd[n] = (byte)(pd[n] | 0x20);
                }
                if (this.KEYIDX != -1) {
                    int n = idx;
                    pd[n] = (byte)(pd[n] | (byte)this.KEYIDX);
                }
            }
            return pd;
        }

        public int getSizeInBytes() {
            int size = 1;
            if (this.TID != -1 || this.Y != -1 || this.KEYIDX != -1) {
                ++size;
            }
            if (this.TL0PICIDX != -1) {
                ++size;
            }
            if (this.PictureID != -1) {
                ++size;
                if (this.PictureID >= 128) {
                    ++size;
                }
            }
            if (size > 1) {
                ++size;
            }
            return size;
        }

        int parse(byte[] input) throws Exception {
            int idx = 0;
            this.X = (byte)(input[idx] & 0x80);
            this.N = (byte)(input[idx] & 0x20);
            this.S = (byte)(input[idx] & 0x10);
            this.PartID = (byte)(input[idx] & 0xF);
            if (this.X == 0) {
                return idx + 1;
            }
            this.I = (byte)(input[++idx] & 0x80);
            this.L = (byte)(input[idx] & 0x40);
            this.T = (byte)(input[idx] & 0x20);
            this.K = (byte)(input[idx] & 0x10);
            if (this.I != 0) {
                this.PictureID = input[++idx] & 0x7F;
                if ((input[idx] & 0x80) == 1) {
                    this.PictureID = this.PictureID * 128 + input[++idx];
                }
            }
            if (this.L != 0) {
                this.TL0PICIDX = input[++idx];
                if (this.T == 0) {
                    throw new Exception("Could not parse VP8 Payload Descriptor");
                }
            }
            if (this.T != 0 || this.K != 0) {
                ++idx;
                if (this.T != 0) {
                    this.TID = (input[idx] & 0xC0) >> 6;
                    this.Y = input[idx] & 0x20;
                }
                if (this.K != 0) {
                    this.KEYIDX = input[idx] & 0x1F;
                }
            }
            return idx + 1;
        }
    }
}

