/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.h264;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractPacketizer;
import org.jitsi.impl.neomedia.codec.AbstractCodecExt;
import org.jitsi.impl.neomedia.codec.video.h264.JNIEncoder;
import org.jitsi.impl.neomedia.format.ParameterizedVideoFormat;

public class Packetizer
extends AbstractPacketizer {
    public static final int MAX_PAYLOAD_SIZE = 1024;
    private static final String PLUGIN_NAME = "H264 Packetizer";
    static final Format[] SUPPORTED_OUTPUT_FORMATS = new Format[]{new ParameterizedVideoFormat("h264/rtp", "packetization-mode", "0"), new ParameterizedVideoFormat("h264/rtp", "packetization-mode", "1")};
    private final List<byte[]> nals = new LinkedList<byte[]>();
    private long nalsTimeStamp;
    private int sequenceNumber;

    private static int ff_avc_find_startcode(byte[] byteStream, int beginIndex, int endIndex) {
        while (beginIndex < endIndex - 3) {
            if (byteStream[beginIndex] == 0 && byteStream[beginIndex + 1] == 0 && byteStream[beginIndex + 2] == 1) {
                return beginIndex;
            }
            ++beginIndex;
        }
        return endIndex;
    }

    public Packetizer() {
        this.inputFormats = JNIEncoder.SUPPORTED_OUTPUT_FORMATS;
        this.inputFormat = null;
        this.outputFormat = null;
    }

    public synchronized void close() {
        if (this.opened) {
            this.opened = false;
            super.close();
        }
    }

    private Format[] getMatchingOutputFormats(Format input) {
        VideoFormat videoInput = (VideoFormat)input;
        Dimension size = videoInput.getSize();
        float frameRate = videoInput.getFrameRate();
        String packetizationMode = this.getPacketizationMode(input);
        return new Format[]{new ParameterizedVideoFormat("h264/rtp", size, -1, Format.byteArray, frameRate, ParameterizedVideoFormat.toMap("packetization-mode", packetizationMode))};
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    private String getPacketizationMode(Format format) {
        String packetizationMode = null;
        if (format instanceof ParameterizedVideoFormat) {
            packetizationMode = ((ParameterizedVideoFormat)format).getFormatParameter("packetization-mode");
        }
        if (packetizationMode == null) {
            packetizationMode = "0";
        }
        return packetizationMode;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return SUPPORTED_OUTPUT_FORMATS;
        }
        if (!(in instanceof VideoFormat) || AbstractCodecExt.matches(in, this.inputFormats) == null) {
            return new Format[0];
        }
        return this.getMatchingOutputFormats(in);
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (!this.opened) {
            this.nals.clear();
            this.sequenceNumber = 0;
            super.open();
            this.opened = true;
        }
    }

    private boolean packetizeNAL(byte[] nal, int nalOffset, int nalLength) {
        if (nalLength <= 1024) {
            byte[] singleNALUnitPacket = new byte[nalLength];
            System.arraycopy(nal, nalOffset, singleNALUnitPacket, 0, nalLength);
            return this.nals.add(singleNALUnitPacket);
        }
        byte octet = nal[nalOffset];
        int forbidden_zero_bit = octet & 0x80;
        int nri = octet & 0x60;
        int nal_unit_type = octet & 0x1F;
        byte fuIndicator = (byte)(0xFF & (forbidden_zero_bit | nri | 0x1C));
        byte fuHeader = (byte)(0xFF & (0x80 | nal_unit_type));
        ++nalOffset;
        --nalLength;
        int maxFUPayloadLength = 1022;
        boolean nalsAdded = false;
        while (nalLength > 0) {
            int fuPayloadLength;
            if (nalLength > maxFUPayloadLength) {
                fuPayloadLength = maxFUPayloadLength;
            } else {
                fuPayloadLength = nalLength;
                fuHeader = (byte)(fuHeader | 0x40);
            }
            byte[] fua = new byte[2 + maxFUPayloadLength];
            fua[0] = fuIndicator;
            fua[1] = fuHeader;
            System.arraycopy(nal, nalOffset, fua, 2, fuPayloadLength);
            nalOffset += fuPayloadLength;
            nalLength -= fuPayloadLength;
            nalsAdded = this.nals.add(fua) || nalsAdded;
            fuHeader = (byte)(fuHeader & 0xFFFFFF7F);
        }
        return nalsAdded;
    }

    public int process(Buffer inBuffer, Buffer outBuffer) {
        int inLength;
        if (this.nals.size() > 0) {
            byte[] nal = this.nals.remove(0);
            outBuffer.setData((Object)nal);
            outBuffer.setLength(nal.length);
            outBuffer.setOffset(0);
            outBuffer.setTimeStamp(this.nalsTimeStamp);
            outBuffer.setSequenceNumber((long)this.sequenceNumber++);
            if (this.nals.size() > 0) {
                return 2;
            }
            int flags = outBuffer.getFlags() | 0x800;
            if (nal.length > 0) {
                int nal_unit_type = nal[0] & 0x1F;
                if (nal_unit_type == 28 && nal.length > 1) {
                    byte fuHeader = nal[1];
                    if ((fuHeader & 0x40) == 0) {
                        flags &= 0xFFFFF7FF;
                    } else {
                        nal_unit_type = fuHeader & 0x1F;
                    }
                }
                switch (nal_unit_type) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        flags &= 0xFFFFF7FF;
                    }
                }
            }
            outBuffer.setFlags(flags);
            return 0;
        }
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            this.reset();
            return 0;
        }
        if (inBuffer.isDiscard()) {
            outBuffer.setDiscard(true);
            this.reset();
            return 0;
        }
        Format inFormat = inBuffer.getFormat();
        if (inFormat != this.inputFormat && !inFormat.matches(this.inputFormat)) {
            this.setInputFormat(inFormat);
        }
        if ((inLength = inBuffer.getLength()) < 4) {
            outBuffer.setDiscard(true);
            this.reset();
            return 0;
        }
        byte[] inData = (byte[])inBuffer.getData();
        int inOffset = inBuffer.getOffset();
        boolean nalsAdded = false;
        int endIndex = inOffset + inLength;
        int beginIndex = Packetizer.ff_avc_find_startcode(inData, inOffset, endIndex);
        if (beginIndex < endIndex) {
            int nextBeginIndex;
            beginIndex += 3;
            while (beginIndex < endIndex && (nextBeginIndex = Packetizer.ff_avc_find_startcode(inData, beginIndex, endIndex)) <= endIndex) {
                int nalLength = nextBeginIndex - beginIndex;
                while (nalLength > 0 && inData[beginIndex + nalLength - 1] == 0) {
                    --nalLength;
                }
                if (nalLength > 0) {
                    nalsAdded = this.packetizeNAL(inData, beginIndex, nalLength) || nalsAdded;
                }
                beginIndex = nextBeginIndex + 3;
            }
        }
        this.nalsTimeStamp = inBuffer.getTimeStamp();
        return nalsAdded ? this.process(inBuffer, outBuffer) : 4;
    }

    public Format setInputFormat(Format in) {
        if (!(in instanceof VideoFormat) || AbstractCodecExt.matches(in, this.inputFormats) == null) {
            return null;
        }
        this.inputFormat = in;
        return in;
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof VideoFormat) || AbstractCodecExt.matches(format, this.getMatchingOutputFormats(this.inputFormat)) == null) {
            return null;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension size = null;
        if (this.inputFormat != null) {
            size = ((VideoFormat)this.inputFormat).getSize();
        }
        if (size == null && format.matches(this.outputFormat)) {
            size = ((VideoFormat)this.outputFormat).getSize();
        }
        Map<String, String> fmtps = null;
        if (format instanceof ParameterizedVideoFormat) {
            fmtps = ((ParameterizedVideoFormat)format).getFormatParameters();
        }
        if (fmtps == null) {
            fmtps = new HashMap<String, String>();
        }
        if (fmtps.get("packetization-mode") == null) {
            fmtps.put("packetization-mode", this.getPacketizationMode(this.inputFormat));
        }
        this.outputFormat = new ParameterizedVideoFormat(videoFormat.getEncoding(), size, -1, Format.byteArray, videoFormat.getFrameRate(), fmtps);
        return this.outputFormat;
    }
}

