/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.h263p;

import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractPacketizer;
import org.jitsi.impl.neomedia.codec.AbstractCodecExt;

public class Packetizer
extends AbstractPacketizer {
    private static final Format[] DEFAULT_OUTPUT_FORMATS = new Format[]{new VideoFormat("h263-1998/rtp")};
    public static final int MAX_PAYLOAD_SIZE = 1024;
    private static final String PLUGIN_NAME = "H263+ Packetizer";
    private int sequenceNumber = 0;
    private long timeStamp = 0L;
    private final List<byte[]> videoPkts = new LinkedList<byte[]>();

    private static int findStartcode(byte[] byteStream, int beginIndex, int endIndex) {
        while (beginIndex < endIndex - 3) {
            if (byteStream[beginIndex] == 0 && byteStream[beginIndex + 1] == 0 && (byteStream[beginIndex + 2] & 0xFFFFFF80) == -128) {
                return beginIndex;
            }
            ++beginIndex;
        }
        return endIndex;
    }

    public Packetizer() {
        this.inputFormats = new Format[]{new VideoFormat("H263-1998")};
        this.inputFormat = null;
        this.outputFormat = null;
    }

    public synchronized void close() {
        if (this.opened) {
            this.videoPkts.clear();
            this.opened = false;
            super.close();
        }
    }

    private Format[] getMatchingOutputFormats(Format inputFormat) {
        VideoFormat inputVideoFormat = (VideoFormat)inputFormat;
        return new Format[]{new VideoFormat("h263-1998/rtp", inputVideoFormat.getSize(), -1, Format.byteArray, inputVideoFormat.getFrameRate())};
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Format[] getSupportedOutputFormats(Format inputFormat) {
        if (inputFormat == null) {
            return DEFAULT_OUTPUT_FORMATS;
        }
        if (!(inputFormat instanceof VideoFormat) || AbstractCodecExt.matches(inputFormat, this.inputFormats) == null) {
            return new Format[0];
        }
        return this.getMatchingOutputFormats(inputFormat);
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (!this.opened) {
            this.videoPkts.clear();
            this.sequenceNumber = 0;
            super.open();
            this.opened = true;
        }
    }

    private boolean packetize(byte[] data, int offset, int length) {
        boolean pktAdded = false;
        while (length > 0) {
            boolean isPsc = false;
            int pos = 0;
            int maxPayloadLength = 1024;
            byte[] pkt = null;
            int payloadLength = 0;
            if (data.length > 3 && data[offset] == 0 && data[offset + 1] == 0) {
                isPsc = true;
                pos = 2;
            } else {
                maxPayloadLength -= 2;
            }
            payloadLength = length > maxPayloadLength ? maxPayloadLength : length;
            pkt = new byte[payloadLength + (isPsc ? 0 : 2)];
            pkt[0] = (byte)(isPsc ? 4 : 0);
            pkt[1] = 0;
            System.arraycopy(data, offset + pos, pkt, 2, payloadLength - pos);
            pktAdded = this.videoPkts.add(pkt) || pktAdded;
            offset += payloadLength;
            length -= payloadLength;
        }
        return pktAdded;
    }

    public int process(Buffer inBuffer, Buffer outBuffer) {
        int endIndex;
        int beginIndex;
        int inLength = inBuffer.getLength();
        byte[] inData = (byte[])inBuffer.getData();
        int inOffset = inBuffer.getOffset();
        boolean pktAdded = false;
        if (this.videoPkts.size() > 0) {
            byte[] pktData = this.videoPkts.remove(0);
            outBuffer.setData((Object)pktData);
            outBuffer.setLength(pktData.length);
            outBuffer.setOffset(0);
            outBuffer.setTimeStamp(this.timeStamp);
            outBuffer.setSequenceNumber((long)this.sequenceNumber++);
            if (this.videoPkts.size() > 0) {
                return 2;
            }
            outBuffer.setFlags(outBuffer.getFlags() | 0x800);
            return 0;
        }
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            this.reset();
            return 0;
        }
        if (inBuffer.isDiscard()) {
            outBuffer.setDiscard(true);
            this.reset();
            return 0;
        }
        Format inFormat = inBuffer.getFormat();
        if (inFormat != this.inputFormat && !inFormat.matches(this.inputFormat)) {
            this.setInputFormat(inFormat);
        }
        if ((beginIndex = Packetizer.findStartcode(inData, inOffset, endIndex = inOffset + inLength)) < endIndex) {
            while (beginIndex < endIndex) {
                int nextBeginIndex = Packetizer.findStartcode(inData, beginIndex + 3, endIndex);
                int length = nextBeginIndex - beginIndex;
                if (length > 0) {
                    pktAdded = this.packetize(inData, beginIndex, length) || pktAdded;
                    beginIndex += length;
                }
                beginIndex = nextBeginIndex + 3;
            }
        }
        this.timeStamp = inBuffer.getTimeStamp();
        if (pktAdded) {
            return this.process(inBuffer, outBuffer);
        }
        return 1;
    }

    public Format setInputFormat(Format in) {
        if (!(in instanceof VideoFormat) || null == AbstractCodecExt.matches(in, this.inputFormats)) {
            return null;
        }
        this.inputFormat = in;
        return in;
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof VideoFormat) || null == AbstractCodecExt.matches(format, this.getMatchingOutputFormats(this.inputFormat))) {
            return null;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension size = null;
        if (this.inputFormat != null) {
            size = ((VideoFormat)this.inputFormat).getSize();
        }
        if (size == null && format.matches(this.outputFormat)) {
            size = ((VideoFormat)this.outputFormat).getSize();
        }
        this.outputFormat = new VideoFormat(videoFormat.getEncoding(), size, -1, Format.byteArray, videoFormat.getFrameRate());
        return this.outputFormat;
    }
}

