/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import net.sf.fmj.media.AbstractCodec;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.video.AVFrame;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.control.FrameProcessingControlImpl;
import org.jitsi.util.Logger;

public class SwScale
extends AbstractCodec {
    private static final Logger logger = Logger.getLogger(SwScale.class);
    private static final int MIN_SWS_SCALE_HEIGHT_OR_WIDTH = 4;
    private final boolean fixOddYuv420Size;
    private final FrameProcessingControlImpl frameProcessingControl = new FrameProcessingControlImpl();
    private VideoFormat[] supportedOutputFormats = new VideoFormat[]{new RGBFormat(), new YUVFormat(2)};
    private long swsContext = 0L;

    private static int getFFmpegPixelFormat(RGBFormat rgb) {
        int pixfmt;
        block0 : switch (rgb.getBitsPerPixel()) {
            case 24: {
                pixfmt = FFmpeg.PIX_FMT_RGB24;
                break;
            }
            case 32: {
                switch (rgb.getRedMask()) {
                    case 1: 
                    case 255: {
                        pixfmt = FFmpeg.PIX_FMT_BGR32;
                        break block0;
                    }
                    case 2: 
                    case 65280: {
                        pixfmt = FFmpeg.PIX_FMT_BGR32_1;
                        break block0;
                    }
                    case 3: 
                    case 0xFF0000: {
                        pixfmt = FFmpeg.PIX_FMT_RGB32;
                        break block0;
                    }
                    case -16777216: 
                    case 4: {
                        pixfmt = FFmpeg.PIX_FMT_RGB32_1;
                        break block0;
                    }
                }
                pixfmt = -1;
                break;
            }
            default: {
                pixfmt = -1;
            }
        }
        return pixfmt;
    }

    private static VideoFormat setSize(VideoFormat format, Dimension size) {
        if (format instanceof RGBFormat) {
            RGBFormat rgbFormat = (RGBFormat)format;
            Class dataType = format.getDataType();
            int bitsPerPixel = rgbFormat.getBitsPerPixel();
            int pixelStride = rgbFormat.getPixelStride();
            if (pixelStride == -1 && dataType != null && bitsPerPixel != -1) {
                pixelStride = dataType.equals(Format.byteArray) ? bitsPerPixel / 8 : 1;
            }
            format = new RGBFormat(size, -1, dataType, format.getFrameRate(), bitsPerPixel, rgbFormat.getRedMask(), rgbFormat.getGreenMask(), rgbFormat.getBlueMask(), pixelStride, pixelStride == -1 || size == null ? -1 : pixelStride * size.width, rgbFormat.getFlipped(), rgbFormat.getEndian());
        } else if (format instanceof YUVFormat) {
            YUVFormat yuvFormat = (YUVFormat)format;
            format = new YUVFormat(size, -1, format.getDataType(), format.getFrameRate(), yuvFormat.getYuvType(), -1, -1, 0, -1, -1);
        } else if (format != null) {
            logger.warn("SwScale outputFormat of type " + format.getClass().getName() + " is not supported for optimized scaling.");
        }
        return format;
    }

    public SwScale() {
        this(false);
    }

    protected SwScale(boolean fixOddYuv420Size) {
        this.fixOddYuv420Size = fixOddYuv420Size;
        this.inputFormats = new Format[]{new AVFrameFormat(), new RGBFormat(), new YUVFormat(2)};
        this.addControl((Control)this.frameProcessingControl);
    }

    public void close() {
        try {
            if (this.swsContext != 0L) {
                FFmpeg.sws_freeContext(this.swsContext);
                this.swsContext = 0L;
            }
        }
        finally {
            super.close();
        }
    }

    public Format getInputFormat() {
        return super.getInputFormat();
    }

    public Dimension getOutputSize() {
        Format outputFormat = this.getOutputFormat();
        if (outputFormat == null) {
            outputFormat = this.supportedOutputFormats[0];
        }
        return ((VideoFormat)outputFormat).getSize();
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.supportedOutputFormats;
        }
        Dimension size = this.supportedOutputFormats[0].getSize();
        VideoFormat videoInput = (VideoFormat)input;
        if (size == null) {
            size = videoInput.getSize();
        }
        float frameRate = videoInput.getFrameRate();
        return new Format[]{new RGBFormat(size, -1, null, frameRate, 32, -1, -1, -1), new YUVFormat(size, -1, null, frameRate, 2, -1, -1, -1, -1, -1)};
    }

    public int process(Buffer input, Buffer output) {
        long srcPicture;
        int srcFmt;
        Dimension inputSize;
        int dstLength;
        int dstFmt;
        VideoFormat outputFormat;
        Format thisInputFormat;
        if (!this.checkInputBuffer(input)) {
            return 1;
        }
        if (this.isEOM(input)) {
            this.propagateEOM(output);
            return 0;
        }
        if (input.isDiscard() || this.frameProcessingControl.isMinimalProcessing()) {
            output.setDiscard(true);
            return 0;
        }
        VideoFormat inputFormat = (VideoFormat)input.getFormat();
        if (inputFormat != (thisInputFormat = this.getInputFormat()) && !inputFormat.equals((Object)thisInputFormat)) {
            this.setInputFormat((Format)inputFormat);
        }
        if ((outputFormat = (VideoFormat)this.getOutputFormat()) == null && (outputFormat = (VideoFormat)output.getFormat()) == null) {
            return 1;
        }
        Dimension outputSize = outputFormat.getSize();
        if (outputSize == null && (outputSize = inputFormat.getSize()) == null) {
            return 1;
        }
        int outputWidth = outputSize.width;
        int outputHeight = outputSize.height;
        if (outputWidth < 4 || outputHeight <= 4) {
            return 4;
        }
        if ((outputFormat = SwScale.setSize(outputFormat, outputSize)) == null) {
            return 1;
        }
        if (outputFormat instanceof RGBFormat) {
            dstFmt = SwScale.getFFmpegPixelFormat((RGBFormat)outputFormat);
            dstLength = outputWidth * outputHeight * 4;
        } else if (outputFormat instanceof YUVFormat) {
            dstFmt = 0;
            dstLength = outputWidth * outputHeight + 2 * ((outputWidth + 1) / 2) * ((outputHeight + 1) / 2);
        } else {
            return 1;
        }
        Class outputDataType = outputFormat.getDataType();
        Object dst = output.getData();
        if (Format.byteArray.equals(outputDataType)) {
            if (dst == null || ((byte[])dst).length < dstLength) {
                dst = new byte[dstLength];
            }
        } else if (Format.intArray.equals(outputDataType)) {
            dstLength = dstLength / 4 + (dstLength % 4 == 0 ? 0 : 1);
            if (dst == null || ((int[])dst).length < dstLength) {
                dst = new int[dstLength];
            }
        } else if (Format.shortArray.equals(outputDataType)) {
            dstLength = dstLength / 2 + (dstLength % 2 == 0 ? 0 : 1);
            if (dst == null || ((short[])dst).length < dstLength) {
                dst = new short[dstLength];
            }
        } else {
            logger.error("Unsupported output data type " + outputDataType);
            return 1;
        }
        if ((inputSize = inputFormat.getSize()) == null) {
            return 1;
        }
        int inputWidth = inputSize.width;
        int inputHeight = inputSize.height;
        if (inputWidth < 4 || inputHeight < 4) {
            return 4;
        }
        Object src = input.getData();
        if (src instanceof AVFrame) {
            srcFmt = ((AVFrameFormat)inputFormat).getPixFmt();
            srcPicture = ((AVFrame)src).getPtr();
        } else {
            srcFmt = inputFormat instanceof YUVFormat ? 0 : SwScale.getFFmpegPixelFormat((RGBFormat)inputFormat);
            srcPicture = 0L;
        }
        this.swsContext = FFmpeg.sws_getCachedContext(this.swsContext, inputWidth, inputHeight, srcFmt, outputWidth, outputHeight, dstFmt, 4);
        if (srcPicture == 0L) {
            FFmpeg.sws_scale(this.swsContext, src, srcFmt, inputWidth, inputHeight, 0, inputHeight, dst, dstFmt, outputWidth, outputHeight);
        } else {
            FFmpeg.sws_scale(this.swsContext, srcPicture, 0, inputHeight, dst, dstFmt, outputWidth, outputHeight);
        }
        output.setData(dst);
        output.setDuration(input.getDuration());
        output.setFlags(input.getFlags());
        output.setFormat((Format)outputFormat);
        output.setLength(dstLength);
        output.setOffset(0);
        output.setSequenceNumber(input.getSequenceNumber());
        output.setTimeStamp(input.getTimeStamp());
        int inFlags = input.getFlags();
        int outFlags = output.getFlags();
        if ((inFlags & 0x8000) != 0) {
            outFlags |= 0x8000;
        }
        if ((inFlags & 0x40) != 0) {
            outFlags |= 0x40;
        }
        if ((inFlags & 0x100) != 0) {
            outFlags |= 0x100;
        }
        if ((inFlags & 0x1000) != 0) {
            outFlags |= 0x1000;
        }
        if ((inFlags & 0x80) != 0) {
            outFlags |= 0x80;
        }
        output.setFlags(outFlags);
        return 0;
    }

    public Format setInputFormat(Format format) {
        Format inputFormat;
        Format format2 = inputFormat = format instanceof VideoFormat ? super.setInputFormat(format) : null;
        if (inputFormat != null && logger.isDebugEnabled()) {
            logger.debug("SwScale set to input in " + inputFormat);
        }
        return inputFormat;
    }

    public Format setOutputFormat(Format format) {
        Dimension size;
        YUVFormat yuvFormat;
        if (this.fixOddYuv420Size && format instanceof YUVFormat && 2 == (yuvFormat = (YUVFormat)format).getYuvType() && (size = yuvFormat.getSize()) != null && size.width > 2 && size.height > 2) {
            int width = size.width >> 1 << 1;
            int height = size.height >> 1 << 1;
            if (width != size.width || height != size.height) {
                format = new YUVFormat(new Dimension(width, height), -1, yuvFormat.getDataType(), yuvFormat.getFrameRate(), yuvFormat.getYuvType(), -1, -1, 0, -1, -1);
            }
        }
        Format outputFormat = super.setOutputFormat(format);
        if (logger.isDebugEnabled() && outputFormat != null) {
            logger.debug("SwScale set to output in " + outputFormat);
        }
        return outputFormat;
    }

    private void setOutputFormatSize(Dimension size) {
        VideoFormat outputFormat = (VideoFormat)this.getOutputFormat();
        if (outputFormat != null && (outputFormat = SwScale.setSize(outputFormat, size)) != null) {
            this.setOutputFormat((Format)outputFormat);
        }
    }

    public void setOutputSize(Dimension size) {
        int i = 0;
        while (i < this.supportedOutputFormats.length) {
            this.supportedOutputFormats[i] = SwScale.setSize(this.supportedOutputFormats[i], size);
            ++i;
        }
        this.setOutputFormatSize(size);
    }
}

