/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.speex;

import java.util.ArrayList;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import net.java.sip.communicator.impl.neomedia.codec.audio.speex.Speex;
import org.jitsi.impl.neomedia.codec.AbstractCodecExt;

public class SpeexResampler
extends AbstractCodecExt {
    private static final Format[] SUPPORTED_FORMATS;
    private static final double[] SUPPORTED_SAMPLE_RATES;
    private int inputSampleRate;
    private int outputSampleRate;
    private long resampler;

    public SpeexResampler() {
        super("Speex Resampler", AudioFormat.class, SUPPORTED_FORMATS);
        this.inputFormats = SUPPORTED_FORMATS;
    }

    protected void doClose() {
        if (this.resampler != 0L) {
            Speex.speex_resampler_destroy(this.resampler);
            this.resampler = 0L;
        }
    }

    protected void doOpen() throws ResourceUnavailableException {
    }

    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        AudioFormat outputAudioFormat;
        int outputSampleRate;
        Format inputFormat = inputBuffer.getFormat();
        if (inputFormat != null && inputFormat != this.inputFormat && !inputFormat.equals((Object)this.inputFormat) && null == this.setInputFormat(inputFormat)) {
            return 1;
        }
        inputFormat = this.inputFormat;
        AudioFormat inputAudioFormat = (AudioFormat)inputFormat;
        int inputSampleRate = (int)inputAudioFormat.getSampleRate();
        if (inputSampleRate == (outputSampleRate = (int)(outputAudioFormat = (AudioFormat)this.getOutputFormat()).getSampleRate())) {
            Class inputDataType = inputAudioFormat.getDataType();
            Class outputDataType = outputAudioFormat.getDataType();
            if (Format.byteArray.equals(inputDataType)) {
                byte[] input = (byte[])inputBuffer.getData();
                if (Format.byteArray.equals(outputDataType)) {
                    int length = input == null ? 0 : input.length;
                    byte[] output = this.validateByteArraySize(outputBuffer, length);
                    if (input != null && output != null) {
                        System.arraycopy(input, 0, output, 0, length);
                    }
                    outputBuffer.setFormat(inputBuffer.getFormat());
                    outputBuffer.setLength(inputBuffer.getLength());
                    outputBuffer.setOffset(inputBuffer.getOffset());
                } else {
                    int inputLength = inputBuffer.getLength();
                    int outputOffset = 0;
                    int outputLength = inputLength / 2;
                    short[] output = this.validateShortArraySize(outputBuffer, outputLength);
                    int i = inputBuffer.getOffset();
                    for (int o = outputOffset; o < outputLength; ++o) {
                        output[o] = (short)(input[i++] & 0xFF | (input[i++] & 0xFF) << 8);
                    }
                    outputBuffer.setFormat((Format)outputAudioFormat);
                    outputBuffer.setLength(outputLength);
                    outputBuffer.setOffset(outputOffset);
                }
            } else {
                short[] input = (short[])inputBuffer.getData();
                if (Format.byteArray.equals(outputDataType)) {
                    int inputLength = inputBuffer.getLength();
                    int outputOffset = 0;
                    int outputLength = inputLength * 2;
                    byte[] output = this.validateByteArraySize(outputBuffer, outputLength);
                    int i = inputBuffer.getOffset();
                    int o = outputOffset;
                    while (o < outputLength) {
                        short s = input[i];
                        output[o++] = (byte)(s & 0xFF);
                        output[o++] = (byte)((s & 0xFF00) >>> 8);
                        ++i;
                    }
                    outputBuffer.setFormat((Format)outputAudioFormat);
                    outputBuffer.setLength(outputLength);
                    outputBuffer.setOffset(outputOffset);
                } else {
                    int length = input == null ? 0 : input.length;
                    short[] output = this.validateShortArraySize(outputBuffer, length);
                    if (input != null && output != null) {
                        System.arraycopy(input, 0, output, 0, length);
                    }
                    outputBuffer.setFormat(inputBuffer.getFormat());
                    outputBuffer.setLength(inputBuffer.getLength());
                    outputBuffer.setOffset(inputBuffer.getOffset());
                }
            }
        } else {
            if (this.inputSampleRate != inputSampleRate || this.outputSampleRate != outputSampleRate) {
                if (this.resampler == 0L) {
                    this.resampler = Speex.speex_resampler_init(1, inputSampleRate, outputSampleRate, 3, 0L);
                } else {
                    Speex.speex_resampler_set_rate(this.resampler, inputSampleRate, outputSampleRate);
                }
                if (this.resampler != 0L) {
                    this.inputSampleRate = inputSampleRate;
                    this.outputSampleRate = outputSampleRate;
                }
            }
            if (this.resampler == 0L) {
                return 1;
            }
            byte[] input = (byte[])inputBuffer.getData();
            int inputLength = inputBuffer.getLength();
            int sampleSizeInBytes = inputAudioFormat.getSampleSizeInBits() / 8;
            int inputSampleCount = inputLength / sampleSizeInBytes;
            int outputLength = inputLength * outputSampleRate / inputSampleRate;
            byte[] output = this.validateByteArraySize(outputBuffer, outputLength);
            int outputSampleCount = outputLength / sampleSizeInBytes;
            outputSampleCount = Speex.speex_resampler_process_interleaved_int(this.resampler, input, inputBuffer.getOffset(), inputSampleCount, output, 0, outputSampleCount);
            outputBuffer.setFormat((Format)outputAudioFormat);
            outputBuffer.setLength(outputSampleCount * sampleSizeInBytes);
            outputBuffer.setOffset(0);
        }
        outputBuffer.setDuration(inputBuffer.getDuration());
        outputBuffer.setEOM(inputBuffer.isEOM());
        outputBuffer.setFlags(inputBuffer.getFlags());
        outputBuffer.setHeader(inputBuffer.getHeader());
        outputBuffer.setSequenceNumber(inputBuffer.getSequenceNumber());
        outputBuffer.setTimeStamp(inputBuffer.getTimeStamp());
        return 0;
    }

    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        Class inputFormatDataType = inputFormat.getDataType();
        ArrayList<Format> matchingOutputFormats = new ArrayList<Format>();
        for (Format supportedFormat : SUPPORTED_FORMATS) {
            if ((!Format.byteArray.equals(supportedFormat.getDataType()) || !Format.byteArray.equals(inputFormatDataType)) && ((AudioFormat)supportedFormat).getSampleRate() != ((AudioFormat)inputFormat).getSampleRate()) continue;
            matchingOutputFormats.add(supportedFormat);
        }
        return matchingOutputFormats.toArray(new Format[matchingOutputFormats.size()]);
    }

    public Format setInputFormat(Format format) {
        AudioFormat inputFormat = (AudioFormat)super.setInputFormat(format);
        if (inputFormat != null) {
            Class outputDataType;
            double outputSampleRate;
            if (this.outputFormat == null) {
                outputSampleRate = inputFormat.getSampleRate();
                outputDataType = inputFormat.getDataType();
            } else {
                AudioFormat outputAudioFormat = (AudioFormat)this.outputFormat;
                outputSampleRate = outputAudioFormat.getSampleRate();
                outputDataType = outputAudioFormat.getDataType();
                if (outputSampleRate != inputFormat.getSampleRate()) {
                    outputDataType = inputFormat.getDataType();
                }
            }
            this.setOutputFormat((Format)new AudioFormat(inputFormat.getEncoding(), outputSampleRate, inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getEndian(), inputFormat.getSigned(), -1, -1.0, outputDataType));
        }
        return inputFormat;
    }

    static {
        SUPPORTED_SAMPLE_RATES = new double[]{8000.0, 11025.0, 12000.0, 16000.0, 22050.0, 24000.0, 32000.0, 44100.0, 48000.0, -1.0};
        Speex.assertSpeexIsFunctional();
        int supportedCount = SUPPORTED_SAMPLE_RATES.length;
        SUPPORTED_FORMATS = new Format[2 * supportedCount];
        for (int i = 0; i < supportedCount; ++i) {
            int j = 2 * i;
            SpeexResampler.SUPPORTED_FORMATS[j] = new AudioFormat("LINEAR", SUPPORTED_SAMPLE_RATES[i], 16, 1, 0, 1, -1, -1.0, Format.byteArray);
            SpeexResampler.SUPPORTED_FORMATS[j + 1] = new AudioFormat("LINEAR", SUPPORTED_SAMPLE_RATES[i], 16, 1, 0, 1, -1, -1.0, Format.shortArray);
        }
    }
}

