/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_range_coder_state;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_code_signs;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_range_coder;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_shell_coder;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_tables_other;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_tables_pulses_per_block;

public class Silk_encode_pulses {
    static int combine_and_check(int[] pulses_comb, int[] pulses_in, int pulses_in_offset, int max_pulses, int len) {
        for (int k = 0; k < len; ++k) {
            int sum = pulses_in[pulses_in_offset + 2 * k] + pulses_in[pulses_in_offset + 2 * k + 1];
            if (sum > max_pulses) {
                return 1;
            }
            pulses_comb[k] = sum;
        }
        return 0;
    }

    static void SKP_Silk_encode_pulses(SKP_Silk_range_coder_state psRC, int sigtype, int QuantOffsetType, byte[] q, int frame_length) {
        int k;
        int i;
        int RateLevelIndex = 0;
        int[] abs_pulses = new int[480];
        int[] sum_pulses = new int[30];
        int[] nRshifts = new int[30];
        int[] pulses_comb = new int[8];
        int iter = frame_length / 16;
        for (i = 0; i < frame_length; i += 4) {
            abs_pulses[i + 0] = q[i + 0] > 0 ? q[i + 0] : -q[i + 0];
            abs_pulses[i + 1] = q[i + 1] > 0 ? q[i + 1] : -q[i + 1];
            abs_pulses[i + 2] = q[i + 2] > 0 ? q[i + 2] : -q[i + 2];
            abs_pulses[i + 3] = q[i + 3] > 0 ? q[i + 3] : -q[i + 3];
        }
        int[] abs_pulses_ptr = abs_pulses;
        int abs_pulses_ptr_offset = 0;
        for (i = 0; i < iter; ++i) {
            nRshifts[i] = 0;
            block2: while (true) {
                int scale_down = Silk_encode_pulses.combine_and_check(pulses_comb, abs_pulses_ptr, abs_pulses_ptr_offset, Silk_tables_pulses_per_block.SKP_Silk_max_pulses_table[0], 8);
                scale_down += Silk_encode_pulses.combine_and_check(pulses_comb, pulses_comb, 0, Silk_tables_pulses_per_block.SKP_Silk_max_pulses_table[1], 4);
                scale_down += Silk_encode_pulses.combine_and_check(pulses_comb, pulses_comb, 0, Silk_tables_pulses_per_block.SKP_Silk_max_pulses_table[2], 2);
                sum_pulses[i] = pulses_comb[0] + pulses_comb[1];
                if (sum_pulses[i] > Silk_tables_pulses_per_block.SKP_Silk_max_pulses_table[3]) {
                    ++scale_down;
                }
                if (scale_down == 0) break;
                int n = i;
                nRshifts[n] = nRshifts[n] + 1;
                k = 0;
                while (true) {
                    if (k >= 16) continue block2;
                    abs_pulses_ptr[abs_pulses_ptr_offset + k] = abs_pulses_ptr[abs_pulses_ptr_offset + k] >> 1;
                    ++k;
                }
                break;
            }
            abs_pulses_ptr_offset += 16;
        }
        int minSumBits_Q6 = Integer.MAX_VALUE;
        for (k = 0; k < 9; ++k) {
            short[] nBits_ptr = Silk_tables_pulses_per_block.SKP_Silk_pulses_per_block_BITS_Q6[k];
            int sumBits_Q6 = Silk_tables_pulses_per_block.SKP_Silk_rate_levels_BITS_Q6[sigtype][k];
            for (i = 0; i < iter; ++i) {
                if (nRshifts[i] > 0) {
                    sumBits_Q6 += nBits_ptr[19];
                    continue;
                }
                sumBits_Q6 += nBits_ptr[sum_pulses[i]];
            }
            if (sumBits_Q6 >= minSumBits_Q6) continue;
            minSumBits_Q6 = sumBits_Q6;
            RateLevelIndex = k;
        }
        Silk_range_coder.SKP_Silk_range_encoder(psRC, RateLevelIndex, Silk_tables_pulses_per_block.SKP_Silk_rate_levels_CDF[sigtype], 0);
        int[] cdf_ptr = Silk_tables_pulses_per_block.SKP_Silk_pulses_per_block_CDF[RateLevelIndex];
        for (i = 0; i < iter; ++i) {
            if (nRshifts[i] == 0) {
                Silk_range_coder.SKP_Silk_range_encoder(psRC, sum_pulses[i], cdf_ptr, 0);
                continue;
            }
            Silk_range_coder.SKP_Silk_range_encoder(psRC, 19, cdf_ptr, 0);
            for (k = 0; k < nRshifts[i] - 1; ++k) {
                Silk_range_coder.SKP_Silk_range_encoder(psRC, 19, Silk_tables_pulses_per_block.SKP_Silk_pulses_per_block_CDF[9], 0);
            }
            Silk_range_coder.SKP_Silk_range_encoder(psRC, sum_pulses[i], Silk_tables_pulses_per_block.SKP_Silk_pulses_per_block_CDF[9], 0);
        }
        for (i = 0; i < iter; ++i) {
            if (sum_pulses[i] <= 0) continue;
            Silk_shell_coder.SKP_Silk_shell_encoder(psRC, abs_pulses, i * 16);
        }
        for (i = 0; i < iter; ++i) {
            if (nRshifts[i] <= 0) continue;
            byte[] pulses_ptr = q;
            int pulses_ptr_offset = i * 16;
            int nLS = nRshifts[i] - 1;
            for (k = 0; k < 16; ++k) {
                int bit;
                byte abs_q = pulses_ptr[pulses_ptr_offset + k] > 0 ? pulses_ptr[pulses_ptr_offset + k] : -pulses_ptr[pulses_ptr_offset + k];
                for (int j = nLS; j > 0; --j) {
                    bit = abs_q >> j & 1;
                    Silk_range_coder.SKP_Silk_range_encoder(psRC, bit, Silk_tables_other.SKP_Silk_lsb_CDF, 0);
                }
                bit = abs_q & 1;
                Silk_range_coder.SKP_Silk_range_encoder(psRC, bit, Silk_tables_other.SKP_Silk_lsb_CDF, 0);
            }
        }
        Silk_code_signs.SKP_Silk_encode_signs(psRC, q, frame_length, sigtype, QuantOffsetType, RateLevelIndex);
    }
}

