/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import org.jitsi.impl.neomedia.codec.audio.silk.Silk_Inlines_constants;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_SigProc_FIX;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_macros;

public class Silk_Inlines
extends Silk_Inlines_constants {
    static int SKP_Silk_CLZ64(long in) {
        return Long.numberOfLeadingZeros(in);
    }

    static void SKP_Silk_CLZ_FRAC(int in, int[] lz, int[] frac_Q7) {
        int lzeros;
        lz[0] = lzeros = Integer.numberOfLeadingZeros(in);
        frac_Q7[0] = Silk_SigProc_FIX.SKP_ROR32(in, 24 - lzeros) & 0x7F;
    }

    static int SKP_Silk_SQRT_APPROX(int x) {
        int[] lz = new int[1];
        int[] frac_Q7 = new int[1];
        if (x <= 0) {
            return 0;
        }
        Silk_Inlines.SKP_Silk_CLZ_FRAC(x, lz, frac_Q7);
        int y = (lz[0] & 1) != 0 ? 32768 : 46214;
        y >>= lz[0] >> 1;
        y = Silk_macros.SKP_SMLAWB(y, y, Silk_macros.SKP_SMULBB(213, frac_Q7[0]));
        return y;
    }

    static int SKP_Silk_norm16(short a) {
        if (a << 1 == 0) {
            return 0;
        }
        int a32 = a;
        a32 ^= a32 >> 31;
        return Integer.numberOfLeadingZeros(a32) - 17;
    }

    static int SKP_Silk_norm32(int a) {
        if (a << 1 == 0) {
            return 0;
        }
        a ^= a >> 31;
        return Integer.numberOfLeadingZeros(a) - 1;
    }

    static int SKP_DIV32_varQ(int a32, int b32, int Qres) {
        assert (b32 != 0);
        assert (Qres >= 0);
        int a_headrm = Integer.numberOfLeadingZeros(Math.abs(a32)) - 1;
        int a32_nrm = a32 << a_headrm;
        int b_headrm = Integer.numberOfLeadingZeros(Math.abs(b32)) - 1;
        int b32_nrm = b32 << b_headrm;
        int b32_inv = 0x1FFFFFFF / (b32_nrm >> 16);
        int result = Silk_macros.SKP_SMULWB(a32_nrm, b32_inv);
        a32_nrm -= Silk_SigProc_FIX.SKP_SMMUL(b32_nrm, result) << 3;
        result = Silk_macros.SKP_SMLAWB(result, a32_nrm, b32_inv);
        int lshift = 29 + a_headrm - b_headrm - Qres;
        if (lshift <= 0) {
            return Silk_SigProc_FIX.SKP_LSHIFT_SAT32(result, -lshift);
        }
        if (lshift < 32) {
            return result >> lshift;
        }
        return 0;
    }

    static int SKP_INVERSE32_varQ(int b32, int Qres) {
        assert (b32 != 0);
        assert (Qres > 0);
        int b_headrm = Integer.numberOfLeadingZeros(Math.abs(b32)) - 1;
        int b32_nrm = b32 << b_headrm;
        int b32_inv = 0x1FFFFFFF / (b32_nrm >> 16);
        int result = b32_inv << 16;
        int err_Q32 = -Silk_macros.SKP_SMULWB(b32_nrm, b32_inv) << 3;
        result = Silk_macros.SKP_SMLAWW(result, err_Q32, b32_inv);
        int lshift = 61 - b_headrm - Qres;
        if (lshift <= 0) {
            return Silk_SigProc_FIX.SKP_LSHIFT_SAT32(result, -lshift);
        }
        if (lshift < 32) {
            return result >> lshift;
        }
        return 0;
    }

    static int SKP_Silk_SIN_APPROX_Q24(int x) {
        int y_Q30;
        if ((x &= 0xFFFF) <= 32768) {
            x = x < 16384 ? 16384 - x : (x -= 16384);
            if (x < 1100) {
                return Silk_macros.SKP_SMLAWB(0x1000000, x * x, -5053);
            }
            x = Silk_macros.SKP_SMULWB(x << 8, x);
            y_Q30 = Silk_macros.SKP_SMLAWB(1059577, x, -5013);
            y_Q30 = Silk_macros.SKP_SMLAWW(-82778932, x, y_Q30);
            y_Q30 = Silk_macros.SKP_SMLAWW(1073735466, x, y_Q30);
        } else {
            x = x < 49152 ? 49152 - x : (x -= 49152);
            if (x < 1100) {
                return Silk_macros.SKP_SMLAWB(-16777216, x * x, 5053);
            }
            x = Silk_macros.SKP_SMULWB(x << 8, x);
            y_Q30 = Silk_macros.SKP_SMLAWB(-1059577, x, 5013);
            y_Q30 = Silk_macros.SKP_SMLAWW(82778932, x, y_Q30);
            y_Q30 = Silk_macros.SKP_SMLAWW(-1073735400, x, y_Q30);
        }
        return Silk_SigProc_FIX.SKP_RSHIFT_ROUND(y_Q30, 6);
    }

    static int SKP_Silk_COS_APPROX_Q24(int x) {
        return Silk_Inlines.SKP_Silk_SIN_APPROX_Q24(x + 16384);
    }
}

