/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import java.awt.Component;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodecExt;
import org.jitsi.impl.neomedia.codec.audio.silk.JavaEncoder;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_SILK_SDK_DecControlStruct;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_decoder_state;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_dec_API;
import org.jitsi.service.neomedia.control.FECDecoderControl;
import org.jitsi.util.Logger;

public class JavaDecoder
extends AbstractCodecExt {
    private final Logger logger = Logger.getLogger(JavaDecoder.class);
    static final int FRAME_DURATION = 20;
    private static final int MAX_FRAMES_PER_PAYLOAD = 5;
    private static final Format[] SUPPORTED_INPUT_FORMATS = JavaEncoder.SUPPORTED_OUTPUT_FORMATS;
    private static final Format[] SUPPORTED_OUTPUT_FORMATS = JavaEncoder.SUPPORTED_INPUT_FORMATS;
    private SKP_SILK_SDK_DecControlStruct decControl;
    private SKP_Silk_decoder_state decState;
    private short frameLength;
    private int framesPerPayload;
    private final short[] outputLength = new short[1];
    private long lastPacketSeq;
    private boolean firstPacketProcessed = false;
    private byte[] lbrrData = new byte[250];
    private short[] lbrrBytes = new short[1];
    private int nbPacketsDecoded = 0;
    private int nbFECDecoded = 0;
    private int nbFECNotDecoded = 0;
    private int nbPacketsLost = 0;

    public JavaDecoder() {
        super("SILK Decoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
        this.addControl(new Stats());
    }

    protected void doClose() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Packets decoded normally: " + this.nbPacketsDecoded);
            this.logger.debug("Packets decoded with FEC: " + this.nbFECDecoded);
            this.logger.debug("Packets lost (subsequent missing):" + this.nbPacketsLost);
            this.logger.debug("Packets lost (no FEC in subsequent): " + this.nbFECNotDecoded);
        }
        this.decState = null;
        this.decControl = null;
    }

    protected void doOpen() throws ResourceUnavailableException {
        this.decState = new SKP_Silk_decoder_state();
        if (Silk_dec_API.SKP_Silk_SDK_InitDecoder(this.decState) != 0) {
            throw new ResourceUnavailableException("Silk_dec_API.SKP_Silk_SDK_InitDecoder");
        }
        AudioFormat inputFormat = (AudioFormat)this.getInputFormat();
        double sampleRate = inputFormat.getSampleRate();
        int channels = inputFormat.getChannels();
        this.decControl = new SKP_SILK_SDK_DecControlStruct();
        this.decControl.API_sampleRate = (int)sampleRate;
        this.frameLength = (short)(20.0 * sampleRate * (double)channels / 1000.0);
    }

    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        int processed;
        byte[] inputData = (byte[])inputBuffer.getData();
        int inputOffset = inputBuffer.getOffset();
        int inputLength = inputBuffer.getLength();
        short[] outputData = this.validateShortArraySize(outputBuffer, this.frameLength);
        int outputOffset = 0;
        boolean decodeFEC = false;
        long sequenceNumber = inputBuffer.getSequenceNumber();
        if (this.firstPacketProcessed && sequenceNumber != this.lastPacketSeq && sequenceNumber != this.lastPacketSeq + 1L && (this.lastPacketSeq != 65535L || sequenceNumber != 0L)) {
            decodeFEC = true;
            this.nbPacketsLost = sequenceNumber > this.lastPacketSeq ? (int)((long)this.nbPacketsLost + (sequenceNumber - this.lastPacketSeq - 1L)) : (int)((long)this.nbPacketsLost + (65535L - this.lastPacketSeq + sequenceNumber - 1L));
        }
        if (!decodeFEC) {
            this.outputLength[0] = this.frameLength;
            if (Silk_dec_API.SKP_Silk_SDK_Decode(this.decState, this.decControl, 0, inputData, inputOffset, inputLength, outputData, outputOffset, this.outputLength) == 0) {
                outputBuffer.setDuration(20000000L);
                outputBuffer.setLength((int)this.outputLength[0]);
                outputBuffer.setOffset(outputOffset);
                if (this.decControl.moreInternalDecoderFrames == 0) {
                    ++this.nbPacketsDecoded;
                    processed = 0;
                } else {
                    ++this.framesPerPayload;
                    if (this.framesPerPayload >= 5) {
                        ++this.nbPacketsDecoded;
                        processed = 0;
                    } else {
                        processed = 2;
                    }
                }
            } else {
                processed = 1;
            }
            if ((processed & 2) != 2) {
                this.framesPerPayload = 0;
            }
        } else {
            this.outputLength[0] = this.frameLength;
            this.lbrrBytes[0] = 0;
            Silk_dec_API.SKP_Silk_SDK_search_for_LBRR(inputData, inputOffset, (short)inputLength, 1, this.lbrrData, 0, this.lbrrBytes);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Packet loss detected. Last seen " + this.lastPacketSeq + ", current " + sequenceNumber);
                this.logger.trace("Looking for FEC data, found " + this.lbrrBytes[0] + "bytes");
            }
            if (this.lbrrBytes[0] == 0) {
                ++this.nbFECNotDecoded;
                processed = 2;
            } else if (Silk_dec_API.SKP_Silk_SDK_Decode(this.decState, this.decControl, 0, this.lbrrData, 0, this.lbrrBytes[0], outputData, outputOffset, this.outputLength) == 0) {
                ++this.nbFECDecoded;
                outputBuffer.setDuration(20000000L);
                outputBuffer.setLength((int)this.outputLength[0]);
                outputBuffer.setOffset(outputOffset);
                processed = 2;
            } else {
                processed = 1;
            }
        }
        this.lastPacketSeq = sequenceNumber;
        this.firstPacketProcessed = true;
        return processed;
    }

    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        return JavaEncoder.getMatchingOutputFormats(inputFormat, SUPPORTED_INPUT_FORMATS, SUPPORTED_OUTPUT_FORMATS);
    }

    private class Stats
    implements FECDecoderControl {
        private Stats() {
        }

        public int fecPacketsDecoded() {
            return JavaDecoder.this.nbFECDecoded;
        }

        public Component getControlComponent() {
            return null;
        }
    }
}

