/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.mp3;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodecExt;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.util.Logger;

public class JNIEncoder
extends AbstractCodecExt {
    private static final Logger logger = Logger.getLogger(JNIEncoder.class);
    private static final Format[] SUPPORTED_INPUT_FORMATS = new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)};
    private static final Format[] SUPPORTED_OUTPUT_FORMATS = new Format[]{new AudioFormat("mpeglayer3")};
    private long avctx;
    private int frameSizeInBytes;
    private byte[] prevInput;
    private int prevInputLength;

    public JNIEncoder() {
        super("MP3 JNI Encoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
    }

    protected synchronized void doClose() {
        if (this.avctx != 0L) {
            FFmpeg.avcodec_close(this.avctx);
            FFmpeg.av_free(this.avctx);
            this.avctx = 0L;
        }
        this.prevInput = null;
        this.prevInputLength = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void doOpen() throws ResourceUnavailableException {
        block10: {
            long encoder = FFmpeg.avcodec_find_encoder(86017);
            if (encoder == 0L) {
                throw new ResourceUnavailableException("Could not find FFmpeg encoder CODEC_ID_MP3");
            }
            this.avctx = FFmpeg.avcodec_alloc_context3(encoder);
            if (this.avctx == 0L) {
                throw new ResourceUnavailableException("Could not allocate AVCodecContext for FFmpeg encoder CODEC_ID_MP3");
            }
            int avcodec_open = -1;
            try {
                AudioFormat inputFormat = (AudioFormat)this.getInputFormat();
                int channels = inputFormat.getChannels();
                int sampleRate = (int)inputFormat.getSampleRate();
                if (channels == -1) {
                    channels = 1;
                }
                FFmpeg.avcodeccontext_set_bit_rate(this.avctx, 128000);
                FFmpeg.avcodeccontext_set_channels(this.avctx, channels);
                try {
                    FFmpeg.avcodeccontext_set_sample_fmt(this.avctx, 1);
                }
                catch (UnsatisfiedLinkError ule) {
                    logger.warn("The FFmpeg JNI library is out-of-date.");
                }
                if (sampleRate != -1) {
                    FFmpeg.avcodeccontext_set_sample_rate(this.avctx, sampleRate);
                }
                avcodec_open = FFmpeg.avcodec_open2(this.avctx, encoder, new String[0]);
                this.frameSizeInBytes = FFmpeg.avcodeccontext_get_frame_size(this.avctx) * (inputFormat.getSampleSizeInBits() / 8) * channels;
                Object var9_7 = null;
                if (avcodec_open >= 0) break block10;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (avcodec_open < 0) {
                    FFmpeg.av_free(this.avctx);
                    this.avctx = 0L;
                }
                throw throwable;
            }
            FFmpeg.av_free(this.avctx);
            this.avctx = 0L;
        }
        if (this.avctx == 0L) {
            throw new ResourceUnavailableException("Could not open FFmpeg encoder CODEC_ID_MP3");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        int outputLength;
        byte[] input = (byte[])inputBuffer.getData();
        int inputLength = inputBuffer.getLength();
        int inputOffset = inputBuffer.getOffset();
        if (this.prevInputLength > 0 || inputLength < this.frameSizeInBytes) {
            int newPrevInputLength = Math.min(this.frameSizeInBytes - this.prevInputLength, inputLength);
            if (newPrevInputLength > 0) {
                if (this.prevInput == null) {
                    this.prevInput = new byte[this.frameSizeInBytes];
                    this.prevInputLength = 0;
                }
                System.arraycopy(input, inputOffset, this.prevInput, this.prevInputLength, newPrevInputLength);
                inputBuffer.setLength(inputLength - newPrevInputLength);
                inputBuffer.setOffset(inputOffset + newPrevInputLength);
                this.prevInputLength += newPrevInputLength;
                if (this.prevInputLength != this.frameSizeInBytes) return 4;
                input = this.prevInput;
                inputLength = this.prevInputLength;
                inputOffset = 0;
                this.prevInputLength = 0;
            }
        } else {
            inputBuffer.setLength(inputLength - this.frameSizeInBytes);
            inputBuffer.setOffset(inputOffset + this.frameSizeInBytes);
        }
        Object outputData = outputBuffer.getData();
        byte[] output = outputData instanceof byte[] ? (byte[])outputData : null;
        int outputOffset = outputBuffer.getOffset();
        int minOutputLength = Math.max(16384, inputLength);
        if (output == null || output.length - outputOffset < minOutputLength) {
            output = new byte[minOutputLength];
            outputBuffer.setData((Object)output);
            outputOffset = 0;
            outputBuffer.setOffset(outputOffset);
        }
        if ((outputLength = FFmpeg.avcodec_encode_audio(this.avctx, output, outputOffset, output.length - outputOffset, input, inputOffset)) < 0) {
            return 1;
        }
        outputBuffer.setLength(outputLength);
        if (inputBuffer.getLength() <= 0) return 0;
        return 2;
    }

    static {
        if (FFmpeg.avcodec_find_encoder(86017) == 0L) {
            throw new RuntimeException("Could not find FFmpeg encoder CODEC_ID_MP3");
        }
    }
}

