/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.ilbc;

import com.sun.media.controls.SilenceSuppressionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodecExt;
import org.jitsi.impl.neomedia.codec.audio.ilbc.ilbc_decoder;

public class JavaDecoder
extends AbstractCodecExt {
    private ilbc_decoder dec;
    private int inputLength;
    private List<Integer> offsets = new ArrayList<Integer>();

    public JavaDecoder() {
        super("iLBC Decoder", AudioFormat.class, new Format[]{new AudioFormat("LINEAR")});
        this.inputFormats = new Format[]{new AudioFormat("ilbc/rtp", 8000.0, 16, 1, -1, -1)};
        this.addControl((Control)new SilenceSuppressionAdapter((Codec)this, false, false));
    }

    protected void doClose() {
        this.dec = null;
        this.inputLength = 0;
    }

    protected void doOpen() {
    }

    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        byte[] input = (byte[])inputBuffer.getData();
        int inputLength = inputBuffer.getLength();
        if (this.offsets.size() == 0 && (inputLength > 38 && inputLength != 50 || inputLength > 50)) {
            int nb = 0;
            int len = 0;
            if (inputLength % 38 == 0) {
                nb = inputLength % 38;
                len = 38;
            } else if (inputLength % 50 == 0) {
                nb = inputLength % 50;
                len = 50;
            }
            if (this.inputLength != len) {
                this.initDec(len);
            }
            for (int i = 0; i < nb; ++i) {
                this.offsets.add(new Integer(inputLength + i * len));
            }
        } else if (this.inputLength != inputLength) {
            this.initDec(inputLength);
        }
        int outputLength = this.dec.ULP_inst.blockl * 2;
        byte[] output = this.validateByteArraySize(outputBuffer, outputLength);
        int outputOffset = 0;
        int offsetToAdd = 0;
        if (this.offsets.size() > 0) {
            offsetToAdd = this.offsets.remove(0);
        }
        this.dec.decode(output, outputOffset, input, inputBuffer.getOffset() + offsetToAdd, (short)1);
        this.updateOutput(outputBuffer, this.getOutputFormat(), outputLength, outputOffset);
        int flags = 0;
        if (this.offsets.size() > 0) {
            flags |= 2;
        }
        return flags;
    }

    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        AudioFormat inputAudioFormat = (AudioFormat)inputFormat;
        return new AudioFormat[]{new AudioFormat("LINEAR", inputAudioFormat.getSampleRate(), 16, 1, 0, 1)};
    }

    private void initDec(int inputLength) {
        int mode;
        switch (inputLength) {
            case 38: {
                mode = 20;
                break;
            }
            case 50: {
                mode = 30;
                break;
            }
            default: {
                throw new IllegalArgumentException("inputLength");
            }
        }
        this.dec = new ilbc_decoder(mode, 1);
        this.inputLength = inputLength;
    }
}

