/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.g729;

import java.util.Arrays;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.ArrayIOUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodecExt;
import org.jitsi.impl.neomedia.codec.audio.g729.Coder;

public class JavaEncoder
extends AbstractCodecExt {
    private static final short BIT_1 = 129;
    private static final int L_FRAME = 80;
    private static final int SERIAL_SIZE = 82;
    private static final int INPUT_FRAME_SIZE_IN_BYTES = 160;
    private static final int OUTPUT_FRAME_SIZE_IN_BYTES = 10;
    private Coder coder;
    private int outputFrameCount;
    private byte[] prevInput;
    private int prevInputLength;
    private short[] serial;
    private short[] sp16;
    private int duration = 20000000;

    public JavaEncoder() {
        super("G.729 Encoder", AudioFormat.class, (Format[])new AudioFormat[]{new AudioFormat("g729/rtp", 8000.0, -1, 1)});
        this.inputFormats = new AudioFormat[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1)};
    }

    public Format getOutputFormat() {
        Format outputFormat = super.getOutputFormat();
        if (outputFormat != null && outputFormat.getClass() == AudioFormat.class) {
            AudioFormat outputAudioFormat = (AudioFormat)outputFormat;
            outputFormat = this.setOutputFormat((Format)new AudioFormat(outputAudioFormat.getEncoding(), outputAudioFormat.getSampleRate(), outputAudioFormat.getSampleSizeInBits(), outputAudioFormat.getChannels(), outputAudioFormat.getEndian(), outputAudioFormat.getSigned(), outputAudioFormat.getFrameSizeInBits(), outputAudioFormat.getFrameRate(), outputAudioFormat.getDataType()){
                private static final long serialVersionUID = 0L;

                public long computeDuration(long length) {
                    return JavaEncoder.this.duration;
                }
            });
        }
        return outputFormat;
    }

    protected void discardOutputBuffer(Buffer outputBuffer) {
        super.discardOutputBuffer(outputBuffer);
        this.outputFrameCount = 0;
    }

    protected void doClose() {
        this.prevInput = null;
        this.prevInputLength = 0;
        this.sp16 = null;
        this.serial = null;
        this.coder = null;
    }

    protected void doOpen() throws ResourceUnavailableException {
        this.prevInput = new byte[160];
        this.prevInputLength = 0;
        this.sp16 = new short[80];
        this.serial = new short[82];
        this.coder = new Coder();
        this.outputFrameCount = 0;
    }

    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        byte[] input = (byte[])inputBuffer.getData();
        int inputLength = inputBuffer.getLength();
        int inputOffset = inputBuffer.getOffset();
        if (this.prevInputLength + inputLength < 160) {
            System.arraycopy(input, inputOffset, this.prevInput, this.prevInputLength, inputLength);
            this.prevInputLength += inputLength;
            return 4;
        }
        int readShorts = 0;
        if (this.prevInputLength > 0) {
            readShorts += JavaEncoder.readShorts(this.prevInput, 0, this.sp16, 0, this.prevInputLength / 2);
            this.prevInputLength = 0;
        }
        readShorts = JavaEncoder.readShorts(input, inputOffset, this.sp16, readShorts, this.sp16.length - readShorts);
        int readBytes = 2 * readShorts;
        inputBuffer.setLength(inputLength -= readBytes);
        inputBuffer.setOffset(inputOffset += readBytes);
        this.coder.process(this.sp16, this.serial);
        byte[] output = this.validateByteArraySize(outputBuffer, outputBuffer.getOffset() + 20);
        this.packetize(this.serial, output, outputBuffer.getOffset() + 10 * this.outputFrameCount);
        outputBuffer.setLength(outputBuffer.getLength() + 10);
        outputBuffer.setFormat(this.outputFormat);
        int processResult = 0;
        if (this.outputFrameCount == 1) {
            this.outputFrameCount = 0;
        } else {
            this.outputFrameCount = 1;
            processResult |= 4;
        }
        if (inputLength > 0) {
            processResult |= 2;
        }
        if (processResult == 0) {
            this.updateOutput(outputBuffer, this.getOutputFormat(), outputBuffer.getLength(), outputBuffer.getOffset());
            outputBuffer.setDuration((long)this.duration);
        }
        return processResult;
    }

    private void packetize(short[] serial, byte[] outputFrame, int outputFrameOffset) {
        Arrays.fill(outputFrame, outputFrameOffset, outputFrameOffset + 10, (byte)0);
        for (int s = 0; s < 80; ++s) {
            if (129 != serial[2 + s]) continue;
            int o = outputFrameOffset + s / 8;
            int output = outputFrame[o];
            outputFrame[o] = (byte)((output |= 1 << 7 - s % 8) & 0xFF);
        }
    }

    private static int readShorts(byte[] input, int inputOffset, short[] output, int outputOffset, int outputLength) {
        int o = outputOffset;
        int i = inputOffset;
        while (o < outputLength) {
            output[o] = ArrayIOUtils.readShort(input, i);
            ++o;
            i += 2;
        }
        return outputLength;
    }
}

