/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import gnu.java.zrtp.utils.ZrtpFortuna;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSourceException;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.SourceStream;
import org.jitsi.impl.neomedia.device.DeviceConfiguration;
import org.jitsi.impl.neomedia.device.ExtendedCaptureDeviceInfo;
import org.jitsi.util.Logger;

public class ZrtpFortunaEntropyGatherer {
    private static final Logger logger = Logger.getLogger(ZrtpFortunaEntropyGatherer.class);
    private final DeviceConfiguration deviceConfiguration;
    private static boolean entropyOk = false;
    private int gatheredEntropy = 0;
    private int bytesToGather = 0;
    private int bytes20ms = 0;
    private static final int NUM_OF_SECONDS = 2;

    public ZrtpFortunaEntropyGatherer(DeviceConfiguration deviceConfiguration) {
        this.deviceConfiguration = deviceConfiguration;
    }

    public static boolean isEntropyOk() {
        return entropyOk;
    }

    protected int getGatheredEntropy() {
        return this.gatheredEntropy;
    }

    public boolean setEntropy() {
        boolean retValue = false;
        GatherAudio gatherer = new GatherAudio();
        retValue = gatherer.prepareAudioEntropy();
        if (retValue) {
            gatherer.start();
        }
        return retValue;
    }

    private class GatherAudio
    extends Thread
    implements BufferTransferHandler {
        private DataSource dataSource = null;
        private SourceStream audioStream = null;
        private final Buffer firstBuf = new Buffer();
        private boolean bufferAvailable = false;
        private final Object bufferSync = new Object();

        private GatherAudio() {
        }

        private boolean prepareAudioEntropy() {
            ExtendedCaptureDeviceInfo audioCaptureDevice = ZrtpFortunaEntropyGatherer.this.deviceConfiguration.getAudioCaptureDevice();
            if (audioCaptureDevice == null) {
                return false;
            }
            MediaLocator audioCaptureDeviceLocator = audioCaptureDevice.getLocator();
            if (audioCaptureDeviceLocator == null) {
                return false;
            }
            try {
                this.dataSource = Manager.createDataSource((MediaLocator)audioCaptureDeviceLocator);
            }
            catch (NoDataSourceException e) {
                logger.warn("No data source during entropy preparation", e);
                return false;
            }
            catch (IOException e) {
                logger.warn("Got an IO Exception during entropy preparation", e);
                return false;
            }
            FormatControl fc = ((CaptureDevice)this.dataSource).getFormatControls()[0];
            AudioFormat af = (AudioFormat)fc.getFormat();
            int framesToRead = (int)(af.getSampleRate() * 2.0);
            int frameSize = af.getSampleSizeInBits() / 8 * af.getChannels();
            ZrtpFortunaEntropyGatherer.this.bytesToGather = framesToRead * frameSize;
            ZrtpFortunaEntropyGatherer.this.bytes20ms = frameSize * (int)(af.getSampleRate() / 50.0);
            if (this.dataSource instanceof PullBufferDataSource) {
                this.audioStream = ((PullBufferDataSource)this.dataSource).getStreams()[0];
            } else {
                this.audioStream = ((PushBufferDataSource)this.dataSource).getStreams()[0];
                ((PushBufferStream)this.audioStream).setTransferHandler((BufferTransferHandler)this);
            }
            return this.audioStream != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferData(PushBufferStream stream) {
            try {
                stream.read(this.firstBuf);
            }
            catch (IOException e) {
                logger.warn("Got IOException during transfer data", e);
            }
            Object object = this.bufferSync;
            synchronized (object) {
                this.bufferAvailable = true;
                this.bufferSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ZrtpFortuna fortuna;
            block16: {
                fortuna = ZrtpFortuna.getInstance();
                if (this.dataSource == null || this.audioStream == null) {
                    return;
                }
                try {
                    block15: {
                        try {
                            this.dataSource.start();
                            int i = 0;
                            while (ZrtpFortunaEntropyGatherer.this.gatheredEntropy < ZrtpFortunaEntropyGatherer.this.bytesToGather) {
                                if (this.audioStream instanceof PushBufferStream) {
                                    Object object = this.bufferSync;
                                    synchronized (object) {
                                        while (!this.bufferAvailable) {
                                            try {
                                                this.bufferSync.wait();
                                            }
                                            catch (InterruptedException e) {}
                                        }
                                        this.bufferAvailable = false;
                                    }
                                } else {
                                    ((PullBufferStream)this.audioStream).read(this.firstBuf);
                                }
                                byte[] entropy = (byte[])this.firstBuf.getData();
                                ZrtpFortunaEntropyGatherer.this.gatheredEntropy += entropy.length;
                                if (i < 32) {
                                    fortuna.addSeedMaterial(entropy);
                                } else {
                                    fortuna.addSeedMaterial(i % 3, entropy, 0, entropy.length);
                                }
                                i = ZrtpFortunaEntropyGatherer.this.gatheredEntropy / ZrtpFortunaEntropyGatherer.this.bytes20ms;
                            }
                            entropyOk = true;
                            if (!logger.isInfoEnabled()) break block15;
                            logger.info("GatherEntropy got: " + ZrtpFortunaEntropyGatherer.this.gatheredEntropy + " bytes");
                        }
                        catch (IOException ioex) {
                            Object var7_8 = null;
                            this.audioStream = null;
                            this.dataSource.disconnect();
                            break block16;
                        }
                    }
                    Object var7_7 = null;
                    this.audioStream = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    this.audioStream = null;
                    this.dataSource.disconnect();
                    throw throwable;
                }
                this.dataSource.disconnect();
            }
            byte[] random = new byte[300];
            fortuna.nextBytes(random);
        }
    }
}

