/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import org.jitsi.util.OSUtils;
import org.jitsi.util.StringUtils;

public class CoreAudioDevice {
    public static boolean isLoaded = false;

    public static native int initDevices();

    public static native void freeDevices();

    public static String getDeviceName(String deviceUID) {
        byte[] deviceNameBytes = CoreAudioDevice.getDeviceNameBytes(deviceUID);
        String deviceName = StringUtils.newString(deviceNameBytes);
        return deviceName;
    }

    public static native byte[] getDeviceNameBytes(String var0);

    public static String getDeviceModelIdentifier(String deviceUID) {
        byte[] deviceModelIdentifierBytes = CoreAudioDevice.getDeviceModelIdentifierBytes(deviceUID);
        String deviceModelIdentifier = StringUtils.newString(deviceModelIdentifierBytes);
        return deviceModelIdentifier;
    }

    public static native byte[] getDeviceModelIdentifierBytes(String var0);

    public static native int setInputDeviceVolume(String var0, float var1);

    public static native int setOutputDeviceVolume(String var0, float var1);

    public static native float getInputDeviceVolume(String var0);

    public static native float getOutputDeviceVolume(String var0);

    static {
        if (OSUtils.IS_MAC) {
            System.loadLibrary("jnmaccoreaudio");
            isLoaded = true;
        } else if (OSUtils.IS_WINDOWS_VISTA || OSUtils.IS_WINDOWS_7 || OSUtils.IS_WINDOWS_8) {
            System.loadLibrary("jnwincoreaudio");
            isLoaded = true;
        }
    }
}

