/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.InetAddress;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.SessionAddress;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.service.neomedia.StreamConnector;

public abstract class AbstractRTPConnector
implements RTPConnector {
    protected final StreamConnector connector;
    private RTPConnectorInputStream controlInputStream;
    private RTPConnectorOutputStream controlOutputStream;
    private RTPConnectorInputStream dataInputStream;
    private RTPConnectorOutputStream dataOutputStream;

    public AbstractRTPConnector(StreamConnector connector) {
        if (connector == null) {
            throw new NullPointerException("connector");
        }
        this.connector = connector;
    }

    public void addTarget(SessionAddress target) throws IOException {
        InetAddress controlAddress = target.getControlAddress();
        if (controlAddress != null) {
            this.getControlOutputStream().addTarget(controlAddress, target.getControlPort());
        }
        this.getDataOutputStream().addTarget(target.getDataAddress(), target.getDataPort());
    }

    public void close() {
        if (this.dataOutputStream != null) {
            this.dataOutputStream.close();
            this.dataOutputStream = null;
        }
        if (this.controlOutputStream != null) {
            this.controlOutputStream.close();
            this.controlOutputStream = null;
        }
        if (this.dataInputStream != null) {
            this.dataInputStream.close();
            this.dataInputStream = null;
        }
        if (this.controlInputStream != null) {
            this.controlInputStream.close();
            this.controlInputStream = null;
        }
        this.connector.close();
    }

    protected abstract RTPConnectorInputStream createControlInputStream() throws IOException;

    protected abstract RTPConnectorOutputStream createControlOutputStream() throws IOException;

    protected abstract RTPConnectorInputStream createDataInputStream() throws IOException;

    protected abstract RTPConnectorOutputStream createDataOutputStream() throws IOException;

    public final StreamConnector getConnector() {
        return this.connector;
    }

    public RTPConnectorInputStream getControlInputStream() throws IOException {
        return this.getControlInputStream(true);
    }

    protected RTPConnectorInputStream getControlInputStream(boolean create) throws IOException {
        if (this.controlInputStream == null && create) {
            this.controlInputStream = this.createControlInputStream();
        }
        return this.controlInputStream;
    }

    public RTPConnectorOutputStream getControlOutputStream() throws IOException {
        return this.getControlOutputStream(true);
    }

    protected RTPConnectorOutputStream getControlOutputStream(boolean create) throws IOException {
        if (this.controlOutputStream == null && create) {
            this.controlOutputStream = this.createControlOutputStream();
        }
        return this.controlOutputStream;
    }

    public RTPConnectorInputStream getDataInputStream() throws IOException {
        return this.getDataInputStream(true);
    }

    protected RTPConnectorInputStream getDataInputStream(boolean create) throws IOException {
        if (this.dataInputStream == null && create) {
            this.dataInputStream = this.createDataInputStream();
        }
        return this.dataInputStream;
    }

    public RTPConnectorOutputStream getDataOutputStream() throws IOException {
        return this.getDataOutputStream(true);
    }

    public RTPConnectorOutputStream getDataOutputStream(boolean create) throws IOException {
        if (this.dataOutputStream == null && create) {
            this.dataOutputStream = this.createDataOutputStream();
        }
        return this.dataOutputStream;
    }

    public int getReceiveBufferSize() {
        return -1;
    }

    public double getRTCPBandwidthFraction() {
        return -1.0;
    }

    public double getRTCPSenderBandwidthFraction() {
        return -1.0;
    }

    public int getSendBufferSize() {
        return -1;
    }

    public void removeTarget(SessionAddress target) {
        if (this.controlOutputStream != null) {
            this.controlOutputStream.removeTarget(target.getControlAddress(), target.getControlPort());
        }
        if (this.dataOutputStream != null) {
            this.dataOutputStream.removeTarget(target.getDataAddress(), target.getDataPort());
        }
    }

    public void removeTargets() {
        if (this.controlOutputStream != null) {
            this.controlOutputStream.removeTargets();
        }
        if (this.dataOutputStream != null) {
            this.dataOutputStream.removeTargets();
        }
    }

    public void setReceiveBufferSize(int size) throws IOException {
    }

    public void setSendBufferSize(int size) throws IOException {
    }
}

