/*
 * Decompiled with CFR 0.152.
 */
package test;

import gov.nist.javax.sdp.fields.AttributeField;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sdp.Attribute;
import javax.sdp.Connection;
import javax.sdp.MediaDescription;
import javax.sdp.Origin;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;

public class SdpUtils {
    public static String createSDPDescription(Agent agent) throws Throwable {
        SdpFactory factory = SdpFactory.getInstance();
        SessionDescription sdess = factory.createSessionDescription();
        Vector<Attribute> sessionAttributes = new Vector<Attribute>();
        TransportAddress defaultAddress = agent.getStreams().get(0).getComponent(1).getDefaultCandidate().getTransportAddress();
        String addrType = defaultAddress.isIPv6() ? "IP6" : "IP4";
        Origin o = factory.createOrigin("ice4j.org", 0L, 0L, "IN", addrType, defaultAddress.getHostAddress());
        sdess.setOrigin(o);
        Connection c = factory.createConnection("IN", addrType, defaultAddress.getHostAddress());
        sdess.setConnection(c);
        sessionAttributes.add(factory.createAttribute("ice-pwd", agent.getLocalPassword()));
        sessionAttributes.add(factory.createAttribute("ice-ufrag", agent.getLocalUfrag()));
        List<IceMediaStream> streams = agent.getStreams();
        Vector<MediaDescription> mDescs = new Vector<MediaDescription>(agent.getStreamCount());
        for (IceMediaStream stream : streams) {
            TransportAddress streamDefaultAddr = stream.getComponent(1).getDefaultCandidate().getTransportAddress();
            MediaDescription mdesc = factory.createMediaDescription(stream.getName(), streamDefaultAddr.getPort(), 1, "RTP/AVP", new int[]{0});
            Vector<CandidateAttribute> candidates = new Vector<CandidateAttribute>();
            for (Component component : stream.getComponents()) {
                for (LocalCandidate cand : component.getLocalCandidates()) {
                    candidates.add(new CandidateAttribute(cand));
                }
            }
            mdesc.setAttributes(candidates);
            mDescs.add(mdesc);
        }
        sdess.setAttributes(sessionAttributes);
        sdess.setMediaDescriptions(mDescs);
        return sdess.toString();
    }

    public static void parseSDP(Agent localAgent, String sdp) throws Exception {
        SdpFactory factory = SdpFactory.getInstance();
        SessionDescription sdess = factory.createSessionDescription(sdp);
        for (IceMediaStream stream : localAgent.getStreams()) {
            stream.setRemotePassword(sdess.getAttribute("ice-pwd"));
            stream.setRemoteUfrag(sdess.getAttribute("ice-ufrag"));
        }
        Connection globalConn = sdess.getConnection();
        String globalConnAddr = null;
        if (globalConn != null) {
            globalConnAddr = globalConn.getAddress();
        }
        Vector mdescs = sdess.getMediaDescriptions(true);
        for (MediaDescription desc : mdescs) {
            String streamName = desc.getMedia().getMediaType();
            IceMediaStream stream = localAgent.getStream(streamName);
            if (stream == null) continue;
            Vector attributes = desc.getAttributes(true);
            for (Attribute attribute : attributes) {
                if (!attribute.getName().equals("candidate")) continue;
                SdpUtils.parseCandidate(attribute, stream);
            }
            Connection streamConn = desc.getConnection();
            String streamConnAddr = null;
            streamConnAddr = streamConn != null ? streamConn.getAddress() : globalConnAddr;
            int port = desc.getMedia().getMediaPort();
            TransportAddress defaultRtpAddress = new TransportAddress(streamConnAddr, port, Transport.UDP);
            int rtcpPort = port + 1;
            String rtcpAttributeValue = desc.getAttribute("rtcp");
            if (rtcpAttributeValue != null) {
                rtcpPort = Integer.parseInt(rtcpAttributeValue);
            }
            TransportAddress defaultRtcpAddress = new TransportAddress(streamConnAddr, rtcpPort, Transport.UDP);
            Component rtpComponent = stream.getComponent(1);
            Component rtcpComponent = stream.getComponent(2);
            RemoteCandidate defaultRtpCandidate = rtpComponent.findRemoteCandidate(defaultRtpAddress);
            rtpComponent.setDefaultRemoteCandidate(defaultRtpCandidate);
            if (rtcpComponent == null) continue;
            RemoteCandidate defaultRtcpCandidate = rtcpComponent.findRemoteCandidate(defaultRtcpAddress);
            rtcpComponent.setDefaultRemoteCandidate(defaultRtcpCandidate);
        }
    }

    private static RemoteCandidate parseCandidate(Attribute attribute, IceMediaStream stream) {
        String value = null;
        try {
            value = attribute.getValue();
        }
        catch (Throwable t) {
            // empty catch block
        }
        StringTokenizer tokenizer = new StringTokenizer(value);
        String foundation = tokenizer.nextToken();
        int componentID = Integer.parseInt(tokenizer.nextToken());
        Transport transport = Transport.parse(tokenizer.nextToken());
        long priority = Long.parseLong(tokenizer.nextToken());
        String address = tokenizer.nextToken();
        int port = Integer.parseInt(tokenizer.nextToken());
        TransportAddress transAddr = new TransportAddress(address, port, transport);
        tokenizer.nextToken();
        CandidateType type = CandidateType.parse(tokenizer.nextToken());
        Component component = stream.getComponent(componentID);
        if (component == null) {
            return null;
        }
        RemoteCandidate relatedCandidate = null;
        if (tokenizer.countTokens() >= 4) {
            tokenizer.nextToken();
            String relatedAddr = tokenizer.nextToken();
            tokenizer.nextToken();
            int relatedPort = Integer.parseInt(tokenizer.nextToken());
            TransportAddress raddr = new TransportAddress(relatedAddr, relatedPort, Transport.UDP);
            relatedCandidate = component.findRemoteCandidate(raddr);
        }
        RemoteCandidate cand = new RemoteCandidate(transAddr, component, type, foundation, priority, relatedCandidate);
        component.addRemoteCandidate(cand);
        return cand;
    }

    private static class CandidateAttribute
    extends AttributeField {
        public static final String NAME = "candidate";
        private static final long serialVersionUID = 1L;
        private final Candidate candidate;

        public CandidateAttribute(Candidate candidate) {
            this.candidate = candidate;
        }

        public String getName() {
            return NAME;
        }

        public void setName(String name) {
        }

        public boolean hasValue() {
            return true;
        }

        public String getValue() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.candidate.getFoundation());
            buff.append(" ").append(this.candidate.getParentComponent().getComponentID());
            buff.append(" ").append((Object)this.candidate.getTransport());
            buff.append(" ").append(this.candidate.getPriority());
            buff.append(" ").append(this.candidate.getTransportAddress().getHostAddress());
            buff.append(" ").append(this.candidate.getTransportAddress().getPort());
            buff.append(" typ ").append((Object)this.candidate.getType());
            TransportAddress relAddr = this.candidate.getRelatedAddress();
            if (relAddr != null) {
                buff.append(" raddr ").append(relAddr.getHostAddress());
                buff.append(" rport ").append(relAddr.getPort());
            }
            return buff.toString();
        }

        public void setValue(String value) throws SdpException {
        }

        public char getTypeChar() {
            return 'a';
        }

        public CandidateAttribute clone() {
            return this;
        }

        public String encode() {
            StringBuffer sbuff = new StringBuffer("a=");
            sbuff.append(this.getName()).append(":");
            sbuff.append(this.getValue());
            return sbuff.append("\r\n").toString();
        }
    }
}

