/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.math.BigInteger;
import java.net.BindException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StackProperties;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidatePairState;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.CheckList;
import org.ice4j.ice.CheckListState;
import org.ice4j.ice.CompatibilityMode;
import org.ice4j.ice.Component;
import org.ice4j.ice.ConnectivityCheckClient;
import org.ice4j.ice.ConnectivityCheckServer;
import org.ice4j.ice.DefaultNominator;
import org.ice4j.ice.FoundationsRegistry;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.NominationStrategy;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.CandidateHarvesterSet;
import org.ice4j.ice.harvest.HarvestingTimeStat;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.stack.StunStack;
import org.ice4j.stack.TransactionID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent {
    public static final int DEFAULT_MAX_CHECK_LIST_SIZE = 100;
    public static final int DEFAULT_TERMINATION_DELAY = 3000;
    private static final PropertyChangeListener[] NO_STATE_CHANGE_LISTENERS = new PropertyChangeListener[0];
    private static final Logger logger = Logger.getLogger(Agent.class.getName());
    private final Map<String, IceMediaStream> mediaStreams = new LinkedHashMap<String, IceMediaStream>();
    private final HostCandidateHarvester hostCandidateHarvester = new HostCandidateHarvester();
    private final CandidateHarvesterSet harvesters = new CandidateHarvesterSet();
    private HarvestingTimeStat harvestingTimeStat = new HarvestingTimeStat();
    private final FoundationsRegistry foundationsRegistry = new FoundationsRegistry();
    private final DefaultNominator nominator;
    private CompatibilityMode compatibilityMode = CompatibilityMode.RFC5245;
    public static final String PROPERTY_ICE_PROCESSING_STATE = "IceProcessingState";
    private long taValue = -1L;
    private final List<CandidatePair> preDiscoveredPairsQueue = new LinkedList<CandidatePair>();
    private final Object startLock = new Object();
    private final String ufrag;
    private final String password;
    private final long tieBreaker;
    private boolean isControlling = true;
    private final ConnectivityCheckClient connCheckClient;
    private final ConnectivityCheckServer connCheckServer;
    private IceProcessingState state = IceProcessingState.WAITING;
    private final List<PropertyChangeListener> stateListeners = new LinkedList<PropertyChangeListener>();
    private StunStack stunStack;
    private TerminationThread terminationThread;
    private StunKeepAliveThread stunKeepAliveThread;
    private int generation = 0;
    private boolean shutdown = false;

    public Agent() {
        this(CompatibilityMode.RFC5245);
    }

    public Agent(CompatibilityMode compatibilityMode) {
        SecureRandom random = new SecureRandom();
        this.compatibilityMode = compatibilityMode;
        this.connCheckServer = new ConnectivityCheckServer(this);
        this.connCheckClient = new ConnectivityCheckClient(this);
        System.setProperty("org.ice4j.ALWAYS_SIGN", "true");
        if (StackProperties.getString("org.ice4j.SOFTWARE") == null) {
            System.setProperty("org.ice4j.SOFTWARE", "ice4j.org");
        }
        if (compatibilityMode == CompatibilityMode.GTALK) {
            this.ufrag = null;
            this.password = "";
        } else {
            this.ufrag = new BigInteger(24, random).toString(32);
            this.password = new BigInteger(128, random).toString(32);
        }
        this.tieBreaker = Math.abs(random.nextLong());
        this.nominator = new DefaultNominator(this);
    }

    public IceMediaStream createMediaStream(String mediaStreamName) {
        logger.info("Create media stream for " + mediaStreamName);
        IceMediaStream mediaStream = new IceMediaStream(this, mediaStreamName);
        this.mediaStreams.put(mediaStreamName, mediaStream);
        this.setState(IceProcessingState.WAITING);
        return mediaStream;
    }

    public Component createComponent(IceMediaStream stream, Transport transport, int preferredPort, int minPort, int maxPort) throws IllegalArgumentException, IOException, BindException {
        if (transport != Transport.UDP) {
            throw new IllegalArgumentException("This implementation does not currently support transport: " + (Object)((Object)transport));
        }
        Component component = stream.createComponent(transport);
        logger.info("Create component " + component.toShortString());
        this.gatherCandidates(component, preferredPort, minPort, maxPort);
        for (LocalCandidate candidate : component.getLocalCandidates()) {
            LocalCandidate localCand;
            logger.info("\t" + candidate.getTransportAddress() + " (" + (Object)((Object)candidate.getType()) + ")");
            if (this.compatibilityMode != CompatibilityMode.GTALK || (localCand = candidate).getUfrag() != null) continue;
            localCand.setUfrag(this.generateGTalkUfrag());
        }
        this.connCheckServer.start();
        return component;
    }

    public String generateGTalkUfrag() {
        SecureRandom random = new SecureRandom();
        String s = null;
        while (s == null || s.length() != 16) {
            s = new BigInteger(80, random).toString(32);
        }
        return s;
    }

    private void gatherCandidates(Component component, int preferredPort, int minPort, int maxPort) throws IllegalArgumentException, IOException {
        logger.info("Gather candidates for component " + component.toShortString());
        this.startHarvesting();
        this.hostCandidateHarvester.harvest(component, preferredPort, minPort, maxPort, Transport.UDP);
        if (this.compatibilityMode == CompatibilityMode.GTALK) {
            this.hostCandidateHarvester.harvest(component, preferredPort, minPort, maxPort, Transport.TCP);
        }
        logger.fine("host candidate count: " + component.getLocalCandidateCount());
        this.harvesters.harvest(component);
        this.stopHarvesting();
        logger.info("End candidate harvest for all harvesters within " + this.getTotalHarvestingTime() + " ms" + ", component: " + component.getComponentID());
        logger.fine("host+harvested candidate count: " + component.getLocalCandidateCount());
        this.computeFoundations(component);
        component.prioritizeCandidates();
        component.eliminateRedundantCandidates();
        logger.fine("host+harvested candidate count (after elimination): " + component.getLocalCandidateCount());
        component.selectDefaultCandidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConnectivityEstablishment() {
        Object object = this.startLock;
        synchronized (object) {
            logger.info("Start ICE connectivity establishment");
            this.shutdown = false;
            this.pruneNonMatchedStreams();
            try {
                this.initCheckLists();
            }
            catch (ArithmeticException e) {
                this.setState(IceProcessingState.FAILED);
                return;
            }
            this.setState(IceProcessingState.RUNNING);
            if (this.preDiscoveredPairsQueue.size() > 0) {
                logger.info("Trigger checks for pairs that were received before running state");
                Iterator<CandidatePair> it = this.preDiscoveredPairsQueue.iterator();
                while (it.hasNext()) {
                    this.triggerCheck(it.next());
                }
                this.preDiscoveredPairsQueue.clear();
            }
            this.connCheckClient.startChecks();
        }
    }

    private void pruneNonMatchedStreams() {
        for (IceMediaStream stream : this.getStreams()) {
            for (Component cmp : stream.getComponents()) {
                if (cmp.getRemoteCandidateCount() != 0) continue;
                stream.removeComponent(cmp);
            }
            if (stream.getComponentCount() != 0) continue;
            this.removeStream(stream);
        }
    }

    public boolean isStarted() {
        return this.state != IceProcessingState.WAITING && this.state != IceProcessingState.TERMINATED;
    }

    public IceProcessingState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateChangeListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.stateListeners;
        synchronized (list) {
            if (!this.stateListeners.contains(l)) {
                this.stateListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateChangeListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChange(IceProcessingState oldState, IceProcessingState newState) {
        PropertyChangeListener[] stateListenersCopy;
        List<PropertyChangeListener> list = this.stateListeners;
        synchronized (list) {
            stateListenersCopy = this.stateListeners.toArray(NO_STATE_CHANGE_LISTENERS);
        }
        if (stateListenersCopy.length != 0) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, PROPERTY_ICE_PROCESSING_STATE, (Object)oldState, (Object)newState);
            for (PropertyChangeListener l : stateListenersCopy) {
                l.propertyChange(evt);
            }
        }
    }

    private void setState(IceProcessingState newState) {
        IceProcessingState oldState = this.state;
        this.state = newState;
        this.fireStateChange(oldState, newState);
    }

    protected void initCheckLists() {
        List<IceMediaStream> streams = this.getStreamsWithPendingConnectivityEstablishment();
        int maxCheckListSize = Integer.getInteger("org.ice4j.MAX_CHECK_LIST_SIZE", 100);
        int maxPerStreamSize = maxCheckListSize / streams.size();
        for (IceMediaStream stream : streams) {
            logger.info("Init checklist for stream " + stream.getName());
            stream.setMaxCheckListSize(maxPerStreamSize);
            stream.initCheckList();
        }
        streams.get(0).getCheckList().computeInitialCheckListPairStates();
    }

    private void computeFoundations(Component component) {
        List<LocalCandidate> candidates = component.getLocalCandidates();
        for (LocalCandidate cand : candidates) {
            this.foundationsRegistry.assignFoundation(cand);
        }
    }

    public void addCandidateHarvester(CandidateHarvester harvester) {
        this.harvesters.add(harvester);
    }

    public String getLocalUfrag() {
        return this.ufrag;
    }

    public String getLocalPassword() {
        return this.password;
    }

    public String generateLocalUserName(String media) {
        IceMediaStream stream = this.getStream(media);
        String ret = null;
        if (stream == null || stream.getRemoteUfrag() == null) {
            return null;
        }
        ret = stream.getRemoteUfrag() + ":" + this.getLocalUfrag();
        return ret;
    }

    public String generateRemoteUserName(String media) {
        IceMediaStream stream = this.getStream(media);
        String ret = null;
        if (stream == null) {
            return null;
        }
        if (this.compatibilityMode == CompatibilityMode.RFC5245) {
            ret = this.getLocalUfrag() + ":" + stream.getRemoteUfrag();
        } else if (this.compatibilityMode == CompatibilityMode.GTALK) {
            ret = this.getLocalUfrag() + stream.getRemoteUfrag();
        }
        return ret;
    }

    public String generateLocalUserName(RemoteCandidate remoteCandidate, LocalCandidate localCandidate) {
        return this.generateUserName(remoteCandidate, localCandidate);
    }

    public String generateRemoteUserName(RemoteCandidate remoteCandidate, LocalCandidate localCandidate) {
        return this.generateUserName(localCandidate, remoteCandidate);
    }

    private String generateUserName(Candidate candidate1, Candidate candidate2) {
        String ret = null;
        String ufrag1 = candidate1.getUfrag();
        String ufrag2 = candidate2.getUfrag();
        if (ufrag1 != null && ufrag2 != null && this.compatibilityMode == CompatibilityMode.GTALK) {
            ret = ufrag1 + ufrag2;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceMediaStream getStream(String name) {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            return this.mediaStreams.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStreamNames() {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            return new LinkedList<String>(this.mediaStreams.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IceMediaStream> getStreams() {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            return new LinkedList<IceMediaStream>(this.mediaStreams.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamCount() {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            return this.mediaStreams.size();
        }
    }

    List<IceMediaStream> getStreamsWithPendingConnectivityEstablishment() {
        List<IceMediaStream> streams = this.getStreams();
        Iterator<IceMediaStream> streamIter = streams.iterator();
        while (streamIter.hasNext()) {
            IceMediaStream stream = streamIter.next();
            CheckList checkList = stream.getCheckList();
            CheckListState checkListState = checkList.getState();
            if (!CheckListState.COMPLETED.equals((Object)checkListState) && !CheckListState.FAILED.equals((Object)checkListState)) continue;
            streamIter.remove();
        }
        return streams;
    }

    public synchronized StunStack getStunStack() {
        if (this.stunStack == null) {
            this.stunStack = new StunStack(this.compatibilityMode);
        }
        return this.stunStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getActiveCheckListCount() {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            int i = 0;
            Collection<IceMediaStream> streams = this.mediaStreams.values();
            for (IceMediaStream stream : streams) {
                if (!stream.getCheckList().isActive()) continue;
                ++i;
            }
            return i;
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("ICE Agent (stream-count=");
        buff.append(this.getStreamCount()).append(" ice-pwd:").append(this.getLocalPassword());
        buff.append(this.getStreamCount()).append(" ice-ufrag:").append(this.getLocalUfrag());
        buff.append(this.getStreamCount()).append(" tie-breaker:").append(this.getTieBreaker());
        buff.append("):\n");
        for (IceMediaStream stream : this.getStreams()) {
            buff.append(stream.toString()).append("\n");
        }
        return buff.toString();
    }

    public long getTieBreaker() {
        return this.tieBreaker;
    }

    public void setControlling(boolean isControlling) {
        this.isControlling = isControlling;
        List<IceMediaStream> streams = this.getStreams();
        for (IceMediaStream stream : streams) {
            CheckList list = stream.getCheckList();
            if (list == null) continue;
            list.recomputePairPriorities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStream(IceMediaStream stream) {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            this.mediaStreams.remove(stream.getName());
            stream.free();
        }
    }

    public boolean isControlling() {
        return this.isControlling;
    }

    public LocalCandidate findLocalCandidate(TransportAddress localAddress) {
        Collection<IceMediaStream> streamsCollection = this.mediaStreams.values();
        for (IceMediaStream stream : streamsCollection) {
            LocalCandidate cnd = stream.findLocalCandidate(localAddress);
            if (cnd == null) continue;
            return cnd;
        }
        return null;
    }

    public LocalCandidate findLocalCandidate(TransportAddress localAddress, String ufrag) {
        Collection<IceMediaStream> streamsCollection = this.mediaStreams.values();
        for (IceMediaStream stream : streamsCollection) {
            for (Component c : stream.getComponents()) {
                for (LocalCandidate cnd : c.getLocalCandidates()) {
                    if (cnd == null || cnd.getUfrag() == null || !cnd.getUfrag().equals(ufrag)) continue;
                    return cnd;
                }
            }
        }
        return null;
    }

    public RemoteCandidate findRemoteCandidate(TransportAddress remoteAddress) {
        Collection<IceMediaStream> streamsCollection = this.mediaStreams.values();
        for (IceMediaStream stream : streamsCollection) {
            RemoteCandidate cnd = stream.findRemoteCandidate(remoteAddress);
            if (cnd == null) continue;
            return cnd;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CandidatePair findCandidatePair(TransportAddress localAddress, TransportAddress remoteAddress) {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            Collection<IceMediaStream> streamsCollection = this.mediaStreams.values();
            for (IceMediaStream stream : streamsCollection) {
                CandidatePair pair = stream.findCandidatePair(localAddress, remoteAddress);
                if (pair == null) continue;
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CandidatePair findCandidatePair(String localUFrag, String remoteUFrag) {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            Collection<IceMediaStream> streamsCollection = this.mediaStreams.values();
            for (IceMediaStream stream : streamsCollection) {
                CandidatePair pair = stream.findCandidatePair(localUFrag, remoteUFrag);
                if (pair == null) continue;
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incomingCheckReceived(TransportAddress remoteAddress, TransportAddress localAddress, long priority, String remoteUFrag, String localUFrag, boolean useCandidate) {
        String ufrag = null;
        LocalCandidate localCandidate = null;
        localCandidate = this.compatibilityMode == CompatibilityMode.GTALK && localAddress.getTransport() != Transport.TCP ? this.findLocalCandidate(localAddress, remoteUFrag) : this.findLocalCandidate(localAddress);
        if (localCandidate == null) {
            logger.info("No localAddress for this incoming checks: " + localAddress);
            return;
        }
        Component parentComponent = localCandidate.getParentComponent();
        RemoteCandidate remoteCandidate = null;
        if (this.compatibilityMode == CompatibilityMode.GTALK) {
            CandidatePair pair = this.findCandidatePair(localUFrag, remoteUFrag);
            if (pair == null) {
                logger.info("No GTalk CandidatePair that match Lufrag/Rufrag " + localUFrag + " " + remoteUFrag);
                return;
            }
            CandidatePair pair2 = this.findCandidatePair(localCandidate.getTransportAddress(), remoteAddress);
            useCandidate = pair2 == null ? false : pair2.useCandidateReceived();
            ufrag = pair.getRemoteCandidate().getUfrag();
        }
        remoteCandidate = new RemoteCandidate(remoteAddress, parentComponent, CandidateType.PEER_REFLEXIVE_CANDIDATE, this.foundationsRegistry.obtainFoundationForPeerReflexiveCandidate(), priority, null, ufrag);
        CandidatePair triggeredPair = new CandidatePair(localCandidate, remoteCandidate);
        logger.fine("set use-candidate " + useCandidate + " for pair " + triggeredPair.toShortString());
        if (useCandidate) {
            triggeredPair.setUseCandidateReceived();
        }
        Object object = this.startLock;
        synchronized (object) {
            if (this.isStarted()) {
                if (triggeredPair.getParentComponent().getSelectedPair() == null) {
                    logger.info("Receive check from " + triggeredPair.toShortString() + "triggered a check");
                }
                this.triggerCheck(triggeredPair);
            } else {
                logger.fine("Receive STUN checks before our ICE has started");
                this.preDiscoveredPairsQueue.add(triggeredPair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerCheck(CandidatePair triggerPair) {
        CandidatePair knownPair = null;
        knownPair = this.findCandidatePair(triggerPair.getLocalCandidate().getTransportAddress(), triggerPair.getRemoteCandidate().getTransportAddress());
        IceMediaStream parentStream = triggerPair.getLocalCandidate().getParentComponent().getParentStream();
        if (knownPair != null) {
            boolean useCand = false;
            useCand = triggerPair.useCandidateReceived();
            if (triggerPair.useCandidateReceived()) {
                knownPair.setUseCandidateReceived();
            }
            triggerPair = knownPair;
            if (this.compatibilityMode != CompatibilityMode.RFC5245 && !this.isControlling()) {
                logger.fine("set useCandidateReceived for " + triggerPair.toShortString());
                CandidatePair candidatePair = triggerPair;
                synchronized (candidatePair) {
                    triggerPair.setUseCandidateReceived();
                }
            }
            if (knownPair.getState() == CandidatePairState.SUCCEEDED) {
                if (!this.isControlling() && useCand) {
                    logger.fine("update nominated flag");
                    this.nominationConfirmed(triggerPair);
                    this.checkListStatesUpdated();
                }
                return;
            }
            if (knownPair.getState() == CandidatePairState.IN_PROGRESS) {
                TransactionID checkTransaction = knownPair.getConnectivityCheckTransaction();
                this.getStunStack().cancelTransaction(checkTransaction);
            }
        } else {
            if (triggerPair.getParentComponent().getSelectedPair() == null) {
                logger.info("Add peer CandidatePair with new reflexive address to checkList");
            }
            triggerPair.setUseCandidateReceived();
            parentStream.addToCheckList(triggerPair);
        }
        CheckList checkList = parentStream.getCheckList();
        boolean wasFrozen = checkList.isFrozen();
        checkList.scheduleTriggeredCheck(triggerPair);
        if (wasFrozen && !checkList.isFrozen()) {
            this.connCheckClient.startChecks(checkList);
        }
    }

    protected void validatePair(CandidatePair validPair) {
        Component parentComponent = validPair.getParentComponent();
        IceMediaStream parentStream = parentComponent.getParentStream();
        parentStream.addToValidList(validPair);
    }

    public synchronized void nominate(CandidatePair pair) throws IllegalStateException {
        if (!this.isControlling()) {
            throw new IllegalStateException("Only controlling agents can nominate pairs");
        }
        Component parentComponent = pair.getParentComponent();
        IceMediaStream parentStream = parentComponent.getParentStream();
        if (!pair.isNominated() && !parentStream.validListContainsNomineeForComponent(parentComponent)) {
            logger.info("verify if nominated pair answer again");
            pair.nominate();
            pair.getParentComponent().getParentStream().getCheckList().scheduleTriggeredCheck(pair);
        }
    }

    public void setNominationStrategy(NominationStrategy strategy) {
        this.nominator.setStrategy(strategy);
    }

    protected void nominationConfirmed(CandidatePair nominatedPair) {
        nominatedPair.nominate();
        Component parentComponent = nominatedPair.getParentComponent();
        IceMediaStream parentStream = parentComponent.getParentStream();
        CheckList checkList = parentStream.getCheckList();
        if (checkList.getState() == CheckListState.RUNNING) {
            checkList.handleNominationConfirmed(nominatedPair);
        }
        if (parentStream.allComponentsHaveSelected() && checkList.getState() == CheckListState.RUNNING) {
            checkList.setState(CheckListState.COMPLETED);
        }
    }

    protected void checkListStatesUpdated() {
        boolean allListsEnded = true;
        boolean atLeastOneListSucceeded = false;
        if (this.state == IceProcessingState.COMPLETED) {
            return;
        }
        List<IceMediaStream> streams = this.getStreams();
        for (IceMediaStream stream : streams) {
            CheckListState checkListState = stream.getCheckList().getState();
            if (checkListState == CheckListState.RUNNING) {
                allListsEnded = false;
                break;
            }
            if (checkListState != CheckListState.COMPLETED) continue;
            logger.info("CheckList of stream " + stream.getName() + " is COMPLETED");
            atLeastOneListSucceeded = true;
        }
        if (allListsEnded) {
            if (atLeastOneListSucceeded) {
                if (this.getState() == IceProcessingState.RUNNING) {
                    logger.info("ICE state is COMPLETED");
                    this.setState(IceProcessingState.COMPLETED);
                    if (this.stunKeepAliveThread == null) {
                        this.scheduleSTUNKeepAlive();
                    }
                    if (this.compatibilityMode == CompatibilityMode.RFC5245) {
                        this.scheduleTermination();
                    }
                    List<IceMediaStream> strms = this.getStreams();
                    for (IceMediaStream stream : strms) {
                        for (Component c : stream.getComponents()) {
                            StringBuffer buf = new StringBuffer("Harvester selected for ");
                            buf.append(c.toShortString());
                            buf.append(" ");
                            if (c.getSelectedPair() == null) {
                                buf.append("none ");
                                buf.append("(it means that conncheck failed)");
                                logger.info(buf.toString());
                                continue;
                            }
                            TransportAddress serverAddr = c.getSelectedPair().getLocalCandidate().getStunServerAddress();
                            TransportAddress relayAddr = c.getSelectedPair().getLocalCandidate().getRelayServerAddress();
                            buf.append((Object)c.getSelectedPair().getLocalCandidate().getType());
                            if (serverAddr != null) {
                                buf.append(" (server = ");
                                buf.append(c.getSelectedPair().getLocalCandidate().getStunServerAddress());
                                buf.append(")");
                            } else if (relayAddr != null) {
                                buf.append(" (relay = ");
                                buf.append(c.getSelectedPair().getLocalCandidate().getRelayServerAddress());
                                buf.append(")");
                            }
                            logger.info(buf.toString());
                        }
                    }
                }
            } else {
                logger.info("ICE state is FAILED");
                this.terminate(IceProcessingState.FAILED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int countHostCandidates() {
        int num = 0;
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            Collection<IceMediaStream> streamsCol = this.mediaStreams.values();
            for (IceMediaStream stream : streamsCol) {
                num += stream.countHostCandidates();
            }
        }
        return num;
    }

    public void setTa(long taValue) {
        this.taValue = taValue;
    }

    protected long calculateTa() {
        if (this.taValue != -1L) {
            return this.taValue;
        }
        return 20L;
    }

    protected long calculateStunHarvestRTO() {
        return Math.max(100L, this.calculateTa() * 2L * (long)this.countHostCandidates());
    }

    protected long calculateStunConnCheckRTO() {
        return 100L;
    }

    private void scheduleTermination() {
        if (this.terminationThread == null) {
            this.terminationThread = new TerminationThread();
            this.terminationThread.start();
        }
    }

    private void scheduleSTUNKeepAlive() {
        if (this.stunKeepAliveThread == null) {
            this.stunKeepAliveThread = new StunKeepAliveThread();
            this.stunKeepAliveThread.start();
        }
    }

    private void terminate(IceProcessingState terminationState) {
        if (!IceProcessingState.FAILED.equals((Object)terminationState) && !IceProcessingState.TERMINATED.equals((Object)terminationState)) {
            throw new IllegalArgumentException("terminationState");
        }
        this.connCheckClient.stop();
        this.connCheckServer.stop();
        this.setState(terminationState);
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    public void free() {
        IceProcessingState state;
        logger.info("Free ICE agent");
        this.shutdown = true;
        if (this.stunKeepAliveThread != null) {
            this.stunKeepAliveThread.interrupt();
        }
        if (!IceProcessingState.FAILED.equals((Object)(state = this.getState())) && !IceProcessingState.TERMINATED.equals((Object)state)) {
            this.terminate(IceProcessingState.TERMINATED);
        }
        logger.info("remove streams");
        for (IceMediaStream stream : this.getStreams()) {
            try {
                this.removeStream(stream);
            }
            catch (Throwable t) {
                logger.info("remove stream failed: " + t);
            }
            logger.info("remove stream " + stream.getName());
        }
        this.getStunStack().shutDown();
        logger.info("ICE agent freed");
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public CompatibilityMode getCompatibilityMode() {
        return this.compatibilityMode;
    }

    public void runInStunKeepAliveThread() {
        while (!(this.state != IceProcessingState.COMPLETED && this.state != IceProcessingState.TERMINATED || this.shutdown)) {
            List<IceMediaStream> streams = this.getStreams();
            for (IceMediaStream stream : streams) {
                List<Component> cmps = stream.getComponents();
                for (Component cmp : cmps) {
                    CandidatePair pair = cmp.getSelectedPair();
                    if (pair == null) continue;
                    if (this.compatibilityMode == CompatibilityMode.GTALK) {
                        this.connCheckClient.startCheckForPair(pair);
                    } else if (this.compatibilityMode == CompatibilityMode.RFC5245) {
                        this.connCheckClient.sendBindingIndicationForPair(pair);
                    }
                    pair = null;
                }
                Object var3_4 = null;
            }
            streams = null;
            if (this.shutdown) break;
            try {
                Thread.sleep(3000L);
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.info("KeepAliveThread ends");
    }

    private CandidatePair getSelectedPair(String streamName) {
        List<IceMediaStream> iceMediaStreams = this.getStreams();
        for (int i = 0; i < iceMediaStreams.size(); ++i) {
            if (!iceMediaStreams.get(i).getName().equals(streamName)) continue;
            List<Component> components = iceMediaStreams.get(i).getComponents();
            for (int j = 0; j < components.size(); ++j) {
                Component component = components.get(i);
                if (component.getComponentID() != 1) continue;
                return component.getSelectedPair();
            }
        }
        return null;
    }

    public LocalCandidate getSelectedLocalCandidate(String streamName) {
        CandidatePair candidatePair = this.getSelectedPair(streamName);
        if (candidatePair != null) {
            return candidatePair.getLocalCandidate();
        }
        return null;
    }

    public RemoteCandidate getSelectedRemoteCandidate(String streamName) {
        CandidatePair candidatePair = this.getSelectedPair(streamName);
        if (candidatePair != null) {
            return candidatePair.getRemoteCandidate();
        }
        return null;
    }

    public long getHarvestingTime(String harvesterName) {
        if (this.hostCandidateHarvester.getClass().getName().endsWith(harvesterName)) {
            return this.hostCandidateHarvester.getHarvestingTime();
        }
        long harvestingTime = 0L;
        for (CandidateHarvester tmpHarvester : this.harvesters) {
            if (!tmpHarvester.getClass().getName().endsWith(harvesterName) || (harvestingTime = tmpHarvester.getHarvestingTime()) == 0L) continue;
            return harvestingTime;
        }
        return 0L;
    }

    public int getNbHarvesting(String harvesterName) {
        if (this.hostCandidateHarvester.getClass().getName().endsWith(harvesterName)) {
            return this.hostCandidateHarvester.getNbHarvesting();
        }
        int nbHarvesting = 0;
        for (CandidateHarvester tmpHarvester : this.harvesters) {
            if (!tmpHarvester.getClass().getName().endsWith(harvesterName) || (nbHarvesting = tmpHarvester.getNbHarvesting()) == 0) continue;
            return nbHarvesting;
        }
        return 0;
    }

    public void startHarvesting() {
        this.harvestingTimeStat.startHarvesting();
    }

    public void stopHarvesting() {
        this.harvestingTimeStat.stopHarvesting();
    }

    public long getTotalHarvestingTime() {
        return this.harvestingTimeStat.getHarvestingTime();
    }

    public int getNbHarvesting() {
        return this.harvestingTimeStat.getNbHarvesting();
    }

    private class StunKeepAliveThread
    extends Thread {
        private StunKeepAliveThread() {
            super("StunKeepAliveThread");
        }

        public synchronized void run() {
            Agent.this.runInStunKeepAliveThread();
        }
    }

    private class TerminationThread
    extends Thread {
        private TerminationThread() {
            super("TerminationThread");
        }

        public synchronized void run() {
            long terminationDelay = Integer.getInteger("org.ice4j.TERMINATION_DELAY", 3000).intValue();
            if (terminationDelay >= 0L) {
                try {
                    this.wait(terminationDelay);
                }
                catch (InterruptedException ie) {
                    logger.log(Level.FINEST, "Interrupted while waiting. Will speed up termination", ie);
                }
            }
            logger.info("ICE state is TERMINATED");
            Agent.this.terminate(IceProcessingState.TERMINATED);
            Agent.this.terminationThread = null;
        }
    }
}

