/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxMouseAdapter;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class mxRotationHandler
extends mxMouseAdapter {
    public static ImageIcon ROTATE_ICON = null;
    private static double PI4;
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected JComponent handle;
    protected mxCellState currentState;
    protected double currentAngle;
    protected Point first;

    public mxRotationHandler(mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        mxGraphComponent2.addMouseListener(this);
        this.handle = this.createHandle();
        mxGraphComponent2.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            public void invoke(Object object, mxEventObject mxEventObject2) {
                Graphics graphics = (Graphics)mxEventObject2.getProperty("g");
                mxRotationHandler.this.paint(graphics);
            }
        });
        mxGraphComponent2.getGraphControl().addMouseListener(this);
        mxGraphComponent2.getGraphControl().addMouseMotionListener(this);
        this.handle.addMouseListener(this);
        this.handle.addMouseMotionListener(this);
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    protected JComponent createHandle() {
        JLabel jLabel = new JLabel(ROTATE_ICON);
        jLabel.setSize(ROTATE_ICON.getIconWidth(), ROTATE_ICON.getIconHeight());
        jLabel.setOpaque(false);
        return jLabel;
    }

    public boolean isStateHandled(mxCellState mxCellState2) {
        return this.graphComponent.getGraph().getModel().isVertex(mxCellState2.getCell());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.currentState != null && this.handle.getParent() != null && mouseEvent.getSource() == this.handle) {
            this.start(mouseEvent);
            mouseEvent.consume();
        }
    }

    public void start(MouseEvent mouseEvent) {
        this.first = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.graphComponent.getGraphControl());
        if (!this.graphComponent.getGraph().isCellSelected(this.currentState.getCell())) {
            this.graphComponent.selectCellForEvent(this.currentState.getCell(), mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed()) {
            if (this.handle.getParent() != null && mouseEvent.getSource() == this.handle) {
                this.graphComponent.getGraphControl().setCursor(new Cursor(12));
                mouseEvent.consume();
            } else if (this.currentState == null || !this.currentState.getRectangle().contains(mouseEvent.getPoint())) {
                mxCellState mxCellState2 = this.graphComponent.getGraph().getView().getState(this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY(), false));
                mxCellState mxCellState3 = null;
                if (mxCellState2 != null && this.isStateHandled(mxCellState2)) {
                    mxCellState3 = mxCellState2;
                }
                if (this.currentState != mxCellState3) {
                    this.currentState = mxCellState3;
                    if (this.currentState == null && this.handle.getParent() != null) {
                        this.handle.setVisible(false);
                        this.handle.getParent().remove(this.handle);
                    } else if (this.currentState != null) {
                        if (this.handle.getParent() == null) {
                            this.graphComponent.getGraphControl().add((Component)this.handle, 0);
                            this.handle.setVisible(true);
                        }
                        this.handle.setLocation((int)(this.currentState.getX() + this.currentState.getWidth() - (double)this.handle.getWidth() - 4.0), (int)(this.currentState.getY() + this.currentState.getHeight() - (double)this.handle.getWidth() - 4.0));
                    }
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed() && this.first != null) {
            mxRectangle mxRectangle2 = mxUtils.getBoundingBox(this.currentState, this.currentAngle * mxConstants.DEG_PER_RAD);
            Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.graphComponent.getGraphControl());
            double d = this.currentState.getCenterX();
            double d2 = this.currentState.getCenterY();
            double d3 = point.getX() - d;
            double d4 = point.getY() - d2;
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            this.currentAngle = (double)(point.getX() > d ? -1 : 1) * Math.acos(d4 / d5) + PI4;
            mxRectangle2.add(mxUtils.getBoundingBox(this.currentState, this.currentAngle * mxConstants.DEG_PER_RAD));
            mxRectangle2.grow(1.0);
            this.graphComponent.getGraphControl().repaint(mxRectangle2.getRectangle());
            mouseEvent.consume();
        } else if (this.handle.getParent() != null) {
            this.handle.getParent().remove(this.handle);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed() && this.first != null) {
            double d = 0.0;
            Object object = null;
            if (this.currentState != null) {
                object = this.currentState.getCell();
                d = mxUtils.getDouble(this.currentState.getStyle(), mxConstants.STYLE_ROTATION);
            }
            d += this.currentAngle * mxConstants.DEG_PER_RAD;
            boolean bl = object != null && this.first != null;
            this.reset();
            if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed() && bl) {
                this.graphComponent.getGraph().setCellStyles(mxConstants.STYLE_ROTATION, String.valueOf(d), new Object[]{object});
                this.graphComponent.getGraphControl().repaint();
                mouseEvent.consume();
            }
        }
    }

    public void reset() {
        if (this.handle.getParent() != null) {
            this.handle.getParent().remove(this.handle);
        }
        mxRectangle mxRectangle2 = null;
        if (this.currentState != null && this.first != null) {
            mxRectangle2 = mxUtils.getBoundingBox(this.currentState, this.currentAngle * mxConstants.DEG_PER_RAD);
            mxRectangle2.grow(1.0);
        }
        this.currentState = null;
        this.currentAngle = 0.0;
        this.first = null;
        if (mxRectangle2 != null) {
            this.graphComponent.getGraphControl().repaint(mxRectangle2.getRectangle());
        }
    }

    public void paint(Graphics graphics) {
        if (this.currentState != null && this.first != null) {
            Rectangle rectangle = this.currentState.getRectangle();
            double d = this.currentAngle * mxConstants.DEG_PER_RAD;
            if (d != 0.0) {
                ((Graphics2D)graphics).rotate(Math.toRadians(d), this.currentState.getCenterX(), this.currentState.getCenterY());
            }
            mxUtils.setAntiAlias((Graphics2D)graphics, true, false);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    static {
        ROTATE_ICON = new ImageIcon(mxRotationHandler.class.getResource("/com/mxgraph/swing/images/rotate.gif"));
        PI4 = 0.7853981633974483;
    }
}

