/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tigris.subversion.javahl.BlameCallback;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.svnclientadapter.AbstractClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.Policy;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNInfoUnversioned;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.JhlAnnotations;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;
import org.tigris.subversion.svnclientadapter.javahl.JhlInfo;
import org.tigris.subversion.svnclientadapter.javahl.JhlInfo2;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlPromptUserPassword;
import org.tigris.subversion.svnclientadapter.javahl.JhlPropertyData;
import org.tigris.subversion.svnclientadapter.javahl.JhlStatus;

public abstract class AbstractJhlClientAdapter
extends AbstractClientAdapter {
    protected static final int SVN_ERR_WC_NOT_DIRECTORY = 155007;
    protected SVNClientInterface svnClient;
    protected JhlNotificationHandler notificationHandler;

    public SVNClientInterface getSVNClient() {
        return this.svnClient;
    }

    public void addNotifyListener(ISVNNotifyListener iSVNNotifyListener) {
        this.notificationHandler.add(iSVNNotifyListener);
    }

    public void removeNotifyListener(ISVNNotifyListener iSVNNotifyListener) {
        this.notificationHandler.remove(iSVNNotifyListener);
    }

    public void setUsername(String string) {
        this.svnClient.username(string);
    }

    public void setPassword(String string) {
        this.notificationHandler.setCommand(0);
        this.svnClient.password(string);
    }

    public void setPromptUserPassword(PromptUserPassword promptUserPassword) {
        this.svnClient.setPrompt(promptUserPassword);
    }

    protected static String fileToSVNPath(File file, boolean bl) {
        if (bl) {
            try {
                return file.getCanonicalPath().replace('\\', '/');
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return file.getPath().replace('\\', '/');
    }

    public void addFile(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(1);
            this.notificationHandler.logCommandLine("add -N " + file.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.add(AbstractJhlClientAdapter.fileToSVNPath(file, false), false);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void addDirectory(File file, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(1);
            this.notificationHandler.logCommandLine("add" + (bl ? "" : "-N") + " " + file.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.add(AbstractJhlClientAdapter.fileToSVNPath(file, false), bl);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void checkout(SVNUrl sVNUrl, File file, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        try {
            String string = sVNUrl.toString();
            this.notificationHandler.setCommand(2);
            this.notificationHandler.logCommandLine("checkout" + (bl ? "" : " -N") + " -r " + sVNRevision.toString() + " " + string);
            this.notificationHandler.setBaseDir(new File("."));
            this.svnClient.checkout(string, AbstractJhlClientAdapter.fileToSVNPath(file, false), JhlConverter.convert(sVNRevision), JhlConverter.convert(sVNRevision), bl, false);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public long commit(File[] fileArray, String string, boolean bl) throws SVNClientException {
        return this.commit(fileArray, string, bl, false);
    }

    public long commit(File[] fileArray, String string, boolean bl, boolean bl2) throws SVNClientException {
        try {
            if (string == null) {
                string = "";
            }
            this.notificationHandler.setCommand(3);
            String[] stringArray = new String[fileArray.length];
            String string2 = "commit -m \"" + string + "\"";
            if (!bl) {
                string2 = string2 + " -N";
            }
            if (bl2) {
                string2 = string2 + " --no-unlock";
            }
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = AbstractJhlClientAdapter.fileToSVNPath(fileArray[i], false);
                string2 = string2 + " " + stringArray[i];
            }
            this.notificationHandler.logCommandLine(string2);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(fileArray));
            long l = this.svnClient.commit(stringArray, string, bl, bl2);
            if (l > 0L) {
                this.notificationHandler.logCompleted("Committed revision " + l + ".");
            }
            return l;
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNDirEntry[] getList(SVNUrl sVNUrl, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(11);
            String string = "list -r " + sVNRevision.toString() + (bl ? "-R" : "") + " " + sVNUrl.toString();
            this.notificationHandler.logCommandLine(string);
            this.notificationHandler.setBaseDir(new File("."));
            return JhlConverter.convert(this.svnClient.list(sVNUrl.toString(), JhlConverter.convert(sVNRevision), bl));
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNDirEntry[] getList(File file, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(11);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            String string2 = "list -r " + sVNRevision.toString() + (bl ? "-R" : "") + " " + file;
            this.notificationHandler.logCommandLine(string2);
            this.notificationHandler.setBaseDir(new File("."));
            return JhlConverter.convert(this.svnClient.list(string, JhlConverter.convert(sVNRevision), bl));
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNDirEntry getDirEntry(SVNUrl sVNUrl, SVNRevision sVNRevision) throws SVNClientException {
        ISVNDirEntry[] iSVNDirEntryArray = this.getList(sVNUrl.getParent(), sVNRevision, false);
        String string = sVNUrl.getLastPathSegment();
        for (int i = 0; i < iSVNDirEntryArray.length; ++i) {
            if (!iSVNDirEntryArray[i].getPath().equals(string)) continue;
            return iSVNDirEntryArray[i];
        }
        return null;
    }

    public ISVNDirEntry getDirEntry(File file, SVNRevision sVNRevision) throws SVNClientException {
        ISVNDirEntry[] iSVNDirEntryArray = this.getList(file.getParentFile(), sVNRevision, false);
        String string = file.getName();
        for (int i = 0; i < iSVNDirEntryArray.length; ++i) {
            if (!iSVNDirEntryArray[i].getPath().equals(string)) continue;
            return iSVNDirEntryArray[i];
        }
        return null;
    }

    public ISVNStatus getSingleStatus(File file) throws SVNClientException {
        return this.getStatus(new File[]{file})[0];
    }

    public ISVNStatus[] getStatus(File[] fileArray) throws SVNClientException {
        this.notificationHandler.setCommand(12);
        String[] stringArray = new String[fileArray.length];
        String string = "status -N --no-ignore";
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = AbstractJhlClientAdapter.fileToSVNPath(fileArray[i], false);
            string = string + " " + stringArray[i];
        }
        this.notificationHandler.logCommandLine(string);
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(fileArray));
        ISVNStatus[] iSVNStatusArray = new ISVNStatus[fileArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Status status = this.svnClient.singleStatus(stringArray[i], false);
                if (status == null) {
                    iSVNStatusArray[i] = new SVNStatusUnversioned(fileArray[i]);
                    continue;
                }
                iSVNStatusArray[i] = new JhlStatus(status);
                continue;
            }
            catch (ClientException clientException) {
                if (clientException.getAprError() == 155007) {
                    iSVNStatusArray[i] = new SVNStatusUnversioned(fileArray[i]);
                    continue;
                }
                this.notificationHandler.logException((Exception)((Object)clientException));
                throw new SVNClientException(clientException);
            }
        }
        return iSVNStatusArray;
    }

    public ISVNStatus[] getStatus(File file, boolean bl, boolean bl2) throws SVNClientException {
        return this.getStatus(file, bl, bl2, false);
    }

    public ISVNStatus[] getStatus(File file, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        this.notificationHandler.setCommand(12);
        String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
        this.notificationHandler.logCommandLine("status " + (bl3 ? "-u " : "") + string);
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
        try {
            return JhlConverter.convert(this.svnClient.status(string, bl, bl3, bl2, bl2));
        }
        catch (ClientException clientException) {
            if (clientException.getAprError() == 155007) {
                return new ISVNStatus[]{new SVNStatusUnversioned(file)};
            }
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void copy(File file, File file2) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(6);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            String string2 = AbstractJhlClientAdapter.fileToSVNPath(file2, false);
            this.notificationHandler.logCommandLine("copy " + string + " " + string2);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{file, file2}));
            this.svnClient.copy(string, string2, "", Revision.HEAD);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void copy(File file, SVNUrl sVNUrl, String string) throws SVNClientException {
        try {
            if (string == null) {
                string = "";
            }
            this.notificationHandler.setCommand(6);
            String string2 = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            String string3 = sVNUrl.toString();
            this.notificationHandler.logCommandLine("copy " + string2 + " " + string3);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.copy(string2, string3, string, Revision.WORKING);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void copy(SVNUrl sVNUrl, File file, SVNRevision sVNRevision) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(6);
            String string = sVNUrl.toString();
            String string2 = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("copy " + string + " " + string2);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.copy(string, string2, "", JhlConverter.convert(sVNRevision));
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void copy(SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, SVNRevision sVNRevision) throws SVNClientException {
        try {
            if (string == null) {
                string = "";
            }
            this.notificationHandler.setCommand(6);
            String string2 = sVNUrl.toString();
            String string3 = sVNUrl2.toString();
            this.notificationHandler.logCommandLine("copy -r" + sVNRevision.toString() + " " + string2 + " " + string3);
            this.notificationHandler.setBaseDir();
            this.svnClient.copy(string2, string3, string, JhlConverter.convert(sVNRevision));
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void remove(SVNUrl[] sVNUrlArray, String string) throws SVNClientException {
        try {
            if (string == null) {
                string = "";
            }
            this.notificationHandler.setCommand(7);
            String string2 = "delete -m \"" + string + "\"";
            String[] stringArray = new String[sVNUrlArray.length];
            for (int i = 0; i < sVNUrlArray.length; ++i) {
                stringArray[i] = sVNUrlArray[i].toString();
                string2 = string2 + " " + stringArray[i];
            }
            this.notificationHandler.logCommandLine(string2);
            this.notificationHandler.setBaseDir();
            this.svnClient.remove(stringArray, string, false);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void remove(File[] fileArray, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(7);
            String string = "delete" + (bl ? " --force" : "");
            String[] stringArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = AbstractJhlClientAdapter.fileToSVNPath(fileArray[i], false);
                string = string + " " + stringArray[i];
            }
            this.notificationHandler.logCommandLine(string);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(fileArray));
            this.svnClient.remove(stringArray, "", bl);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void doExport(SVNUrl sVNUrl, File file, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(8);
            String string = sVNUrl.toString();
            String string2 = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("export -r " + sVNRevision.toString() + ' ' + string + ' ' + string2);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.doExport(string, string2, JhlConverter.convert(sVNRevision), bl);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void doExport(File file, File file2, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(8);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            String string2 = AbstractJhlClientAdapter.fileToSVNPath(file2, false);
            this.notificationHandler.logCommandLine("export " + string + ' ' + string2);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{file, file2}));
            this.svnClient.doExport(string, string2, Revision.HEAD, bl);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void doImport(File file, SVNUrl sVNUrl, String string, boolean bl) throws SVNClientException {
        try {
            if (string == null) {
                string = "";
            }
            this.notificationHandler.setCommand(9);
            String string2 = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            String string3 = sVNUrl.toString();
            this.notificationHandler.logCommandLine("import -m \"" + string + "\" " + (bl ? "" : "-N ") + string2 + ' ' + string3);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.doImport(string2, string3, string, bl);
            this.notificationHandler.logCompleted(Policy.bind("notify.import.complete"));
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void mkdir(SVNUrl sVNUrl, String string) throws SVNClientException {
        try {
            if (string == null) {
                string = "";
            }
            this.notificationHandler.setCommand(10);
            String string2 = sVNUrl.toString();
            this.notificationHandler.logCommandLine("mkdir -m \"" + string + "\" " + string2);
            this.notificationHandler.setBaseDir();
            this.svnClient.mkdir(new String[]{string2}, string);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void mkdir(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(10);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("mkdir " + string);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.mkdir(new String[]{string}, "");
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void move(File file, File file2, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(5);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            String string2 = AbstractJhlClientAdapter.fileToSVNPath(file2, false);
            this.notificationHandler.logCommandLine("move " + string + ' ' + string2);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{file, file2}));
            this.svnClient.move(string, string2, "", Revision.HEAD, bl);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void move(SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, SVNRevision sVNRevision) throws SVNClientException {
        try {
            if (string == null) {
                string = "";
            }
            this.notificationHandler.setCommand(5);
            String string2 = sVNUrl.toString();
            String string3 = sVNUrl2.toString();
            this.notificationHandler.logCommandLine("move -m \"" + string + "\" -r " + sVNRevision.toString() + ' ' + string2 + ' ' + string3);
            this.notificationHandler.setBaseDir();
            this.svnClient.move(string2, string3, string, JhlConverter.convert(sVNRevision), false);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public long update(File file, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(4);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("update -r " + sVNRevision.toString() + ' ' + (bl ? "" : "-N ") + string);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            return this.svnClient.update(string, JhlConverter.convert(sVNRevision), bl);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public long[] update(File[] fileArray, SVNRevision sVNRevision, boolean bl, boolean bl2) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(4);
            String[] stringArray = new String[fileArray.length];
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = AbstractJhlClientAdapter.fileToSVNPath(fileArray[i], false);
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(" ");
            }
            this.notificationHandler.logCommandLine("update -r " + sVNRevision.toString() + ' ' + (bl ? "" : "-N ") + (bl2 ? "--ignore-externals " : "") + stringBuffer.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(fileArray));
            this.notificationHandler.holdStats();
            long[] lArray = this.svnClient.update(stringArray, JhlConverter.convert(sVNRevision), bl, bl2);
            this.notificationHandler.releaseStats();
            return lArray;
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void revert(File file, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(16);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("revert " + (bl ? "" : "-N ") + string);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.revert(string, bl);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl) throws SVNClientException {
        String string = sVNUrl.toString();
        this.notificationHandler.setBaseDir();
        return this.getLogMessages(string, sVNRevision, sVNRevision2, false, bl, 0L);
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl) throws SVNClientException {
        String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
        return this.getLogMessages(string, sVNRevision, sVNRevision2, false, bl, 0L);
    }

    public static void enableLogging(int n, File file) {
        SVNClient.enableLogging((int)n, (String)AbstractJhlClientAdapter.fileToSVNPath(file, false));
    }

    public InputStream getContent(SVNUrl sVNUrl, SVNRevision sVNRevision) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(18);
            this.notificationHandler.logCommandLine("cat -r " + sVNRevision.toString() + " " + sVNUrl.toString());
            this.notificationHandler.setBaseDir();
            byte[] byArray = this.svnClient.fileContent(sVNUrl.toString(), JhlConverter.convert(sVNRevision), Revision.HEAD);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return byteArrayInputStream;
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public InputStream getContent(File file, SVNRevision sVNRevision) throws SVNClientException {
        try {
            Object object;
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.setCommand(18);
            this.notificationHandler.logCommandLine("cat -r " + sVNRevision.toString() + " " + string);
            this.notificationHandler.setBaseDir();
            if (sVNRevision.equals(SVNRevision.BASE) && (object = this.getSingleStatus(file)).getTextStatus().equals(SVNStatusKind.ADDED)) {
                return new ByteArrayInputStream(new byte[0]);
            }
            object = this.svnClient.fileContent(string, JhlConverter.convert(sVNRevision));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            return byteArrayInputStream;
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNProperty[] getProperties(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("proplist " + string);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            PropertyData[] propertyDataArray = this.svnClient.properties(string);
            if (propertyDataArray == null) {
                return new JhlPropertyData[0];
            }
            ISVNProperty[] iSVNPropertyArray = new JhlPropertyData[propertyDataArray.length];
            for (int i = 0; i < propertyDataArray.length; ++i) {
                iSVNPropertyArray[i] = new JhlPropertyData(propertyDataArray[i]);
            }
            return iSVNPropertyArray;
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNProperty[] getProperties(SVNUrl sVNUrl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String string = sVNUrl.toString();
            this.notificationHandler.logCommandLine("proplist " + string);
            this.notificationHandler.setBaseDir();
            PropertyData[] propertyDataArray = this.svnClient.properties(string);
            if (propertyDataArray == null) {
                return new JhlPropertyData[0];
            }
            ISVNProperty[] iSVNPropertyArray = new JhlPropertyData[propertyDataArray.length];
            for (int i = 0; i < propertyDataArray.length; ++i) {
                iSVNPropertyArray[i] = new JhlPropertyData(propertyDataArray[i]);
            }
            return iSVNPropertyArray;
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void propertySet(File file, String string, String string2, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(14);
            String string3 = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("propset " + (bl ? "-R " : "") + string + " \"" + string2 + "\" " + string3);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.propertySet(string3, string, string2, bl);
            ISVNStatus[] iSVNStatusArray = this.getStatus(file, bl, false);
            for (int i = 0; i < iSVNStatusArray.length; ++i) {
                this.notificationHandler.notifyListenersOfChange(iSVNStatusArray[i].getFile().getAbsolutePath());
            }
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertySet(File file, String string, File file2, boolean bl) throws SVNClientException {
        try {
            byte[] byArray;
            String string2;
            block10: {
                this.notificationHandler.setCommand(14);
                string2 = AbstractJhlClientAdapter.fileToSVNPath(file, false);
                this.notificationHandler.logCommandLine("propset " + (bl ? "-R " : "") + string + "-F \"" + file2.toString() + "\" " + string2);
                this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
                byArray = new byte[(int)file2.length()];
                FileInputStream fileInputStream = null;
                try {
                    try {
                        fileInputStream = new FileInputStream(file2);
                        fileInputStream.read(byArray);
                    }
                    catch (IOException iOException) {
                        throw new SVNClientException(iOException);
                    }
                    Object var10_9 = null;
                    if (fileInputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (fileInputStream == null) throw throwable;
                    try {
                        fileInputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                fileInputStream.close();
            }
            this.svnClient.propertySet(string2, string, byArray, bl);
            ISVNStatus[] iSVNStatusArray = this.getStatus(file, bl, false);
            int n = 0;
            while (n < iSVNStatusArray.length) {
                this.notificationHandler.notifyListenersOfChange(iSVNStatusArray[n].getFile().getAbsolutePath());
                ++n;
            }
            return;
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNProperty propertyGet(File file, String string) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(20);
            String string2 = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("propget " + string + " " + string2);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            PropertyData propertyData = this.svnClient.propertyGet(string2, string);
            if (propertyData == null) {
                return null;
            }
            return new JhlPropertyData(propertyData);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNProperty propertyGet(SVNUrl sVNUrl, String string) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(20);
            String string2 = sVNUrl.toString();
            this.notificationHandler.logCommandLine("propget " + string + " " + string2);
            this.notificationHandler.setBaseDir();
            PropertyData propertyData = this.svnClient.propertyGet(string2, string);
            if (propertyData == null) {
                return null;
            }
            return new JhlPropertyData(propertyData);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void propertyDel(File file, String string, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(15);
            String string2 = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("propdel " + string + " " + string2);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            PropertyData propertyData = this.svnClient.propertyGet(string2, string);
            propertyData.remove(bl);
            ISVNStatus[] iSVNStatusArray = this.getStatus(file, bl, false);
            for (int i = 0; i < iSVNStatusArray.length; ++i) {
                this.notificationHandler.notifyListenersOfChange(iSVNStatusArray[i].getFile().getAbsolutePath());
            }
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void diff(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, File file3, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (file == null) {
                file = new File(".");
            }
            if (file2 == null) {
                file2 = file;
            }
            if (sVNRevision == null) {
                sVNRevision = SVNRevision.BASE;
            }
            if (sVNRevision2 == null) {
                sVNRevision2 = SVNRevision.WORKING;
            }
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            String string2 = AbstractJhlClientAdapter.fileToSVNPath(file2, false);
            String string3 = AbstractJhlClientAdapter.fileToSVNPath(file3, false);
            String string4 = "diff ";
            if (sVNRevision.getKind() != 5 || sVNRevision2.getKind() != 6) {
                string4 = string4 + "-r " + sVNRevision.toString();
                if (sVNRevision2.getKind() != 6) {
                    string4 = string4 + ":" + sVNRevision2.toString();
                }
                string4 = string4 + " ";
            }
            if (!file.equals(new File("."))) {
                string4 = string4 + "--old " + string + " ";
            }
            if (!file2.equals(file)) {
                string4 = string4 + "--new " + string2 + " ";
            }
            this.notificationHandler.logCommandLine(string4);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{file, file2}));
            this.svnClient.diff(string, JhlConverter.convert(sVNRevision), string2, JhlConverter.convert(sVNRevision2), string3, bl);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void diff(File file, File file2, boolean bl) throws SVNClientException {
        this.diff(file, null, null, null, file2, bl);
    }

    public void diff(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, File file, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (sVNUrl2 == null) {
                sVNUrl2 = sVNUrl;
            }
            if (sVNRevision == null) {
                sVNRevision = SVNRevision.HEAD;
            }
            if (sVNRevision2 == null) {
                sVNRevision2 = SVNRevision.HEAD;
            }
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            String string2 = "diff ";
            if (sVNRevision.getKind() != 7 || sVNRevision2.getKind() != 7) {
                string2 = string2 + "-r " + sVNRevision.toString();
                if (sVNRevision2.getKind() != 7) {
                    string2 = string2 + ":" + sVNRevision2.toString();
                }
                string2 = string2 + " ";
            }
            string2 = string2 + sVNUrl + " ";
            if (!sVNUrl2.equals(sVNUrl)) {
                string2 = string2 + sVNUrl2 + " ";
            }
            this.notificationHandler.logCommandLine(string2);
            this.notificationHandler.setBaseDir();
            this.svnClient.diff(sVNUrl.toString(), JhlConverter.convert(sVNRevision), sVNUrl2.toString(), JhlConverter.convert(sVNRevision2), string, bl);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void diff(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, File file, boolean bl) throws SVNClientException {
        this.diff(sVNUrl, sVNRevision, sVNUrl, sVNRevision2, file, bl);
    }

    private ISVNAnnotations annotate(String string, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(25);
            if (sVNRevision == null) {
                sVNRevision = new SVNRevision.Number(1L);
            }
            if (sVNRevision2 == null) {
                sVNRevision2 = SVNRevision.HEAD;
            }
            String string2 = "blame ";
            string2 = string2 + "-r " + sVNRevision2.toString() + " ";
            string2 = string2 + string + "@HEAD";
            this.notificationHandler.logCommandLine(string2);
            this.notificationHandler.setBaseDir();
            JhlAnnotations jhlAnnotations = new JhlAnnotations();
            this.svnClient.blame(string, Revision.HEAD, JhlConverter.convert(sVNRevision), JhlConverter.convert(sVNRevision2), (BlameCallback)jhlAnnotations);
            return jhlAnnotations;
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNAnnotations annotate(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        return this.annotate(sVNUrl.toString(), sVNRevision, sVNRevision2);
    }

    public ISVNAnnotations annotate(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        return this.annotate(AbstractJhlClientAdapter.fileToSVNPath(file, false), sVNRevision, sVNRevision2);
    }

    public void resolved(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(22);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, true);
            this.notificationHandler.logCommandLine("resolved " + string);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.resolved(string, false);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void cancelOperation() throws SVNClientException {
        try {
            this.svnClient.cancelOperation();
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNInfo getInfoFromWorkingCopy(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("info " + string);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            Info info = this.svnClient.info(string);
            if (info == null) {
                return new SVNInfoUnversioned(file);
            }
            return new JhlInfo(file, info);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNInfo getInfo(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("info " + string);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            Info info = this.svnClient.info(string);
            if (info == null) {
                return new SVNInfoUnversioned(file);
            }
            if (info.getLastChangedRevision() == -1L) {
                return new JhlInfo(file, info);
            }
            Info2[] info2Array = this.svnClient.info2(string, Revision.HEAD, Revision.HEAD, false);
            if (info2Array == null || info2Array.length == 0) {
                return new SVNInfoUnversioned(file);
            }
            return new JhlInfo2(file, info2Array[0]);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNInfo getInfo(SVNUrl sVNUrl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String string = sVNUrl.toString();
            this.notificationHandler.logCommandLine("info " + string);
            Info2[] info2Array = this.svnClient.info2(string, Revision.HEAD, Revision.HEAD, false);
            if (info2Array == null || info2Array.length == 0) {
                return new SVNInfoUnversioned(null);
            }
            return new JhlInfo2(null, info2Array[0]);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public SVNUrl getRepositoryRoot(SVNUrl sVNUrl) {
        return null;
    }

    public void switchToUrl(File file, SVNUrl sVNUrl, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(26);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            String string2 = "switch " + sVNUrl + " " + string + " " + "-r" + sVNRevision.toString();
            if (!bl) {
                string2 = string2 + " -N";
            }
            this.notificationHandler.logCommandLine(string2);
            File file2 = SVNBaseDir.getBaseDir(file);
            this.notificationHandler.setBaseDir(file2);
            this.svnClient.doSwitch(string, sVNUrl.toString(), JhlConverter.convert(sVNRevision), bl);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void setConfigDirectory(File file) throws SVNClientException {
        try {
            this.svnClient.setConfigDirectory(AbstractJhlClientAdapter.fileToSVNPath(file, false));
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void cleanup(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(24);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            String string2 = "cleanup " + string;
            this.notificationHandler.logCommandLine(string2);
            this.svnClient.cleanup(string);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void merge(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, File file, boolean bl, boolean bl2) throws SVNClientException {
        this.merge(sVNUrl, sVNRevision, sVNUrl2, sVNRevision2, file, bl, bl2, false);
    }

    public void merge(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, File file, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            String string2 = "merge";
            if (!bl2) {
                string2 = string2 + " -N";
            }
            if (bl3) {
                string2 = string2 + " --dry-run";
            }
            if (bl) {
                string2 = string2 + " --force";
            }
            string2 = sVNUrl.toString().equals(sVNUrl2.toString()) ? string2 + " -r" + sVNRevision.toString() + ":" + sVNRevision2.toString() + " " + sVNUrl : string2 + " " + sVNUrl + "@" + sVNRevision.toString() + " " + sVNUrl2 + "@" + sVNRevision2.toString();
            string2 = string2 + " " + string;
            this.notificationHandler.logCommandLine(string2);
            File file2 = SVNBaseDir.getBaseDir(file);
            this.notificationHandler.setBaseDir(file2);
            this.svnClient.merge(sVNUrl.toString(), JhlConverter.convert(sVNRevision), sVNUrl2.toString(), JhlConverter.convert(sVNRevision2), string, bl, bl2, false, bl3);
            if (bl3) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void addPasswordCallback(ISVNPromptUserPassword iSVNPromptUserPassword) {
        if (iSVNPromptUserPassword != null) {
            JhlPromptUserPassword jhlPromptUserPassword = new JhlPromptUserPassword(iSVNPromptUserPassword);
            this.setPromptUserPassword((PromptUserPassword)jhlPromptUserPassword);
        }
    }

    public void lock(SVNUrl[] sVNUrlArray, String string, boolean bl) throws SVNClientException {
        this.notImplementedYet();
    }

    public void unlock(SVNUrl[] sVNUrlArray, boolean bl) throws SVNClientException {
        this.notImplementedYet();
    }

    public void lock(File[] fileArray, String string, boolean bl) throws SVNClientException {
        try {
            int n;
            this.notificationHandler.setCommand(28);
            String[] stringArray = new String[fileArray.length];
            String string2 = "lock -m \"" + string + "\"";
            if (bl) {
                string2 = string2 + " --force";
            }
            for (n = 0; n < fileArray.length; ++n) {
                stringArray[n] = AbstractJhlClientAdapter.fileToSVNPath(fileArray[n], false);
                string2 = string2 + " " + stringArray[n];
            }
            this.notificationHandler.logCommandLine(string2);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(fileArray));
            this.svnClient.lock(stringArray, string, bl);
            for (n = 0; n < stringArray.length; ++n) {
                this.notificationHandler.notifyListenersOfChange(stringArray[n]);
            }
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
        }
    }

    public void unlock(File[] fileArray, boolean bl) throws SVNClientException {
        try {
            int n;
            this.notificationHandler.setCommand(28);
            String[] stringArray = new String[fileArray.length];
            String string = "unlock ";
            if (bl) {
                string = string + " --force";
            }
            for (n = 0; n < fileArray.length; ++n) {
                stringArray[n] = AbstractJhlClientAdapter.fileToSVNPath(fileArray[n], false);
                string = string + " " + stringArray[n];
            }
            this.notificationHandler.logCommandLine(string);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(fileArray));
            this.svnClient.unlock(stringArray, bl);
            for (n = 0; n < stringArray.length; ++n) {
                this.notificationHandler.notifyListenersOfChange(stringArray[n]);
            }
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
        }
    }

    public void setRevProperty(SVNUrl sVNUrl, SVNRevision.Number number, String string, String string2, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(14);
            this.notificationHandler.logCommandLine("propset --revprop -r " + number.toString() + (bl ? "--force " : "") + " \"" + string + "\"  \"" + string2 + "\" " + sVNUrl.toString());
            this.notificationHandler.setBaseDir();
            this.svnClient.setRevProperty(sVNUrl.toString(), string, Revision.getInstance((long)number.getNumber()), string2, true);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public String getAdminDirectoryName() {
        return this.svnClient.getAdminDirectoryName();
    }

    public boolean isAdminDirectory(String string) {
        return this.svnClient.isAdminDirectory(string);
    }

    private ISVNLogMessage[] getLogMessages(String string, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2, long l) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(13);
            String string2 = "";
            if (bl) {
                string2 = string2 + " --stop-on-copy";
            }
            if (l > 0L) {
                string2 = string2 + " --limit " + l;
            }
            this.notificationHandler.logCommandLine("log -r " + sVNRevision.toString() + ":" + sVNRevision2.toString() + " " + string + string2);
            return JhlConverter.convert(this.svnClient.logMessages(string, JhlConverter.convert(sVNRevision), JhlConverter.convert(sVNRevision2), bl, bl2, l));
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2, long l) throws SVNClientException {
        String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
        return this.getLogMessages(string, sVNRevision, sVNRevision2, bl, bl2, l);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl, boolean bl2, long l) throws SVNClientException {
        String string = sVNUrl.toString();
        this.notificationHandler.setBaseDir();
        return this.getLogMessages(string, sVNRevision2, sVNRevision3, bl, bl2, l);
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2) throws SVNClientException {
        String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
        return this.getLogMessages(string, sVNRevision, sVNRevision2, bl, bl2, 0L);
    }

    public void relocate(String string, String string2, String string3, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(30);
            if (bl) {
                this.notificationHandler.logCommandLine("switch --relocate " + string + " " + string2 + " " + string3);
            } else {
                this.notificationHandler.logCommandLine("switch --relocate -N" + string + " " + string2 + " " + string3);
            }
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File(string3)));
            this.svnClient.relocate(string, string2, string3, bl);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public void diff(File file, SVNUrl sVNUrl, SVNRevision sVNRevision, File file2, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            String string = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            String string2 = AbstractJhlClientAdapter.fileToSVNPath(file2, false);
            String string3 = "diff --old " + string + " ";
            string3 = string3 + "--new " + sVNUrl.toString();
            if (!sVNRevision.equals(SVNRevision.HEAD)) {
                string3 = string3 + "@" + sVNRevision.toString();
            }
            this.notificationHandler.logCommandLine(string3);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.diff(string, Revision.WORKING, sVNUrl.toString(), JhlConverter.convert(sVNRevision), string2, bl);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public static class DefaultPromptUserPassword
    implements PromptUserPassword {
        public String askQuestion(String string, String string2, boolean bl) {
            return "";
        }

        public boolean askYesNo(String string, String string2, boolean bl) {
            return bl;
        }

        public String getPassword() {
            return "";
        }

        public String getUsername() {
            return "";
        }

        public boolean prompt(String string, String string2) {
            return false;
        }
    }
}

