/*
 * Decompiled with CFR 0.152.
 */
package jgnash.text;

import java.math.BigDecimal;

public class BigDecimalToWords {
    private static final String[] tens = new String[]{"", "", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final String[] ones = new String[]{"", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};

    private BigDecimalToWords() {
    }

    public static String convert(BigDecimal decimal) {
        BigDecimal temp = decimal.setScale(2, 6);
        StringBuilder val = new StringBuilder(BigDecimalToWords.convert(temp.longValue()));
        if (val.charAt(val.length() - 1) != ' ') {
            val.append(' ');
        }
        val.setCharAt(0, Character.toUpperCase(val.charAt(0)));
        String t = temp.toPlainString();
        int index = t.indexOf(46);
        val.append("and ");
        if (index >= 0) {
            return val + t.substring(index + 1) + "/100";
        }
        return val + "00/100";
    }

    private static String convert(long number) {
        long temp = number;
        long billions = temp / 1000000000L;
        long millions = (temp %= 1000000000L) / 1000000L;
        long thousands = (temp %= 1000000L) / 1000L;
        long hundreds = (temp %= 1000L) / 100L;
        temp %= 100L;
        StringBuilder result = new StringBuilder();
        if (billions > 0L) {
            result.append(BigDecimalToWords.convert(billions)).append(" billion ");
        }
        if (millions > 0L) {
            result.append(BigDecimalToWords.convert(millions)).append(" million ");
        }
        if (thousands > 0L) {
            result.append(BigDecimalToWords.convert(thousands)).append(" thousand ");
        }
        if (hundreds > 0L) {
            result.append(BigDecimalToWords.convert(hundreds)).append(" hundred ");
        }
        if (temp != 0L) {
            if (0L < temp && temp <= 19L) {
                result.append(ones[(int)temp]);
            } else {
                long ten = temp / 10L;
                long one = temp % 10L;
                result.append(tens[(int)ten]);
                if (one > 0L) {
                    result.append('-');
                    result.append(ones[(int)one]);
                }
            }
        }
        return result.toString();
    }
}

