/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.search;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import jgnash.engine.Transaction;
import jgnash.engine.search.Matcher;

public class SearchDefinition
implements Serializable {
    private static final long serialVersionUID = -5064899725574780027L;
    private final Criteria criteria;
    private final Collection<Matcher> matcherCollection;

    public SearchDefinition(Criteria criteria, Collection<Matcher> matcherCollection) {
        this.criteria = criteria;
        this.matcherCollection = matcherCollection;
    }

    public boolean matches(Transaction t) {
        boolean result = false;
        if (this.criteria == Criteria.ANY) {
            for (Matcher m : this.matcherCollection) {
                if (!m.matches(t)) continue;
                result = true;
                break;
            }
        } else {
            for (Matcher m : this.matcherCollection) {
                if (!m.matches(t)) break;
            }
            result = true;
        }
        return result;
    }

    public Set<Transaction> matches(Collection<Transaction> transactions) {
        HashSet<Transaction> set = new HashSet<Transaction>();
        for (Transaction t : transactions) {
            if (!this.matches(t)) continue;
            set.add(t);
        }
        return set;
    }

    public static enum Criteria {
        ALL,
        ANY;

    }
}

