/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class JRGroovyGenerator {
    private static final int EXPR_MAX_COUNT_PER_METHOD = 100;
    private static Map fieldPrefixMap = null;
    private static Map variablePrefixMap = null;
    private static Map methodSuffixMap = null;
    protected final JRSourceCompileTask sourceTask;
    protected Map parametersMap;
    protected Map fieldsMap;
    protected Map variablesMap;
    protected JRVariable[] variables;

    protected JRGroovyGenerator(JRSourceCompileTask sourceTask) {
        this.sourceTask = sourceTask;
        this.parametersMap = sourceTask.getParametersMap();
        this.fieldsMap = sourceTask.getFieldsMap();
        this.variablesMap = sourceTask.getVariablesMap();
        this.variables = sourceTask.getVariables();
    }

    public static String generateClass(JRSourceCompileTask sourceTask) throws JRException {
        JRGroovyGenerator generator = new JRGroovyGenerator(sourceTask);
        return generator.generateClass();
    }

    protected String generateClass() throws JRException {
        StringBuffer sb = new StringBuffer();
        this.generateClassStart(sb);
        this.generateDeclarations(sb);
        this.generateInitMethod(sb);
        this.generateInitParamsMethod(sb);
        if (this.fieldsMap != null) {
            this.generateInitFieldsMethod(sb);
        }
        this.generateInitVarsMethod(sb);
        List expressions = this.sourceTask.getExpressions();
        sb.append(this.generateMethod((byte)3, expressions));
        if (this.sourceTask.isOnlyDefaultEvaluation()) {
            ArrayList empty = new ArrayList();
            sb.append(this.generateMethod((byte)1, empty));
            sb.append(this.generateMethod((byte)2, empty));
        } else {
            sb.append(this.generateMethod((byte)1, expressions));
            sb.append(this.generateMethod((byte)2, expressions));
        }
        sb.append("}\n");
        return sb.toString();
    }

    private void generateInitMethod(StringBuffer sb) {
        sb.append("\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    void customizedInit(\n");
        sb.append("        Map pm,\n");
        sb.append("        Map fm,\n");
        sb.append("        Map vm\n");
        sb.append("        )\n");
        sb.append("    {\n");
        sb.append("        initParams(pm);\n");
        if (this.fieldsMap != null) {
            sb.append("        initFields(fm);\n");
        }
        sb.append("        initVars(vm);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
    }

    protected final void generateClassStart(StringBuffer sb) {
        sb.append("/*\n");
        sb.append(" * Generated by JasperReports - ");
        sb.append(new SimpleDateFormat().format(new Date()));
        sb.append("\n");
        sb.append(" */\n");
        sb.append("import net.sf.jasperreports.engine.*;\n");
        sb.append("import net.sf.jasperreports.engine.fill.*;\n");
        sb.append("\n");
        sb.append("import java.util.*;\n");
        sb.append("import java.math.*;\n");
        sb.append("import java.text.*;\n");
        sb.append("import java.io.*;\n");
        sb.append("import java.net.*;\n");
        sb.append("\n");
        String[] imports = this.sourceTask.getImports();
        if (imports != null && imports.length > 0) {
            for (int i = 0; i < imports.length; ++i) {
                sb.append("import ");
                sb.append(imports[i]);
                sb.append(";\n");
            }
        }
        sb.append("\n");
        sb.append("\n");
        sb.append("/**\n");
        sb.append(" *\n");
        sb.append(" */\n");
        sb.append("class ");
        sb.append(this.sourceTask.getUnitName());
        sb.append(" extends JREvaluator\n");
        sb.append("{\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
    }

    protected final void generateDeclarations(StringBuffer sb) {
        Iterator it;
        if (this.parametersMap != null && this.parametersMap.size() > 0) {
            Set parameterNames = this.parametersMap.keySet();
            it = parameterNames.iterator();
            while (it.hasNext()) {
                sb.append("    private JRFillParameter parameter_");
                sb.append(JRStringUtil.getLiteral((String)it.next()));
                sb.append(" = null;\n");
            }
        }
        if (this.fieldsMap != null && this.fieldsMap.size() > 0) {
            Set fieldNames = this.fieldsMap.keySet();
            it = fieldNames.iterator();
            while (it.hasNext()) {
                sb.append("    private JRFillField field_");
                sb.append(JRStringUtil.getLiteral((String)it.next()));
                sb.append(" = null;\n");
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            for (int i = 0; i < this.variables.length; ++i) {
                sb.append("    private JRFillVariable variable_");
                sb.append(JRStringUtil.getLiteral(this.variables[i].getName()));
                sb.append(" = null;\n");
            }
        }
    }

    protected final void generateInitParamsMethod(StringBuffer sb) throws JRException {
        Iterator<Object> parIt = null;
        parIt = this.parametersMap != null && this.parametersMap.size() > 0 ? this.parametersMap.keySet().iterator() : Collections.EMPTY_SET.iterator();
        this.generateInitParamsMethod(sb, parIt, 0);
    }

    protected final void generateInitFieldsMethod(StringBuffer sb) throws JRException {
        Iterator<Object> fieldIt = null;
        fieldIt = this.fieldsMap != null && this.fieldsMap.size() > 0 ? this.fieldsMap.keySet().iterator() : Collections.EMPTY_SET.iterator();
        this.generateInitFieldsMethod(sb, fieldIt, 0);
    }

    protected final void generateInitVarsMethod(StringBuffer sb) throws JRException {
        Iterator<Object> varIt = null;
        varIt = this.variables != null && this.variables.length > 0 ? Arrays.asList(this.variables).iterator() : Collections.EMPTY_LIST.iterator();
        this.generateInitVarsMethod(sb, varIt, 0);
    }

    private void generateInitParamsMethod(StringBuffer sb, Iterator it, int index) throws JRException {
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    void initParams");
        if (index > 0) {
            sb.append(index);
        }
        sb.append("(Map pm)\n");
        sb.append("    {\n");
        for (int i = 0; i < 100 && it.hasNext(); ++i) {
            String parameterName = (String)it.next();
            sb.append("        parameter_");
            sb.append(JRStringUtil.getLiteral(parameterName));
            sb.append(" = (JRFillParameter)pm.get(\"");
            sb.append(JRStringUtil.escapeJavaStringLiteral(parameterName));
            sb.append("\");\n");
        }
        if (it.hasNext()) {
            sb.append("        initParams");
            sb.append(index + 1);
            sb.append("(pm);\n");
        }
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        if (it.hasNext()) {
            this.generateInitParamsMethod(sb, it, index + 1);
        }
    }

    private void generateInitFieldsMethod(StringBuffer sb, Iterator it, int index) throws JRException {
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    void initFields");
        if (index > 0) {
            sb.append(index);
        }
        sb.append("(Map fm)\n");
        sb.append("    {\n");
        for (int i = 0; i < 100 && it.hasNext(); ++i) {
            String fieldName = (String)it.next();
            sb.append("        field_");
            sb.append(JRStringUtil.getLiteral(fieldName));
            sb.append(" = (JRFillField)fm.get(\"");
            sb.append(JRStringUtil.escapeJavaStringLiteral(fieldName));
            sb.append("\");\n");
        }
        if (it.hasNext()) {
            sb.append("        initFields");
            sb.append(index + 1);
            sb.append("(fm);\n");
        }
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        if (it.hasNext()) {
            this.generateInitFieldsMethod(sb, it, index + 1);
        }
    }

    private void generateInitVarsMethod(StringBuffer sb, Iterator it, int index) throws JRException {
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    void initVars");
        if (index > 0) {
            sb.append(index);
        }
        sb.append("(Map vm)\n");
        sb.append("    {\n");
        for (int i = 0; i < 100 && it.hasNext(); ++i) {
            String variableName = ((JRVariable)it.next()).getName();
            sb.append("        variable_");
            sb.append(JRStringUtil.getLiteral(variableName));
            sb.append(" = (JRFillVariable)vm.get(\"");
            sb.append(JRStringUtil.escapeJavaStringLiteral(variableName));
            sb.append("\");\n");
        }
        if (it.hasNext()) {
            sb.append("        initVars");
            sb.append(index + 1);
            sb.append("(vm);\n");
        }
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        if (it.hasNext()) {
            this.generateInitVarsMethod(sb, it, index + 1);
        }
    }

    protected final String generateMethod(byte evaluationType, List expressionsList) throws JRException {
        StringBuffer sb = new StringBuffer();
        if (expressionsList != null && !expressionsList.isEmpty()) {
            sb.append(this.generateMethod(expressionsList.iterator(), 0, evaluationType, expressionsList.size()));
        } else {
            sb.append("    /**\n");
            sb.append("     *\n");
            sb.append("     */\n");
            sb.append("    Object evaluate");
            sb.append((String)methodSuffixMap.get(new Byte(evaluationType)));
            sb.append("(int id)\n");
            sb.append("    {\n");
            sb.append("        return null;\n");
            sb.append("    }\n");
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    private String generateMethod(Iterator it, int index, byte evaluationType, int expressionCount) throws JRException {
        boolean nextMethod;
        StringBuffer sb = new StringBuffer();
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    Object evaluate");
        sb.append((String)methodSuffixMap.get(new Byte(evaluationType)));
        if (index > 0) {
            sb.append(index);
        }
        sb.append("(int id)\n");
        sb.append("    {\n");
        sb.append("        Object value = null;\n");
        sb.append("\n");
        int expressionIdLimit = (index + 1) * 100;
        boolean bl = nextMethod = expressionCount > expressionIdLimit;
        if (nextMethod) {
            sb.append("        if (id >= ");
            sb.append(expressionIdLimit);
            sb.append(")\n");
            sb.append("        {\n");
            sb.append("            value = evaluate");
            sb.append((String)methodSuffixMap.get(new Byte(evaluationType)));
            sb.append(index + 1);
            sb.append("(id);\n");
            sb.append("        }\n");
        }
        for (int i = 0; it.hasNext() && i < 100; ++i) {
            JRExpression expression = (JRExpression)it.next();
            sb.append("        ");
            if (i > 0 || nextMethod) {
                sb.append("else ");
            }
            sb.append("if (id == ");
            sb.append(this.sourceTask.getExpressionId(expression));
            sb.append(")\n");
            sb.append("        {\n");
            sb.append("            value = (");
            sb.append(expression.getValueClassName());
            sb.append(")(");
            sb.append(this.generateExpression(expression, evaluationType));
            sb.append(");\n");
            sb.append("        }\n");
        }
        sb.append("\n");
        sb.append("        return value;\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        if (nextMethod) {
            sb.append(this.generateMethod(it, index + 1, evaluationType, expressionCount));
        }
        return sb.toString();
    }

    private String generateExpression(JRExpression expression, byte evaluationType) {
        StringBuffer sb = new StringBuffer();
        JRExpressionChunk[] chunks = expression.getChunks();
        if (chunks != null && chunks.length > 0) {
            block7: for (int i = 0; i < chunks.length; ++i) {
                JRExpressionChunk chunk = chunks[i];
                String chunkText = chunk.getText();
                if (chunkText == null) {
                    chunkText = "";
                }
                switch (chunk.getType()) {
                    case 1: {
                        sb.append(chunkText);
                        continue block7;
                    }
                    case 2: {
                        JRParameter jrParameter = (JRParameter)this.parametersMap.get(chunkText);
                        sb.append("(");
                        if (!"java.lang.Object".equals(jrParameter.getValueClassName())) {
                            sb.append("(");
                            sb.append(jrParameter.getValueClassName());
                            sb.append(")");
                        }
                        sb.append("parameter_");
                        sb.append(JRStringUtil.getLiteral(chunkText));
                        sb.append(".getValue())");
                        continue block7;
                    }
                    case 3: {
                        JRField jrField = (JRField)this.fieldsMap.get(chunkText);
                        sb.append("(");
                        if (!"java.lang.Object".equals(jrField.getValueClassName())) {
                            sb.append("(");
                            sb.append(jrField.getValueClassName());
                            sb.append(")");
                        }
                        sb.append("field_");
                        sb.append(JRStringUtil.getLiteral(chunkText));
                        sb.append(".get");
                        sb.append((String)fieldPrefixMap.get(new Byte(evaluationType)));
                        sb.append("Value())");
                        continue block7;
                    }
                    case 4: {
                        JRVariable jrVariable = (JRVariable)this.variablesMap.get(chunkText);
                        sb.append("(");
                        if (!"java.lang.Object".equals(jrVariable.getValueClassName())) {
                            sb.append("(");
                            sb.append(jrVariable.getValueClassName());
                            sb.append(")");
                        }
                        sb.append("variable_");
                        sb.append(JRStringUtil.getLiteral(chunkText));
                        sb.append(".get");
                        sb.append((String)variablePrefixMap.get(new Byte(evaluationType)));
                        sb.append("Value())");
                        continue block7;
                    }
                    case 5: {
                        sb.append("str(\"");
                        sb.append(JRStringUtil.escapeJavaStringLiteral(chunkText));
                        sb.append("\")");
                    }
                }
            }
        }
        if (sb.length() == 0) {
            sb.append("null");
        }
        return sb.toString();
    }

    static {
        fieldPrefixMap = new HashMap();
        fieldPrefixMap.put(new Byte(1), "Old");
        fieldPrefixMap.put(new Byte(2), "");
        fieldPrefixMap.put(new Byte(3), "");
        variablePrefixMap = new HashMap();
        variablePrefixMap.put(new Byte(1), "Old");
        variablePrefixMap.put(new Byte(2), "Estimated");
        variablePrefixMap.put(new Byte(3), "");
        methodSuffixMap = new HashMap();
        methodSuffixMap.put(new Byte(1), "Old");
        methodSuffixMap.put(new Byte(2), "Estimated");
        methodSuffixMap.put(new Byte(3), "");
    }
}

