/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.events;

import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.ext.Db4oException;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ReflectException;

public class Event4Impl
implements Event4 {
    private Collection4 _listeners;

    public final void addListener(EventListener4 eventListener4) {
        this.validateListener(eventListener4);
        Collection4 collection4 = new Collection4();
        collection4.add(eventListener4);
        this.addExistingListenersTo(collection4);
        this._listeners = collection4;
        this.onListenerAdded();
    }

    private void addExistingListenersTo(Collection4 collection4) {
        if (this._listeners == null) {
            return;
        }
        Iterator4 iterator4 = this._listeners.iterator();
        while (iterator4.moveNext()) {
            collection4.add(iterator4.current());
        }
    }

    protected void onListenerAdded() {
    }

    public final void removeListener(EventListener4 eventListener4) {
        this.validateListener(eventListener4);
        if (null == this._listeners) {
            return;
        }
        Collection4 collection4 = new Collection4();
        this.addExistingListenersTo(collection4);
        collection4.remove(eventListener4);
        this._listeners = collection4;
    }

    public final void trigger(EventArgs eventArgs) {
        if (null == this._listeners) {
            return;
        }
        Iterator4 iterator4 = this._listeners.iterator();
        while (iterator4.moveNext()) {
            EventListener4 eventListener4 = (EventListener4)iterator4.current();
            this.onEvent(eventListener4, this, eventArgs);
        }
    }

    private void onEvent(EventListener4 eventListener4, Event4 event4, EventArgs eventArgs) {
        try {
            eventListener4.onEvent(event4, eventArgs);
        }
        catch (Db4oException db4oException) {
            throw db4oException;
        }
        catch (Throwable throwable) {
            throw new ReflectException(throwable);
        }
    }

    private void validateListener(EventListener4 eventListener4) {
        if (null == eventListener4) {
            throw new ArgumentNullException();
        }
    }

    public boolean hasListeners() {
        return this._listeners != null;
    }
}

