/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DeleteInfo;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionalReferenceSystem;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.messages.Msg;
import com.db4o.internal.cs.messages.MsgD;

final class ClientTransaction
extends Transaction {
    private final ClientObjectContainer i_client;
    protected Tree i_yapObjectsToGc;

    ClientTransaction(ClientObjectContainer clientObjectContainer, Transaction transaction, TransactionalReferenceSystem transactionalReferenceSystem) {
        super(clientObjectContainer, transaction, transactionalReferenceSystem);
        this.i_client = clientObjectContainer;
    }

    public void commit() {
        this.commitTransactionListeners();
        this.clearAll();
        if (this.isSystemTransaction()) {
            this.i_client.write(Msg.COMMIT_SYSTEMTRANS);
        } else {
            this.i_client.write(Msg.COMMIT);
            this.i_client.expectedResponse(Msg.OK);
        }
    }

    protected void clear() {
        this.removeYapObjectReferences();
    }

    private void removeYapObjectReferences() {
        if (this.i_yapObjectsToGc != null) {
            this.i_yapObjectsToGc.traverse(new Visitor4(){

                public void visit(Object object) {
                    ObjectReference objectReference = (ObjectReference)((TreeIntObject)object)._object;
                    ClientTransaction.this.removeReference(objectReference);
                }
            });
        }
        this.i_yapObjectsToGc = null;
    }

    public boolean delete(ObjectReference objectReference, int n, int n2) {
        if (!super.delete(objectReference, n, n2)) {
            return false;
        }
        MsgD msgD = Msg.TA_DELETE.getWriterForInts(this, new int[]{n, n2});
        this.i_client.writeBatchedMessage(msgD);
        return true;
    }

    public boolean isDeleted(int n) {
        MsgD msgD = Msg.TA_IS_DELETED.getWriterForInt(this, n);
        this.i_client.write(msgD);
        int n2 = this.i_client.expectedByteResponse(Msg.TA_IS_DELETED).readInt();
        return n2 == 1;
    }

    public final HardObjectReference getHardReferenceBySignature(long l, byte[] byArray) {
        int n = 12 + byArray.length;
        MsgD msgD = Msg.OBJECT_BY_UUID.getWriterForLength(this, n);
        msgD.writeLong(l);
        msgD.writeBytes(byArray);
        this.i_client.write(msgD);
        msgD = (MsgD)this.i_client.expectedResponse(Msg.OBJECT_BY_UUID);
        int n2 = msgD.readInt();
        if (n2 > 0) {
            return this.container().getHardObjectReferenceById(this, n2);
        }
        return HardObjectReference.INVALID;
    }

    public void processDeletes() {
        if (this._delete != null) {
            this._delete.traverse(new Visitor4(){

                public void visit(Object object) {
                    DeleteInfo deleteInfo = (DeleteInfo)object;
                    if (deleteInfo._reference != null) {
                        ClientTransaction.this.i_yapObjectsToGc = Tree.add(ClientTransaction.this.i_yapObjectsToGc, new TreeIntObject(deleteInfo._key, deleteInfo._reference));
                    }
                }
            });
        }
        this._delete = null;
        this.i_client.writeBatchedMessage(Msg.PROCESS_DELETES);
    }

    public void rollback() {
        this.i_yapObjectsToGc = null;
        this.rollBackTransactionListeners();
        this.clearAll();
    }

    public void writeUpdateDeleteMembers(int n, ClassMetadata classMetadata, int n2, int n3) {
        MsgD msgD = Msg.WRITE_UPDATE_DELETE_MEMBERS.getWriterForInts(this, new int[]{n, classMetadata.getID(), n2, n3});
        this.i_client.writeBatchedMessage(msgD);
    }
}

