/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.foundation.Hashtable4;
import com.db4o.internal.cs.ClassInfo;
import com.db4o.internal.cs.FieldInfo;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.GenericClass;
import com.db4o.reflect.generic.GenericField;
import com.db4o.reflect.generic.GenericReflector;

public class ClassInfoHelper {
    private Hashtable4 _classMetaTable = new Hashtable4();
    private Hashtable4 _genericClassTable = new Hashtable4();

    public ClassInfo getClassMeta(ReflectClass reflectClass) {
        String string = reflectClass.getName();
        if (ClassInfoHelper.isSystemClass(string)) {
            return ClassInfo.newSystemClass(string);
        }
        ClassInfo classInfo = this.lookupClassMeta(string);
        if (classInfo != null) {
            return classInfo;
        }
        return this.newUserClassMeta(reflectClass);
    }

    private ClassInfo newUserClassMeta(ReflectClass reflectClass) {
        ClassInfo classInfo = ClassInfo.newUserClass(reflectClass.getName());
        classInfo.setSuperClass(this.mapSuperclass(reflectClass));
        this.registerClassMeta(reflectClass.getName(), classInfo);
        classInfo.setFields(this.mapFields(reflectClass.getDeclaredFields()));
        return classInfo;
    }

    private ClassInfo mapSuperclass(ReflectClass reflectClass) {
        ReflectClass reflectClass2 = reflectClass.getSuperclass();
        if (reflectClass2 != null) {
            return this.getClassMeta(reflectClass2);
        }
        return null;
    }

    private FieldInfo[] mapFields(ReflectField[] reflectFieldArray) {
        FieldInfo[] fieldInfoArray = new FieldInfo[reflectFieldArray.length];
        for (int i = 0; i < reflectFieldArray.length; ++i) {
            ReflectField reflectField = reflectFieldArray[i];
            boolean bl = reflectField.getFieldType().isArray();
            ReflectClass reflectClass = bl ? reflectField.getFieldType().getComponentType() : reflectField.getFieldType();
            boolean bl2 = reflectClass.isPrimitive();
            fieldInfoArray[i] = new FieldInfo(reflectField.getName(), this.getClassMeta(reflectClass), bl2, bl, false);
        }
        return fieldInfoArray;
    }

    private static boolean isSystemClass(String string) {
        return string.startsWith("java");
    }

    private ClassInfo lookupClassMeta(String string) {
        return (ClassInfo)this._classMetaTable.get(string);
    }

    private void registerClassMeta(String string, ClassInfo classInfo) {
        this._classMetaTable.put(string, (Object)classInfo);
    }

    public GenericClass classMetaToGenericClass(GenericReflector genericReflector, ClassInfo classInfo) {
        if (classInfo.isSystemClass()) {
            return (GenericClass)genericReflector.forName(classInfo.getClassName());
        }
        String string = classInfo.getClassName();
        GenericClass genericClass = this.lookupGenericClass(string);
        if (genericClass != null) {
            return genericClass;
        }
        ReflectClass reflectClass = genericReflector.forName(string);
        if (reflectClass != null) {
            return (GenericClass)reflectClass;
        }
        GenericClass genericClass2 = null;
        ClassInfo classInfo2 = classInfo.getSuperClass();
        if (classInfo2 != null) {
            genericClass2 = this.classMetaToGenericClass(genericReflector, classInfo2);
        }
        genericClass = new GenericClass(genericReflector, null, string, genericClass2);
        this.registerGenericClass(string, genericClass);
        FieldInfo[] fieldInfoArray = classInfo.getFields();
        GenericField[] genericFieldArray = new GenericField[fieldInfoArray.length];
        for (int i = 0; i < fieldInfoArray.length; ++i) {
            ClassInfo classInfo3 = fieldInfoArray[i].getFieldClass();
            String string2 = fieldInfoArray[i].getFieldName();
            GenericClass genericClass3 = this.classMetaToGenericClass(genericReflector, classInfo3);
            genericFieldArray[i] = new GenericField(string2, genericClass3, fieldInfoArray[i]._isPrimitive);
        }
        genericClass.initFields(genericFieldArray);
        return genericClass;
    }

    private GenericClass lookupGenericClass(String string) {
        return (GenericClass)this._genericClassTable.get(string);
    }

    private void registerGenericClass(String string, GenericClass genericClass) {
        this._genericClassTable.put(string, (Object)genericClass);
        ((GenericReflector)genericClass.reflector()).register(genericClass);
    }
}

