/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ReplicationImpl;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.TreeNodeIterator;
import com.db4o.internal.BlobImpl;
import com.db4o.internal.Buffer;
import com.db4o.internal.BuiltinTypeHandler;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Const4;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.HandlerVersionKey;
import com.db4o.internal.Handlers4;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.PrimitiveFieldHandler;
import com.db4o.internal.SharedIndexedFields;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.UntypedFieldHandler;
import com.db4o.internal.UntypedFieldHandler0;
import com.db4o.internal.VirtualFieldMetadata;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.handlers.ArrayHandler;
import com.db4o.internal.handlers.ArrayHandler0;
import com.db4o.internal.handlers.BooleanHandler;
import com.db4o.internal.handlers.ByteHandler;
import com.db4o.internal.handlers.CharHandler;
import com.db4o.internal.handlers.DateHandler;
import com.db4o.internal.handlers.DateHandler0;
import com.db4o.internal.handlers.DoubleHandler;
import com.db4o.internal.handlers.DoubleHandler0;
import com.db4o.internal.handlers.FloatHandler;
import com.db4o.internal.handlers.FloatHandler0;
import com.db4o.internal.handlers.IntHandler;
import com.db4o.internal.handlers.IntHandler0;
import com.db4o.internal.handlers.LongHandler;
import com.db4o.internal.handlers.LongHandler0;
import com.db4o.internal.handlers.MultidimensionalArrayHandler;
import com.db4o.internal.handlers.MultidimensionalArrayHandler0;
import com.db4o.internal.handlers.NetTypeHandler;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.handlers.ShortHandler;
import com.db4o.internal.handlers.ShortHandler0;
import com.db4o.internal.handlers.StringHandler;
import com.db4o.internal.handlers.StringHandler0;
import com.db4o.internal.handlers.StringHandler2;
import com.db4o.internal.handlers.VariableLengthTypeHandler;
import com.db4o.internal.replication.Db4oReplicationReferenceProvider;
import com.db4o.internal.replication.MigrationConnection;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectConstructor;
import com.db4o.reflect.generic.GenericConverter;
import com.db4o.reflect.generic.GenericReflector;

public final class HandlerRegistry {
    private final ObjectContainerBase _container;
    private static final Db4oTypeImpl[] _db4oTypes = new Db4oTypeImpl[]{new BlobImpl()};
    private ClassMetadata i_anyArray;
    private ClassMetadata i_anyArrayN;
    public StringHandler _stringHandler;
    private Hashtable4 _handlers = new Hashtable4(16);
    private Hashtable4 _classes = new Hashtable4(16);
    private Hashtable4 _classMetadata = new Hashtable4(16);
    private Hashtable4 _ids = new Hashtable4(16);
    private int _highestBuiltinTypeID = 14;
    private static final int PRIMITIVECOUNT = 8;
    public static final int ANY_ID = 11;
    private final VirtualFieldMetadata[] _virtualFields = new VirtualFieldMetadata[2];
    private final Hashtable4 _mapReflectorToHandler = new Hashtable4(32);
    private final Hashtable4 _mapHandlerToReflector = new Hashtable4(32);
    private SharedIndexedFields _indexes;
    ReplicationImpl i_replication;
    MigrationConnection i_migration;
    Db4oReplicationReferenceProvider _replicationReferenceProvider;
    public final DiagnosticProcessor _diagnosticProcessor;
    public boolean i_encrypt;
    byte[] i_encryptor;
    int i_lastEncryptorByte;
    final GenericReflector _reflector;
    private final Hashtable4 _handlerVersions = new Hashtable4(16);
    private LatinStringIO _stringIO;
    public ReflectClass ICLASS_COMPARE;
    ReflectClass ICLASS_DB4OTYPE;
    ReflectClass ICLASS_DB4OTYPEIMPL;
    public ReflectClass ICLASS_INTERNAL;
    ReflectClass ICLASS_UNVERSIONED;
    public ReflectClass ICLASS_OBJECT;
    ReflectClass ICLASS_OBJECTCONTAINER;
    public ReflectClass ICLASS_STATICCLASS;
    public ReflectClass ICLASS_STRING;
    ReflectClass ICLASS_TRANSIENTCLASS;

    HandlerRegistry(ObjectContainerBase objectContainerBase, byte by, GenericReflector genericReflector) {
        this._stringIO = LatinStringIO.forEncoding(by);
        this._container = objectContainerBase;
        objectContainerBase._handlers = this;
        this._reflector = genericReflector;
        this._diagnosticProcessor = objectContainerBase.configImpl().diagnosticProcessor();
        this.initClassReflectors(genericReflector);
        this._indexes = new SharedIndexedFields(objectContainerBase);
        this._virtualFields[0] = this._indexes._version;
        this._virtualFields[1] = this._indexes._uUID;
        this.registerBuiltinHandlers();
        this.registerPlatformTypes();
        this.initArrayHandlers();
    }

    private void initArrayHandlers() {
        UntypedFieldHandler untypedFieldHandler = this.untypedHandler();
        ReflectClass reflectClass = untypedFieldHandler.classReflector();
        this.i_anyArray = new PrimitiveFieldHandler(this._container, new ArrayHandler(this._container, untypedFieldHandler, false), 12, reflectClass);
        this._classMetadata.put(12, (Object)this.i_anyArray);
        this.i_anyArrayN = new PrimitiveFieldHandler(this._container, new MultidimensionalArrayHandler(this._container, untypedFieldHandler, false), 13, reflectClass);
        this._classMetadata.put(13, (Object)this.i_anyArrayN);
    }

    private void registerPlatformTypes() {
        NetTypeHandler[] netTypeHandlerArray = Platform4.types(this._container);
        for (int i = 0; i < netTypeHandlerArray.length; ++i) {
            this.registerNetTypeHandler(netTypeHandlerArray[i]);
        }
    }

    public void registerNetTypeHandler(NetTypeHandler netTypeHandler) {
        netTypeHandler.initialize();
        GenericConverter genericConverter = netTypeHandler instanceof GenericConverter ? (GenericConverter)((Object)netTypeHandler) : null;
        this.registerBuiltinHandler(netTypeHandler.getID(), netTypeHandler, true, netTypeHandler.getName(), genericConverter);
    }

    private void registerBuiltinHandlers() {
        IntHandler intHandler = new IntHandler(this._container);
        this.registerBuiltinHandler(1, intHandler);
        this.registerHandlerVersion(intHandler, 0, new IntHandler0(this._container));
        LongHandler longHandler = new LongHandler(this._container);
        this.registerBuiltinHandler(2, longHandler);
        this.registerHandlerVersion(longHandler, 0, new LongHandler0(this._container));
        FloatHandler floatHandler = new FloatHandler(this._container);
        this.registerBuiltinHandler(3, floatHandler);
        this.registerHandlerVersion(floatHandler, 0, new FloatHandler0(this._container));
        BooleanHandler booleanHandler = new BooleanHandler(this._container);
        this.registerBuiltinHandler(4, booleanHandler);
        DoubleHandler doubleHandler = new DoubleHandler(this._container);
        this.registerBuiltinHandler(5, doubleHandler);
        this.registerHandlerVersion(doubleHandler, 0, new DoubleHandler0(this._container));
        ByteHandler byteHandler = new ByteHandler(this._container);
        this.registerBuiltinHandler(6, byteHandler);
        CharHandler charHandler = new CharHandler(this._container);
        this.registerBuiltinHandler(7, charHandler);
        ShortHandler shortHandler = new ShortHandler(this._container);
        this.registerBuiltinHandler(8, shortHandler);
        this.registerHandlerVersion(shortHandler, 0, new ShortHandler0(this._container));
        this._stringHandler = new StringHandler2(this._container);
        this.registerBuiltinHandler(9, this._stringHandler);
        this.registerHandlerVersion(this._stringHandler, 0, new StringHandler0(this._stringHandler));
        DateHandler dateHandler = new DateHandler(this._container);
        this.registerBuiltinHandler(10, dateHandler);
        this.registerHandlerVersion(dateHandler, 0, new DateHandler0(this._container));
        UntypedFieldHandler untypedFieldHandler = new UntypedFieldHandler(this._container);
        this.registerBuiltinHandler(11, untypedFieldHandler, false, null, null);
        this.registerHandlerVersion(untypedFieldHandler, 0, new UntypedFieldHandler0(this._container));
    }

    private void registerBuiltinHandler(int n, BuiltinTypeHandler builtinTypeHandler) {
        this.registerBuiltinHandler(n, builtinTypeHandler, true, builtinTypeHandler.classReflector().getName(), null);
    }

    private void registerBuiltinHandler(int n, BuiltinTypeHandler builtinTypeHandler, boolean bl, String string, GenericConverter genericConverter) {
        PrimitiveHandler primitiveHandler;
        ReflectClass reflectClass;
        if (bl) {
            this._reflector.registerPrimitiveClass(n, string, genericConverter);
        }
        ReflectClass reflectClass2 = builtinTypeHandler.classReflector();
        this._handlers.put(n, (Object)builtinTypeHandler);
        this._classes.put(n, (Object)reflectClass2);
        PrimitiveFieldHandler primitiveFieldHandler = new PrimitiveFieldHandler(this._container, builtinTypeHandler, n, reflectClass2);
        this._classMetadata.put(n, (Object)primitiveFieldHandler);
        this.map(n, primitiveFieldHandler, reflectClass2);
        if (builtinTypeHandler instanceof PrimitiveHandler && (reflectClass = (primitiveHandler = (PrimitiveHandler)builtinTypeHandler).primitiveClassReflector()) != null) {
            this.map(0, primitiveFieldHandler, reflectClass);
        }
        if (n > this._highestBuiltinTypeID) {
            this._highestBuiltinTypeID = n;
        }
    }

    private void map(int n, TypeHandler4 typeHandler4, ReflectClass reflectClass) {
        this._mapReflectorToHandler.put(reflectClass, (Object)typeHandler4);
        this._mapHandlerToReflector.put(typeHandler4, (Object)reflectClass);
        if (n != 0) {
            this._ids.put(typeHandler4, (Object)new Integer(n));
        }
    }

    private void registerHandlerVersion(TypeHandler4 typeHandler4, int n, TypeHandler4 typeHandler42) {
        this._handlerVersions.put(new HandlerVersionKey(typeHandler4, n), (Object)typeHandler42);
    }

    public TypeHandler4 correctHandlerVersion(TypeHandler4 typeHandler4, int n) {
        TypeHandler4 typeHandler42 = (TypeHandler4)this._handlerVersions.get(new HandlerVersionKey(typeHandler4, n));
        if (typeHandler42 != null) {
            return typeHandler42;
        }
        if (typeHandler4 instanceof MultidimensionalArrayHandler && n == 0) {
            return new MultidimensionalArrayHandler0(typeHandler4);
        }
        if (typeHandler4 instanceof ArrayHandler && n == 0) {
            return new ArrayHandler0(typeHandler4);
        }
        return typeHandler4;
    }

    int arrayType(Object object) {
        ReflectClass reflectClass = this._container.reflector().forObject(object);
        return this.arrayType(reflectClass);
    }

    int arrayType(ReflectClass reflectClass) {
        if (!reflectClass.isArray()) {
            return 0;
        }
        if (this._container.reflector().array().isNDimensional(reflectClass)) {
            return 4;
        }
        return 3;
    }

    boolean createConstructor(ReflectClass reflectClass, boolean bl) {
        if (reflectClass == null) {
            return false;
        }
        if (reflectClass.isAbstract() || reflectClass.isInterface()) {
            return true;
        }
        if (!Platform4.callConstructor() && reflectClass.skipConstructor(bl, this._container.config().testConstructors())) {
            return true;
        }
        if (!this._container.configImpl().testConstructors()) {
            return true;
        }
        if (reflectClass.newInstance() != null) {
            return true;
        }
        if (this._container.reflector().constructorCallsSupported()) {
            Tree tree = this.sortConstructorsByParamsCount(reflectClass);
            return this.findConstructor(reflectClass, tree);
        }
        return false;
    }

    private boolean findConstructor(ReflectClass reflectClass, Tree tree) {
        if (tree == null) {
            return false;
        }
        TreeNodeIterator treeNodeIterator = new TreeNodeIterator(tree);
        while (treeNodeIterator.moveNext()) {
            Object object = treeNodeIterator.current();
            ReflectConstructor reflectConstructor = (ReflectConstructor)((TreeIntObject)object)._object;
            ReflectClass[] reflectClassArray = reflectConstructor.getParameterTypes();
            Object[] objectArray = new Object[reflectClassArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.nullValue(reflectClassArray[i]);
            }
            Object object2 = reflectConstructor.newInstance(objectArray);
            if (object2 == null) continue;
            reflectClass.useConstructor(reflectConstructor, objectArray);
            return true;
        }
        return false;
    }

    private Object nullValue(ReflectClass reflectClass) {
        for (int i = 1; i <= 8; ++i) {
            PrimitiveHandler primitiveHandler = (PrimitiveHandler)this.handlerForID(i);
            if (!reflectClass.equals(primitiveHandler.primitiveClassReflector())) continue;
            return primitiveHandler.primitiveNull();
        }
        return null;
    }

    private Tree sortConstructorsByParamsCount(ReflectClass reflectClass) {
        ReflectConstructor[] reflectConstructorArray = reflectClass.getDeclaredConstructors();
        Tree tree = null;
        for (int i = 0; i < reflectConstructorArray.length; ++i) {
            reflectConstructorArray[i].setAccessible();
            int n = reflectConstructorArray[i].getParameterTypes().length;
            tree = Tree.add(tree, new TreeIntObject(i + reflectConstructorArray.length * n, reflectConstructorArray[i]));
        }
        return tree;
    }

    public final void decrypt(Buffer buffer) {
        if (this.i_encrypt) {
            int n = this.i_lastEncryptorByte;
            byte[] byArray = buffer._buffer;
            for (int i = buffer.length() - 1; i >= 0; --i) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] + this.i_encryptor[n]);
                if (n == 0) {
                    n = this.i_lastEncryptorByte;
                    continue;
                }
                --n;
            }
        }
    }

    public final void encrypt(Buffer buffer) {
        if (this.i_encrypt) {
            byte[] byArray = buffer._buffer;
            int n = this.i_lastEncryptorByte;
            for (int i = buffer.length() - 1; i >= 0; --i) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] - this.i_encryptor[n]);
                if (n == 0) {
                    n = this.i_lastEncryptorByte;
                    continue;
                }
                --n;
            }
        }
    }

    public void oldEncryptionOff() {
        this.i_encrypt = false;
        this.i_encryptor = null;
        this.i_lastEncryptorByte = 0;
        this._container.configImpl().oldEncryptionOff();
    }

    public final ReflectClass classForID(int n) {
        return (ReflectClass)this._classes.get(n);
    }

    public final TypeHandler4 handlerForID(int n) {
        return (TypeHandler4)this._handlers.get(n);
    }

    public final int handlerID(TypeHandler4 typeHandler4) {
        if (typeHandler4 instanceof ClassMetadata) {
            return ((ClassMetadata)typeHandler4).getID();
        }
        Object object = this._ids.get(typeHandler4);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    public final TypeHandler4 handlerForClass(ObjectContainerBase objectContainerBase, ReflectClass reflectClass) {
        return this.classMetadataForClass(objectContainerBase, reflectClass).typeHandler();
    }

    public final ClassMetadata classMetadataForClass(ObjectContainerBase objectContainerBase, ReflectClass reflectClass) {
        if (reflectClass == null) {
            return null;
        }
        ReflectClass reflectClass2 = Handlers4.baseType(reflectClass);
        ClassMetadata classMetadata = this.classMetadataForClass(reflectClass2);
        if (classMetadata != null) {
            return classMetadata;
        }
        return objectContainerBase.produceClassMetadata(reflectClass2);
    }

    public UntypedFieldHandler untypedHandler() {
        return (UntypedFieldHandler)this.handlerForID(11);
    }

    private void initClassReflectors(GenericReflector genericReflector) {
        this.ICLASS_COMPARE = genericReflector.forClass(Const4.CLASS_COMPARE);
        this.ICLASS_DB4OTYPE = genericReflector.forClass(Const4.CLASS_DB4OTYPE);
        this.ICLASS_DB4OTYPEIMPL = genericReflector.forClass(Const4.CLASS_DB4OTYPEIMPL);
        this.ICLASS_INTERNAL = genericReflector.forClass(Const4.CLASS_INTERNAL);
        this.ICLASS_UNVERSIONED = genericReflector.forClass(Const4.CLASS_UNVERSIONED);
        this.ICLASS_OBJECT = genericReflector.forClass(Const4.CLASS_OBJECT);
        this.ICLASS_OBJECTCONTAINER = genericReflector.forClass(Const4.CLASS_OBJECTCONTAINER);
        this.ICLASS_STATICCLASS = genericReflector.forClass(Const4.CLASS_STATICCLASS);
        this.ICLASS_STRING = genericReflector.forClass(String.class);
        this.ICLASS_TRANSIENTCLASS = genericReflector.forClass(Const4.CLASS_TRANSIENTCLASS);
        Platform4.registerCollections(genericReflector);
    }

    void initEncryption(Config4Impl config4Impl) {
        if (config4Impl.encrypt() && config4Impl.password() != null && config4Impl.password().length() > 0) {
            this.i_encrypt = true;
            this.i_encryptor = new byte[config4Impl.password().length()];
            for (int i = 0; i < this.i_encryptor.length; ++i) {
                this.i_encryptor[i] = (byte)(config4Impl.password().charAt(i) & 0xFF);
            }
            this.i_lastEncryptorByte = config4Impl.password().length() - 1;
            return;
        }
        this.oldEncryptionOff();
    }

    static Db4oTypeImpl getDb4oType(ReflectClass reflectClass) {
        for (int i = 0; i < _db4oTypes.length; ++i) {
            if (!reflectClass.isInstance(_db4oTypes[i])) continue;
            return _db4oTypes[i];
        }
        return null;
    }

    public ClassMetadata classMetadataForId(int n) {
        return (ClassMetadata)this._classMetadata.get(n);
    }

    ClassMetadata classMetadataForClass(ReflectClass reflectClass) {
        if (reflectClass == null) {
            return null;
        }
        if (reflectClass.isArray()) {
            if (this._container.reflector().array().isNDimensional(reflectClass)) {
                return this.i_anyArrayN;
            }
            return this.i_anyArray;
        }
        return (ClassMetadata)this._mapReflectorToHandler.get(reflectClass);
    }

    public ReflectClass classReflectorForHandler(TypeHandler4 typeHandler4) {
        return (ReflectClass)this._mapHandlerToReflector.get(typeHandler4);
    }

    public boolean isSecondClass(Object object) {
        ReflectClass reflectClass;
        return object != null && this._mapReflectorToHandler.get(reflectClass = this._container.reflector().forObject(object)) != null;
    }

    public boolean isSystemHandler(int n) {
        return n <= this._highestBuiltinTypeID;
    }

    public void migrationConnection(MigrationConnection migrationConnection) {
        this.i_migration = migrationConnection;
    }

    public MigrationConnection migrationConnection() {
        return this.i_migration;
    }

    public void replication(ReplicationImpl replicationImpl) {
        this.i_replication = replicationImpl;
    }

    public ReplicationImpl replication() {
        return this.i_replication;
    }

    public VirtualFieldMetadata virtualFieldByName(String string) {
        for (int i = 0; i < this._virtualFields.length; ++i) {
            if (!string.equals(this._virtualFields[i].getName())) continue;
            return this._virtualFields[i];
        }
        return null;
    }

    public boolean isVariableLength(TypeHandler4 typeHandler4) {
        return typeHandler4 instanceof VariableLengthTypeHandler;
    }

    public SharedIndexedFields indexes() {
        return this._indexes;
    }

    public LatinStringIO stringIO() {
        return this._stringIO;
    }

    public void stringIO(LatinStringIO latinStringIO) {
        this._stringIO = latinStringIO;
    }
}

