/*
 * Decompiled with CFR 0.152.
 */
package net.bzzt.swift.mt940.exporter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jgnash.imports.ImportBank;
import jgnash.imports.ImportTransaction;
import net.bzzt.swift.mt940.Mt940Entry;
import net.bzzt.swift.mt940.Mt940File;
import net.bzzt.swift.mt940.Mt940Record;

public class Mt940Exporter {
    private Mt940Exporter() {
    }

    public static ImportBank convert(Mt940File file) {
        ImportBank retval = new ImportBank();
        retval.setTransactions(Mt940Exporter.convertTransactions(file));
        return retval;
    }

    static List<ImportTransaction> convertTransactions(Mt940File file) {
        ArrayList<ImportTransaction> retval = new ArrayList<ImportTransaction>();
        for (Mt940Record record : file.getRecords()) {
            for (Mt940Entry entry : record.getEntries()) {
                retval.add(Mt940Exporter.convert(entry));
            }
        }
        return retval;
    }

    private static ImportTransaction convert(Mt940Entry entry) {
        BigDecimal amount;
        String memo = entry.getMehrzweckfeld();
        Date date = entry.getValutaDatum();
        if (entry.getSollHabenKennung() == Mt940Entry.SollHabenKennung.CREDIT) {
            amount = entry.getBetrag();
        } else if (entry.getSollHabenKennung() == Mt940Entry.SollHabenKennung.DEBIT) {
            amount = BigDecimal.valueOf(0L).subtract(entry.getBetrag());
        } else {
            throw new UnsupportedOperationException("SollHabenKennung " + (Object)((Object)entry.getSollHabenKennung()) + " not supported");
        }
        ImportTransaction tran = new ImportTransaction();
        tran.amount = amount;
        tran.datePosted = date;
        tran.memo = memo;
        tran.account = null;
        return tran;
    }
}

