/*
 * Decompiled with CFR 0.152.
 */
package net.bzzt.swift.mt940;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.imports.GenericImport;
import jgnash.imports.ImportBank;
import jgnash.ui.StaticUIMethods;
import jgnash.ui.UIApplication;
import jgnash.ui.actions.AbstractEnabledAction;
import jgnash.ui.wizards.imports.ImportDialog;
import jgnash.util.Resource;
import net.bzzt.swift.mt940.Mt940File;
import net.bzzt.swift.mt940.exporter.Mt940Exporter;
import net.bzzt.swift.mt940.parser.Mt940Parser;

public class ImportMt940Action
extends AbstractEnabledAction {
    private static final long serialVersionUID = 1L;

    public ImportMt940Action() {
        Resource rb = Resource.get();
        this.putValue("Name", rb.getString("Menu.ImportMt940.Name"));
        this.putValue("ShortDescription", rb.getString("Menu.ImportMt940.Tooltip"));
    }

    private static void importMt940() {
        File file;
        Resource rb = Resource.get();
        if (EngineFactory.getEngine((String)"default") == null || EngineFactory.getEngine((String)"default").getRootAccount().getChildCount() == 0) {
            StaticUIMethods.displayError((String)rb.getString("Message.ErrorCreateBasicAccounts"));
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog((Component)UIApplication.getFrame()) == 0 && (file = chooser.getSelectedFile()).exists()) {
            new ImportMt940(file.getAbsolutePath()).execute();
        }
    }

    public void actionPerformed(ActionEvent e) {
        ImportMt940Action.importMt940();
    }

    static final class ImportMt940
    extends SwingWorker<ImportBank, Void> {
        private String fileName;

        protected ImportMt940(String fileName) {
            this.fileName = fileName;
        }

        @Override
        protected ImportBank doInBackground() throws Exception {
            Mt940Parser parser = new Mt940Parser();
            Mt940File parsedFile = parser.parse(new LineNumberReader(new InputStreamReader(new FileInputStream(this.fileName))));
            return Mt940Exporter.convert(parsedFile);
        }

        @Override
        protected void done() {
            try {
                ImportDialog d = new ImportDialog();
                ImportBank bank = (ImportBank)this.get();
                d.setSetting((Enum)ImportDialog.Settings.BANK, (Object)bank);
                d.setVisible(true);
                if (d.isWizardValid()) {
                    Account account = (Account)d.getSetting((Enum)ImportDialog.Settings.ACCOUNT);
                    List transactions = (List)d.getSetting((Enum)ImportDialog.Settings.TRANSACTIONS);
                    GenericImport.importTransactions((List)transactions, (Account)account);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

