/*
 * Decompiled with CFR 0.152.
 */
package jgnash.text;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import jgnash.engine.CommodityNode;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;

public abstract class CommodityFormat {
    private static final CommodityListener listener;
    private static CommodityFormat fullFormat;
    private static Map<CommodityNode, DecimalFormat> fullInstanceMap;
    private static Map<CommodityNode, DecimalFormat> simpleInstanceMap;
    private static String[] ESCAPE_CHARS;
    private static final boolean DEBUG = false;
    private static final Pattern CURRENCY_SIGN_PATTERN;

    public static String getShortNumberPattern(CommodityNode node) {
        DecimalFormat format = (DecimalFormat)CommodityFormat.getShortNumberFormat(node);
        String pattern = format.toPattern();
        return CURRENCY_SIGN_PATTERN.matcher(pattern).replaceAll("");
    }

    public static String getFullNumberPattern(CommodityNode node) {
        DecimalFormat format = (DecimalFormat)CommodityFormat.getFullNumberFormat(node);
        String pattern = format.toPattern();
        if (pattern.startsWith("\u00a4")) {
            String prefix = node.getPrefix();
            for (String escapeChar : ESCAPE_CHARS) {
                if (!prefix.contains(escapeChar)) continue;
                prefix = prefix.replace(escapeChar, "'" + escapeChar + "'");
            }
            return pattern.replace("\u00a4", prefix);
        }
        String suffix = node.getSuffix();
        for (String escapeChar : ESCAPE_CHARS) {
            if (!suffix.contains(escapeChar)) continue;
            suffix = suffix.replace(escapeChar, "'" + escapeChar + "'");
        }
        return pattern.replace("\u00a4", suffix);
    }

    public static NumberFormat getShortNumberFormat(CommodityNode node) {
        DecimalFormat o = simpleInstanceMap.get(node);
        if (o != null) {
            return o;
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getCurrencyInstance();
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setCurrencySymbol("");
        df.setDecimalFormatSymbols(dfs);
        df.setMaximumFractionDigits(node.getScale());
        df.setMinimumFractionDigits(df.getMaximumFractionDigits());
        int negSufLen = df.getNegativeSuffix().length();
        if (negSufLen > 0) {
            char[] pad = new char[negSufLen];
            for (int i = 0; i < negSufLen; ++i) {
                pad[i] = 32;
            }
            df.setPositiveSuffix(new String(pad));
        }
        simpleInstanceMap.put(node, df);
        return df;
    }

    public static NumberFormat getFullNumberFormat(CommodityNode node) {
        int posSufLen;
        int negSufLen;
        assert (node != null);
        DecimalFormat o = fullInstanceMap.get(node);
        if (o != null) {
            return o;
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getCurrencyInstance();
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setCurrencySymbol(node.getPrefix());
        df.setDecimalFormatSymbols(dfs);
        df.setMaximumFractionDigits(node.getScale());
        df.setMinimumFractionDigits(df.getMaximumFractionDigits());
        if (node.getSuffix() != null && node.getSuffix().length() > 0) {
            df.setPositiveSuffix(node.getSuffix() + df.getPositiveSuffix());
            df.setNegativeSuffix(node.getSuffix() + df.getNegativeSuffix());
        }
        if ((negSufLen = df.getNegativeSuffix().length()) > (posSufLen = df.getPositiveSuffix().length())) {
            StringBuilder buf = new StringBuilder(df.getPositiveSuffix());
            for (int i = negSufLen - posSufLen; i <= negSufLen; ++i) {
                buf.append(' ');
            }
            df.setPositiveSuffix(buf.toString());
        } else if (posSufLen > negSufLen) {
            StringBuilder buf = new StringBuilder(df.getNegativeSuffix());
            for (int i = posSufLen - negSufLen; i <= posSufLen; ++i) {
                buf.append(' ');
            }
            df.setNegativeSuffix(buf.toString());
        }
        fullInstanceMap.put(node, df);
        return df;
    }

    public static synchronized CommodityFormat getFullFormat() {
        if (fullFormat != null) {
            return fullFormat;
        }
        fullFormat = new FullFormat();
        return fullFormat;
    }

    private static String getConversion(String cur1, String cur2) {
        return cur1 + " > " + cur2;
    }

    public static String getConversion(CommodityNode cur1, CommodityNode cur2) {
        return CommodityFormat.getConversion(cur1.getSymbol(), cur2.getSymbol());
    }

    public abstract String format(BigDecimal var1, CommodityNode var2);

    static {
        fullInstanceMap = new HashMap<CommodityNode, DecimalFormat>();
        simpleInstanceMap = new HashMap<CommodityNode, DecimalFormat>();
        ESCAPE_CHARS = new String[]{",", ".", "0", "#", "-", ";", "%"};
        CURRENCY_SIGN_PATTERN = Pattern.compile("\u00a4");
        listener = new CommodityListener();
        MessageBus.getInstance().registerListener(listener, MessageChannel.COMMODITY, MessageChannel.SYSTEM);
    }

    private static class CommodityListener
    implements MessageListener {
        private CommodityListener() {
        }

        @Override
        public void messagePosted(Message event) {
            switch (event.getEvent()) {
                case FILE_CLOSING: 
                case CURRENCY_MODIFY: {
                    simpleInstanceMap.clear();
                    fullInstanceMap.clear();
                    break;
                }
            }
        }
    }

    private static class FullFormat
    extends CommodityFormat {
        private FullFormat() {
        }

        @Override
        public String format(BigDecimal value, CommodityNode node) {
            if (value != null && node != null) {
                return FullFormat.getFullNumberFormat(node).format(value.doubleValue());
            }
            return null;
        }
    }
}

