/*
 * Decompiled with CFR 0.152.
 */
package jgnash.net.currency;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jgnash.net.ConnectionFactory;
import jgnash.net.currency.CurrencyParser;

public class YahooParser
implements CurrencyParser {
    private static final Pattern COMMA_DELIMITER_PATTERN = Pattern.compile(",");
    private BigDecimal result = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean parse(String source, String target) {
        String label = source + target;
        StringBuilder url = new StringBuilder("http://finance.yahoo.com/d/quotes.csv?s=");
        url.append(label);
        url.append("=X&f=sl1d1t1ba&e=.csv");
        BufferedReader in = null;
        try {
            URLConnection connection = ConnectionFactory.getConnection(url.toString());
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String l = in.readLine();
            String[] fields = COMMA_DELIMITER_PATTERN.split(l);
            if (!"\"N/A\"".equals(fields[2])) {
                this.result = new BigDecimal(fields[1]);
            }
        }
        catch (SocketTimeoutException e) {
            this.result = null;
            Logger.getLogger(YahooParser.class.getName()).warning(e.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        catch (UnknownHostException e) {
            this.result = null;
            Logger.getLogger(YahooParser.class.getName()).warning("Unknown host");
        }
        catch (Exception e) {
            Logger.getLogger(YahooParser.class.getName()).severe(e.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(YahooParser.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return true;
    }

    @Override
    public synchronized BigDecimal getConversion() {
        return this.result;
    }
}

