/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.xstream;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import jgnash.engine.Config;
import jgnash.engine.DataStore;
import jgnash.engine.Engine;
import jgnash.engine.StoredObject;
import jgnash.engine.xstream.XMLContainer;
import jgnash.engine.xstream.XStreamEngineDAO;
import jgnash.util.Resource;

public class XMLDataStore
implements DataStore {
    private static final Logger logger = Logger.getLogger(XMLDataStore.class.getName());
    private static final String FILE_EXT = "xml";
    private XMLContainer container;

    @Override
    public void closeEngine() {
        this.container.commit();
        this.container.close();
        this.container = null;
    }

    @Override
    public Engine getLocalEngine(String fileName, String engineName) {
        File file = new File(fileName);
        this.container = new XMLContainer(file);
        if (file.exists()) {
            this.container.readXML();
        }
        Engine engine = new Engine(new XStreamEngineDAO(this.container), engineName);
        logger.info("Created local XML container and engine");
        return engine;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public final String getFileExt() {
        return FILE_EXT;
    }

    @Override
    public final String getFileName() {
        return this.container.getFileName();
    }

    @Override
    public Engine getClientEngine(String host, int port, String user, String password, String engineName) {
        throw new UnsupportedOperationException("Client / Server operation not supported for this type.");
    }

    public String toString() {
        return Resource.get().getString("DataStoreType.XML");
    }

    @Override
    public void saveAs(File file, Collection<StoredObject> objects) {
        XMLContainer.writeXML(objects, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getFileVersion(File file) {
        float fileVersion = 0.0f;
        if (file.exists()) {
            try (XMLContainer container = new XMLContainer(file);){
                container.readXML();
                List<Config> list = container.query(Config.class);
                if (list.size() == 1) {
                    fileVersion = list.get(0).getFileVersion();
                } else {
                    Logger.getLogger(XMLDataStore.class.getName()).severe("Invalid file");
                }
            }
        }
        return fileVersion;
    }
}

