/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.db4o;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jgnash.engine.budget.Budget;
import jgnash.engine.dao.BudgetDAO;
import jgnash.engine.db4o.AbstractDb4oDAO;

public class Db4oBudgetDAO
extends AbstractDb4oDAO
implements BudgetDAO {
    private static final Logger logger = Logger.getLogger(Db4oBudgetDAO.class.getName());

    Db4oBudgetDAO(ObjectContainer container, boolean isRemote) {
        super(container, isRemote);
    }

    @Override
    public boolean add(Budget budget) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", SEMAPHORE_WAIT_TIME)) {
            this.container.set((Object)budget);
            this.commit();
            result = true;
            this.container.ext().releaseSemaphore("Lock");
        } else {
            logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public boolean update(Budget budget) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", SEMAPHORE_WAIT_TIME)) {
            this.container.set((Object)budget);
            this.commit();
            result = true;
            this.container.ext().releaseSemaphore("Lock");
        } else {
            logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public List<Budget> getBudgets() {
        ObjectSet list = Collections.emptyList();
        ArrayList<Budget> resultList = new ArrayList<Budget>();
        if (this.container.ext().setSemaphore("Lock", SEMAPHORE_WAIT_TIME)) {
            list = this.container.query(Budget.class);
            this.container.ext().releaseSemaphore("Lock");
        } else {
            logger.severe("Could not obtain global semaphore");
        }
        for (Budget budget : list) {
            if (budget.isMarkedForRemoval()) continue;
            resultList.add(budget);
        }
        return resultList;
    }

    @Override
    public void refreshBudget(Budget budget) {
        if (this.container.ext().setSemaphore("Lock", SEMAPHORE_WAIT_TIME)) {
            this.container.ext().refresh((Object)budget, 4);
        } else {
            logger.severe("Could not obtain global semaphore");
        }
    }
}

