/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.budget;

import java.text.MessageFormat;
import java.util.Date;
import jgnash.engine.budget.BudgetPeriod;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public class BudgetPeriodDescriptor {
    private transient int hash = 0;
    private static final int ONE_WEEK_INCREMENT = 6;
    private static final int TWO_WEEK_INCREMENT = 13;
    private static final int LEAP_WEEK = 53;
    private int startPeriod;
    private int endPeriod;
    private Date startDate;
    private Date endDate;
    private String periodDescription;
    private BudgetPeriod budgetPeriod;
    private int budgetYear;

    BudgetPeriodDescriptor(int budgetYear, BudgetPeriod budgetPeriod, int startPeriod) {
        if (budgetPeriod == null) {
            throw new IllegalArgumentException("BudgetPeriod may not be null");
        }
        this.budgetYear = budgetYear;
        this.budgetPeriod = budgetPeriod;
        this.startPeriod = startPeriod;
        this.startDate = DateUtils.getDateOfTheYear(budgetYear, startPeriod + 1);
        switch (budgetPeriod) {
            case DAILY: {
                this.endDate = this.startDate;
                this.endPeriod = startPeriod;
                this.periodDescription = MessageFormat.format(Resource.get().getString("Pattern.NumericDate"), this.startDate);
                break;
            }
            case WEEKLY: {
                this.endDate = DateUtils.addDays(this.startDate, 6);
                this.endPeriod = startPeriod + 6;
                this.periodDescription = MessageFormat.format(Resource.get().getString("Pattern.WeekOfYear"), DateUtils.getWeekOfTheYear(this.startDate), budgetYear);
                break;
            }
            case BI_WEEKLY: {
                if (DateUtils.getWeekOfTheYear(this.startDate) != 53) {
                    this.endDate = DateUtils.addDays(this.startDate, 13);
                    this.endPeriod = startPeriod + 13;
                } else {
                    this.endDate = DateUtils.addDays(this.startDate, 6);
                    this.endPeriod = startPeriod + 6;
                }
                this.periodDescription = MessageFormat.format(Resource.get().getString("Pattern.DateRangeShort"), this.startDate, this.endDate);
                break;
            }
            case MONTHLY: {
                int days = DateUtils.getDaysInMonth(this.startDate);
                this.endDate = DateUtils.getLastDayOfTheMonth(this.startDate);
                this.endPeriod = startPeriod + days - 1;
                this.periodDescription = MessageFormat.format(Resource.get().getString("Pattern.MonthOfYear"), this.startDate);
                break;
            }
            case QUARTERLY: {
                this.endDate = DateUtils.getLastDayOfTheQuarter(this.startDate);
                this.endPeriod = startPeriod + DateUtils.getDifferenceInDays(this.startDate, this.endDate);
                this.periodDescription = MessageFormat.format(Resource.get().getString("Pattern.QuarterOfYear"), DateUtils.getQuarterNumber(this.startDate), budgetYear);
                break;
            }
            case YEARLY: {
                this.endDate = DateUtils.getLastDayOfTheYear(this.startDate);
                this.endPeriod = startPeriod + DateUtils.getDifferenceInDays(this.startDate, this.endDate);
                this.periodDescription = Integer.toString(budgetYear);
                break;
            }
            default: {
                this.endPeriod = startPeriod;
                this.endDate = new Date();
                this.periodDescription = "";
            }
        }
    }

    public int getStartPeriod() {
        return this.startPeriod;
    }

    public int getEndPeriod() {
        return this.endPeriod;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getPeriodDescription() {
        return this.periodDescription;
    }

    public BudgetPeriod getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public boolean isBetween(Date date) {
        boolean result = false;
        if (DateUtils.after(date, this.startDate) && DateUtils.before(date, this.endDate)) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return String.format("BudgetPeriodDescriptor [startDate=%tD, endDate=%tD, periodDescription=%s, budgetPeriod=%s]", new Object[]{this.startDate, this.endDate, this.periodDescription, this.budgetPeriod});
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int prime = 31;
            h = 1;
            h = 31 * h + this.budgetPeriod.hashCode();
            h = 31 * h + this.budgetYear;
            this.hash = h = 31 * h + this.startPeriod;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BudgetPeriodDescriptor other = (BudgetPeriodDescriptor)obj;
        return this.budgetPeriod == other.budgetPeriod && this.budgetYear == other.budgetYear && this.startPeriod == other.startPeriod;
    }

    public static String encodeToString(BudgetPeriodDescriptor descriptor) {
        return String.format("%d,%s,%d", descriptor.budgetYear, descriptor.budgetPeriod.name(), descriptor.startPeriod);
    }

    public static BudgetPeriodDescriptor decodeFromString(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("parameter may not be null");
        }
        String[] p = string.split(",");
        if (p.length != 3) {
            throw new IllegalArgumentException("poorly formatted parameter");
        }
        int budgetYear = Integer.parseInt(p[0]);
        BudgetPeriod budgetPeriod = Enum.valueOf(BudgetPeriod.class, p[1]);
        int startPeriod = Integer.parseInt(p[2]);
        return new BudgetPeriodDescriptor(budgetYear, budgetPeriod, startPeriod);
    }
}

