/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.budget;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.budget.Budget;
import jgnash.engine.budget.BudgetGoal;
import jgnash.engine.budget.BudgetPeriod;
import jgnash.engine.budget.BudgetPeriodDescriptor;
import jgnash.engine.budget.BudgetPeriodDescriptorFactory;
import jgnash.engine.budget.Pattern;
import jgnash.util.DateUtils;

public class BudgetFactory {
    private BudgetFactory() {
    }

    public static Budget buildAverageBudget(BudgetPeriod budgetPeriod, String name, boolean round) {
        Budget budget = new Budget();
        budget.setName(name);
        budget.setBudgetPeriod(budgetPeriod);
        int year = DateUtils.getCurrentYear() - 1;
        List<BudgetPeriodDescriptor> descriptors = BudgetPeriodDescriptorFactory.getDescriptors(year, budgetPeriod);
        Engine engine = EngineFactory.getEngine("default");
        ArrayList<Account> accounts = new ArrayList<Account>();
        accounts.addAll(engine.getIncomeAccountList());
        accounts.addAll(engine.getExpenseAccountList());
        for (Account account : accounts) {
            budget.setBudgetGoal(account, BudgetFactory.buildAverageBudgetGoal(account, descriptors, round));
        }
        return budget;
    }

    public static BudgetGoal buildAverageBudgetGoal(Account account, List<BudgetPeriodDescriptor> descriptors, boolean round) {
        BudgetGoal goal = new BudgetGoal();
        goal.setBudgetPeriod(descriptors.get(0).getBudgetPeriod());
        for (BudgetPeriodDescriptor descriptor : descriptors) {
            BigDecimal amount = account.getBalance(descriptor.getStartDate(), descriptor.getEndDate());
            if (account.getAccountType() == AccountType.INCOME) {
                amount = amount.negate();
            }
            if (round) {
                amount = account.getAccountType() == AccountType.INCOME ? amount.setScale(0, RoundingMode.DOWN) : amount.setScale(0, RoundingMode.UP);
            }
            goal.setGoal(descriptor.getStartPeriod(), descriptor.getEndPeriod(), amount);
        }
        return goal;
    }

    public static BudgetGoal buildBudgetGoal(BudgetGoal baseBudgetGoal, Account account, List<BudgetPeriodDescriptor> descriptors, Pattern pattern, int startRow, int endRow, BigDecimal amount) {
        BudgetGoal goal;
        try {
            goal = (BudgetGoal)baseBudgetGoal.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger(BudgetFactory.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
            goal = new BudgetGoal();
        }
        goal.setBudgetPeriod(descriptors.get(0).getBudgetPeriod());
        for (int i = startRow; i <= endRow; i += pattern.getIncrement()) {
            BudgetPeriodDescriptor descriptor = descriptors.get(i);
            goal.setBudgetPeriod(descriptor.getBudgetPeriod());
            if (account.getAccountType() == AccountType.INCOME) {
                goal.setGoal(descriptor.getStartPeriod(), descriptor.getEndPeriod(), amount.negate());
                continue;
            }
            goal.setGoal(descriptor.getStartPeriod(), descriptor.getEndPeriod(), amount);
        }
        return goal;
    }
}

