/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.budget;

import java.util.HashMap;
import java.util.Map;
import jgnash.engine.Account;
import jgnash.engine.StoredObject;
import jgnash.engine.budget.BudgetGoal;
import jgnash.engine.budget.BudgetPeriod;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public class Budget
extends StoredObject
implements Comparable<Budget> {
    private static final long serialVersionUID = 1L;
    private String name = "Default";
    private String description = "";
    private BudgetPeriod budgetPeriod = BudgetPeriod.MONTHLY;
    private Map<String, BudgetGoal> accountGoals = new HashMap<String, BudgetGoal>();
    private boolean assetAccountsIncluded = false;
    private boolean incomeAccountsIncluded = true;
    private boolean expenseAccountsIncluded = true;
    private boolean liabilityAccountsIncluded = false;
    private transient int workingYear = DateUtils.getCurrentYear();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name may not be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name may not be zero length");
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("description may not be null");
        }
        this.description = description;
    }

    public void setBudgetGoal(Account account, BudgetGoal budgetGoal) {
        if (account == null) {
            throw new IllegalArgumentException("Account may not be null");
        }
        if (budgetGoal == null) {
            throw new IllegalArgumentException("Account goals may not be null");
        }
        this.accountGoals.put(account.getUuid(), budgetGoal);
    }

    public void removeBudgetGoal(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("Account may not be null");
        }
        this.accountGoals.remove(account.getUuid());
    }

    public BudgetGoal getBudgetGoal(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("Account may not be null");
        }
        BudgetGoal goal = this.accountGoals.get(account.getUuid());
        if (goal == null) {
            goal = new BudgetGoal();
            goal.setBudgetPeriod(this.getBudgetPeriod());
            this.accountGoals.put(account.getUuid(), goal);
        }
        return goal;
    }

    @Override
    public int compareTo(Budget budget) {
        int result = this.getName().compareTo(budget.getName());
        if (result == 0) {
            result = this.getDescription().compareTo(budget.getDescription());
        }
        if (result == 0) {
            return this.getUuid().compareTo(budget.getUuid());
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof Budget && this.getUuid().equals(((Budget)other).getUuid());
    }

    @Override
    public int hashCode() {
        return this.getUuid().hashCode();
    }

    public BudgetPeriod getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(BudgetPeriod budgetPeriod) {
        if (budgetPeriod == null) {
            throw new IllegalArgumentException("BudgetPeriod may not be null");
        }
        this.budgetPeriod = budgetPeriod;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Budget budget = (Budget)super.clone();
        budget.setDescription(this.getDescription());
        budget.setName(this.getName() + "(" + Resource.get().getString("Word.Copy") + ")");
        budget.accountGoals = new HashMap<String, BudgetGoal>();
        for (String key : this.accountGoals.keySet()) {
            budget.accountGoals.put(key, (BudgetGoal)this.accountGoals.get(key).clone());
        }
        budget.setBudgetPeriod(this.getBudgetPeriod());
        return budget;
    }

    public int getWorkingYear() {
        return this.workingYear;
    }

    public void setWorkingYear(int workingYear) {
        this.workingYear = workingYear;
    }

    public boolean areAssetAccountsIncluded() {
        return this.assetAccountsIncluded;
    }

    public void setAssetAccountsIncluded(boolean assetAccountsIncluded) {
        this.assetAccountsIncluded = assetAccountsIncluded;
    }

    public boolean areIncomeAccountsIncluded() {
        return this.incomeAccountsIncluded;
    }

    public void setIncomeAccountsIncluded(boolean incomeAccountsIncluded) {
        this.incomeAccountsIncluded = incomeAccountsIncluded;
    }

    public boolean areExpenseAccountsIncluded() {
        return this.expenseAccountsIncluded;
    }

    public void setExpenseAccountsIncluded(boolean expenseAccountsIncluded) {
        this.expenseAccountsIncluded = expenseAccountsIncluded;
    }

    public boolean areLiabilityAccountsIncluded() {
        return this.liabilityAccountsIncluded;
    }

    public void setLiabilityAccountsIncluded(boolean liabilityAccountsIncluded) {
        this.liabilityAccountsIncluded = liabilityAccountsIncluded;
    }

    protected Object readResolve() {
        this.workingYear = DateUtils.getCurrentYear();
        return this;
    }
}

