/*
 * Decompiled with CFR 0.152.
 */
package jgnash.bayes;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BayesClassifier<E> {
    private final E defaultClass;
    private static final double ASSUMED_PROBABILITY = 0.5;
    private static final double THRESHOLD = 1.0;
    private static final double WEIGHT = 1.0;
    private static final String WHITE_SPACE_REGEX = "[,\\s]+";
    private Map<String, Map<E, Integer>> featureCounter = new HashMap<String, Map<E, Integer>>();
    private Map<E, Integer> classCounter = new HashMap<E, Integer>();

    public BayesClassifier(E defaultClass) {
        this.defaultClass = defaultClass;
    }

    private void incrementFeature(String feature, E classification) {
        Map<E, Integer> featureMap = this.featureCounter.get(feature);
        if (featureMap == null) {
            featureMap = new HashMap<E, Integer>();
            featureMap.put(classification, 1);
            this.featureCounter.put(feature, featureMap);
            return;
        }
        Integer count = featureMap.get(classification);
        count = count == null ? 1 : count + 1;
        featureMap.put(classification, count);
    }

    private void incrementClass(E classification) {
        Integer count = this.classCounter.get(classification);
        count = count == null ? 1 : count + 1;
        this.classCounter.put(classification, count);
    }

    private int getClassCount(E classification) {
        Integer count = this.classCounter.get(classification);
        return count != null ? count : 0;
    }

    private int getFeatureCount(String feature, E classification) {
        Map<E, Integer> featureMap = this.featureCounter.get(feature);
        if (featureMap == null) {
            return 0;
        }
        Integer count = featureMap.get(classification);
        return count != null ? count : 0;
    }

    private int getFeatureCount(String feature) {
        Map<E, Integer> featureMap = this.featureCounter.get(feature);
        int count = 0;
        if (featureMap == null) {
            return count;
        }
        for (Map.Entry<E, Integer> entry : featureMap.entrySet()) {
            count += entry.getValue().intValue();
        }
        return count;
    }

    private double getFeatureProbability(String feature, E classification) {
        int count = this.getClassCount(classification);
        return count == 0 ? 0.0 : (double)this.getFeatureCount(feature, classification) / (double)count;
    }

    private double getWeightedProbability(String feature, E classification) {
        double probability = this.getFeatureProbability(feature, classification);
        int totals = this.getFeatureCount(feature);
        return (0.5 + (double)totals * probability) / (1.0 + (double)totals);
    }

    private double getClassProbability(String item, E classification) {
        double probability = 1.0;
        for (String feature : item.split(WHITE_SPACE_REGEX)) {
            probability *= this.getWeightedProbability(feature, classification);
        }
        return (double)this.classCounter.get(classification).intValue() / (double)this.classCounter.size() * probability;
    }

    private void train(Collection<String> features, E classification) {
        for (String feature : features) {
            this.incrementFeature(feature, classification);
        }
        this.incrementClass(classification);
    }

    public void train(String item, E classification) {
        this.train(Arrays.asList(item.toLowerCase(Locale.getDefault()).split(WHITE_SPACE_REGEX)), classification);
    }

    public E classify(String item) {
        double classProb;
        E bestClass = this.defaultClass;
        double max = 0.0;
        HashMap<E, Double> probabilities = new HashMap<E, Double>();
        for (E e : this.classCounter.keySet()) {
            classProb = this.getClassProbability(item.toLowerCase(Locale.getDefault()), e);
            probabilities.put(e, classProb);
            if (!(classProb > max)) continue;
            max = classProb;
            bestClass = e;
        }
        for (Map.Entry entry : probabilities.entrySet()) {
            double bestProbability;
            if (entry.getKey().equals(bestClass) || !((classProb = ((Double)entry.getValue()).doubleValue()) * 1.0 >= (bestProbability = ((Double)probabilities.get(bestClass)).doubleValue()))) continue;
            return this.defaultClass;
        }
        return bestClass;
    }
}

