/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.inline;

import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.InstructionAdapter;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.inline.CallGraph;

class CallVisitor
extends InstructionAdapter {
    MethodEditor caller;
    CallGraph cg;
    boolean firstSpecial;

    private static void db(String s) {
        CallGraph.db(s);
    }

    public CallVisitor(CallGraph cg) {
        this.cg = cg;
    }

    public void setCaller(MethodEditor caller) {
        this.caller = caller;
        this.firstSpecial = caller.isConstructor();
    }

    public void visit_invokevirtual(Instruction inst) {
        CallVisitor.db("\n    Visiting Call: " + inst);
        this.firstSpecial = false;
        MemberRef callee = (MemberRef)inst.operand();
        this.cg.doVirtual(this.caller, callee);
    }

    public void visit_invokeinterface(Instruction inst) {
        CallVisitor.db("\n    Visiting Call: " + inst);
        this.firstSpecial = false;
        MemberRef callee = (MemberRef)inst.operand();
        this.cg.doVirtual(this.caller, callee);
    }

    public void visit_invokestatic(Instruction inst) {
        CallVisitor.db("\n    Visiting call: " + inst);
        this.firstSpecial = false;
        MemberRef callee = (MemberRef)inst.operand();
        this.cg.addCall(this.caller, callee);
        this.cg.worklist.add(callee);
    }

    public void visit_invokespecial(Instruction inst) {
        CallVisitor.db("\n    Visiting call: " + inst);
        MemberRef callee = (MemberRef)inst.operand();
        MethodEditor calleeMethod = null;
        try {
            calleeMethod = this.cg.context.editMethod(callee);
        }
        catch (NoSuchMethodException ex1) {
            System.err.println("** Couldn't find method: " + callee);
            System.exit(1);
        }
        if (calleeMethod.isSynchronized() || calleeMethod.isNative()) {
            this.cg.doVirtual(this.caller, callee);
        } else {
            this.cg.addCall(this.caller, callee);
            this.cg.worklist.add(callee);
        }
        this.cg.context.release(calleeMethod.methodInfo());
    }

    public void visit_getstatic(Instruction inst) {
        CallVisitor.db("\n    Referencing static field " + inst);
        MemberRef field = (MemberRef)inst.operand();
        this.cg.addClinit(field.declaringClass());
    }

    public void visit_putstatic(Instruction inst) {
        CallVisitor.db("\n    Referencing static field " + inst);
        MemberRef field = (MemberRef)inst.operand();
        this.cg.addClinit(field.declaringClass());
    }

    public void visit_new(Instruction inst) {
        Type type = (Type)inst.operand();
        this.cg.makeLive(type);
    }
}

