/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.util;

import ar.com.fdvs.dj.util.SortInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiPropertyComparator
implements Comparator {
    private static final Log LOGGER = LogFactory.getLog(MultiPropertyComparator.class);
    private List info;

    public MultiPropertyComparator(List _info) {
        this.info = _info;
    }

    public int compare(Object _o1, Object _o2) {
        int result = 0;
        for (int i = 0; result == 0 && i < this.info.size(); ++i) {
            SortInfo sortInfo = (SortInfo)this.info.get(i);
            try {
                String propertyName = sortInfo.getPropertyName();
                Comparable value1 = MultiPropertyComparator.getValue(_o1, propertyName);
                Comparable value2 = MultiPropertyComparator.getValue(_o2, propertyName);
                result = MultiPropertyComparator.compare(value1, value2) * (sortInfo.isAscending() ? 1 : -1);
                continue;
            }
            catch (IllegalAccessException ex) {
                LOGGER.warn((Object)ex);
                continue;
            }
            catch (InvocationTargetException ex) {
                LOGGER.warn((Object)ex);
                continue;
            }
            catch (NoSuchMethodException ex) {
                LOGGER.warn((Object)ex);
            }
        }
        return result;
    }

    private static Comparable getValue(Object _object, String _field) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object value = PropertyUtils.getProperty((Object)_object, (String)_field);
        if (value == null) {
            return null;
        }
        if (!(value instanceof Comparable)) {
            throw new RuntimeException("Objects are not Comparable, class " + value.getClass().getName());
        }
        return (Comparable)value;
    }

    private static int compare(Comparable _value1, Comparable _value2) {
        if (_value1 == null) {
            if (_value2 == null) {
                return 0;
            }
            return -1;
        }
        if (_value2 == null) {
            return 1;
        }
        return _value1.compareTo(_value2);
    }
}

