/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.entities.columns;

import ar.com.fdvs.dj.core.CoreException;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;

public class PercentageColumn
extends AbstractColumn {
    private static final long serialVersionUID = 10000L;
    private PropertyColumn percentageColumn;

    public String getTextForExpression() {
        throw new CoreException("invalid operation on PercentageColumn");
    }

    public String getTextForExpression(DJGroup group) {
        return "new Double((" + this.getPercentageColumn().getTextForExpression() + ").doubleValue() / $V{" + this.getGroupVariableName(group) + "}.doubleValue())";
    }

    public String getTextForExpression(DJGroup group, DJGroup childGroup, String type) {
        return "new Double( $V{" + this.getGroupVariableName(childGroup) + "}.doubleValue() / $V{" + this.getGroupVariableName(type, group.getColumnToGroupBy().getColumnProperty().getProperty()) + "}.doubleValue())";
    }

    public String getValueClassNameForExpression() {
        return Number.class.getName();
    }

    public String getGroupVariableName(String type, String columnToGroupByProperty) {
        return "variable-" + type + "_" + columnToGroupByProperty + "_" + this.getPercentageColumn().getColumnProperty().getProperty() + "_percentage";
    }

    public String getVariableClassName(DJCalculation op) {
        if (op == DJCalculation.COUNT || op == DJCalculation.DISTINCT_COUNT) {
            return Long.class.getName();
        }
        return Number.class.getName();
    }

    public String getInitialExpression(DJCalculation op) {
        return "new java.lang.Long(\"0\")";
    }

    public String getGroupVariableName(DJGroup group) {
        String columnToGroupByProperty = null;
        columnToGroupByProperty = group.getColumnToGroupBy().getColumnProperty().getProperty();
        return "variable-" + columnToGroupByProperty + "_" + this.getPercentageColumn().getColumnProperty().getProperty() + "_percentage";
    }

    public void setPercentageColumn(PropertyColumn percentageColumn) {
        this.percentageColumn = percentageColumn;
    }

    public PropertyColumn getPercentageColumn() {
        return this.percentageColumn;
    }
}

