/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.registration;

import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.registration.AbstractEntityRegistrationManager;
import ar.com.fdvs.dj.core.registration.EntitiesRegistrationException;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.entities.DJGroupVariableDef;
import ar.com.fdvs.dj.domain.entities.Entity;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import ar.com.fdvs.dj.util.ExpressionUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DJGroupVariableDefRegistrationManager
extends AbstractEntityRegistrationManager {
    private static final Log log = LogFactory.getLog(DJGroupVariableDefRegistrationManager.class);
    JRDesignGroup group = null;

    public DJGroupVariableDefRegistrationManager(DynamicJasperDesign jd, DynamicReport dr, LayoutManager layoutManager, JRDesignGroup group) {
        super(jd, dr, layoutManager);
        this.group = group;
    }

    protected void registerEntity(Entity entity) {
        log.debug((Object)"registering group variable...");
        try {
            JRDesignVariable jrVariable = (JRDesignVariable)this.transformEntity(entity);
            this.getDjd().addVariable(jrVariable);
        }
        catch (JRException e) {
            throw new EntitiesRegistrationException(e.getMessage(), e);
        }
    }

    protected Object transformEntity(Entity entity) {
        log.debug((Object)"transforming group variable...");
        DJGroupVariableDef columnsGroupVariable = (DJGroupVariableDef)entity;
        DJCalculation op = columnsGroupVariable.getOperation();
        JRDesignExpression expression = new JRDesignExpression();
        String valueClassName = null;
        String initialExpression = null;
        if (columnsGroupVariable.getColumnProperty() != null) {
            ColumnProperty prop = columnsGroupVariable.getColumnProperty();
            expression.setText("$F{" + prop.getProperty() + "}");
            expression.setValueClassName(prop.getValueClassName());
            this.registerField(prop);
            valueClassName = ExpressionUtils.getValueClassNameForOperation(op, prop);
            initialExpression = ExpressionUtils.getInitialValueExpressionForOperation(op, prop);
        } else {
            AbstractColumn col = columnsGroupVariable.getColumnToApplyOperation();
            if (col instanceof ExpressionColumn && ((ExpressionColumn)col).getExpressionForCalculation() != null) {
                ExpressionColumn expcol = (ExpressionColumn)col;
                expression.setText(expcol.getTextForExpressionForCalculartion());
                expression.setValueClassName(expcol.getExpressionForCalculation().getClassName());
            } else {
                expression.setText(col.getTextForExpression());
                expression.setValueClassName(col.getValueClassNameForExpression());
            }
            valueClassName = col.getVariableClassName(op);
            initialExpression = col.getInitialExpression(op);
        }
        JRDesignVariable variable = new JRDesignVariable();
        variable.setExpression((JRExpression)expression);
        variable.setCalculation(columnsGroupVariable.getOperation().getValue());
        variable.setName(columnsGroupVariable.getName());
        if (this.group != null) {
            variable.setResetType((byte)4);
            variable.setResetGroup((JRGroup)this.group);
        }
        variable.setValueClassName(valueClassName);
        JRDesignExpression initialExp = new JRDesignExpression();
        initialExp.setText(initialExpression);
        initialExp.setValueClassName(valueClassName);
        variable.setInitialValueExpression((JRExpression)initialExp);
        return variable;
    }

    protected void registerField(ColumnProperty columnProperty) {
        JRDesignField field = new JRDesignField();
        field.setName(columnProperty.getProperty());
        field.setValueClassName(columnProperty.getValueClassName());
        log.debug((Object)("transforming column property for group variable: " + columnProperty.getProperty() + " (" + columnProperty.getValueClassName() + ")"));
        for (String key : columnProperty.getFieldProperties().keySet()) {
            field.getPropertiesMap().setProperty(key, (String)columnProperty.getFieldProperties().get(key));
        }
        try {
            if (this.getDjd().getFieldsMap().get(field.getName()) == null) {
                this.getDjd().addField((JRField)field);
            }
        }
        catch (JRException e) {
            log.info((Object)("The field has already been registered: " + e.getMessage() + ", (skipping)"));
        }
    }
}

