/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.wizards.imports.qif;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.StyledEditorKit;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.imports.qif.QifAccount;
import jgnash.imports.qif.QifTransaction;
import jgnash.imports.qif.QifUtils;
import jgnash.ui.components.AccountListComboBox;
import jgnash.ui.components.wizard.WizardPage;
import jgnash.ui.util.TextResource;
import jgnash.util.Resource;

public class PartialOne
extends JPanel
implements WizardPage,
ActionListener {
    private Account destinationAccount;
    private AccountListComboBox accountCombo;
    private JTextPane helpPane;
    private JComboBox<String> dateFormatCombo;
    private QifAccount qAcc;
    private Preferences pref = Preferences.userNodeForPackage(PartialOne.class);
    private static final String LAST_ACCOUNT = "lastAccount";
    private static final String DATE_FORMAT = "dateFormat";
    private Resource rb = Resource.get();

    public PartialOne(QifAccount qAcc) {
        this.qAcc = qAcc;
        this.layoutMainPanel();
    }

    private void initComponents() {
        this.accountCombo = new AccountListComboBox();
        this.helpPane = new JTextPane();
        this.helpPane.setEditable(false);
        this.helpPane.setEditorKit(new StyledEditorKit());
        this.helpPane.setBackground(this.getBackground());
        this.helpPane.setText(TextResource.getString("QifOne.txt"));
        String[] formats = new String[]{"mm/dd/yyyy", "dd/mm/yyyy"};
        this.dateFormatCombo = new JComboBox<String>(formats);
        this.dateFormatCombo.addActionListener(this);
        this.dateFormatCombo.setSelectedIndex(this.pref.getInt(DATE_FORMAT, 0));
        this.accountCombo.addActionListener(this);
        String lastAccount = this.pref.get(LAST_ACCOUNT, "");
        Account last = EngineFactory.getEngine("default").getAccountByUuid(lastAccount);
        if (last != null) {
            this.setAccount(last);
        }
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p, 8dlu, 85dlu:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.appendSeparator(this.rb.getString("Title.SelDestAccount"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"p"));
        builder.append((Component)this.helpPane, 3);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append(this.rb.getString("Label.DestAccount"), (Component)this.accountCombo);
        builder.nextLine();
        builder.append(this.rb.getString("Label.DateFormat"), this.dateFormatCombo);
    }

    private void accountAction() {
        this.destinationAccount = this.accountCombo.getSelectedAccount();
        if (this.destinationAccount != null) {
            this.pref.put(LAST_ACCOUNT, this.destinationAccount.getUuid());
            this.pref.putInt(DATE_FORMAT, this.dateFormatCombo.getSelectedIndex());
        }
    }

    @Override
    public boolean isPageValid() {
        if (this.destinationAccount == null) {
            this.destinationAccount = this.accountCombo.getSelectedAccount();
        }
        return true;
    }

    public Account getAccount() {
        if (this.destinationAccount == null) {
            this.destinationAccount = this.accountCombo.getSelectedAccount();
        }
        return this.destinationAccount;
    }

    void setAccount(Account account) {
        this.destinationAccount = account;
        this.accountCombo.setSelectedAccount(this.destinationAccount);
    }

    String getDateFormat() {
        return (String)this.dateFormatCombo.getSelectedItem();
    }

    private void reparseDates() {
        String df = this.getDateFormat();
        int count = this.qAcc.numItems();
        for (int i = 0; i < count; ++i) {
            QifTransaction qt = this.qAcc.get(i);
            qt.date = QifUtils.parseDate((String)qt.oDate, (String)df);
        }
        System.out.println("reparse");
    }

    @Override
    public String toString() {
        return "1. " + this.rb.getString("Title.SelDestAccount");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.accountCombo) {
            this.accountAction();
        } else if (e.getSource() == this.dateFormatCombo) {
            this.reparseDates();
        }
    }

    @Override
    public void getSettings(Map<Enum<?>, Object> map) {
    }

    @Override
    public void putSettings(Map<Enum<?>, Object> map) {
    }
}

