/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.wizards.imports.jgnash;

import java.awt.EventQueue;
import java.awt.Frame;
import java.util.prefs.Preferences;
import javax.swing.SwingWorker;
import jgnash.engine.DataStoreType;
import jgnash.engine.EngineFactory;
import jgnash.imports.jgnash.Import;
import jgnash.ui.UIApplication;
import jgnash.ui.components.wizard.WizardDialog;
import jgnash.ui.wizards.file.NewFileDialog;
import jgnash.ui.wizards.imports.jgnash.ImportOne;
import jgnash.ui.wizards.imports.jgnash.ImportZero;
import jgnash.util.Resource;

public class ImportDialog
extends WizardDialog {
    private ImportDialog(Frame parent) {
        super(parent);
        this.setTitle(this.rb.getString("Title.NewFile"));
    }

    public static void showDialog(final Frame parent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportDialog d = new ImportDialog(parent);
                String LAST_FILE = "file0";
                Preferences pref = Preferences.userNodeForPackage(ImportDialog.class);
                String lastfile = pref.get("file0", "");
                if (lastfile.length() > 0) {
                    d.setSetting(Settings.IMPORTFILE, lastfile);
                }
                d.setSetting(NewFileDialog.Settings.DATABASE_NAME, EngineFactory.getDefaultDatabase());
                d.addTaskPage(new ImportZero());
                d.addTaskPage(new ImportOne());
                d.setLocationRelativeTo(parent);
                d.setVisible(true);
                if (d.isWizardValid()) {
                    String database = (String)d.getSetting(NewFileDialog.Settings.DATABASE_NAME);
                    String importFile = (String)d.getSetting(Settings.IMPORTFILE);
                    DataStoreType type = (DataStoreType)((Object)d.getSetting(NewFileDialog.Settings.TYPE));
                    EngineFactory.closeEngine("default");
                    EngineFactory.deleteDatabase(database);
                    EngineFactory.bootLocalEngine(database, "default", type);
                    new ImportFile(importFile).execute();
                }
            }
        });
    }

    private static final class ImportFile
    extends SwingWorker<Void, Void> {
        private final String filename;

        public ImportFile(String filename) {
            this.filename = filename;
        }

        @Override
        protected Void doInBackground() throws Exception {
            Resource rb = Resource.get();
            UIApplication.getFrame().displayWaitMessage(rb.getString("Message.PleaseWait"));
            Import.doImport((String)this.filename);
            return null;
        }

        @Override
        protected void done() {
            UIApplication.getFrame().stopWaitMessage();
        }
    }

    public static enum Settings {
        IMPORTFILE;

    }
}

