/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.util;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import jgnash.util.Resource;

public class CursorUtils {
    public static final int ZOOM_IN = 0;
    public static final int ZOOM_OUT = 1;
    private static final Cursor[] predefined = new Cursor[2];
    private static final Object[][] cursorProperties = new Object[][]{{"ZoomIn", "/jgnash/resource/ZoomInCursor.gif", new int[]{4, 4}}, {"ZoomOut", "/jgnash/resource/ZoomOutCursor.gif", new int[]{4, 4}}};

    private CursorUtils() {
    }

    public static Cursor getCursor(int type) {
        if (type < 0 || type > 1) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        if (predefined[type] == null) {
            try {
                Object[] props = cursorProperties[type];
                String name = (String)props[0];
                String resource = (String)props[1];
                int[] spot = (int[])props[2];
                Point point = new Point(spot[0], spot[1]);
                Toolkit tk = Toolkit.getDefaultToolkit();
                Image image = Resource.getImage(resource);
                CursorUtils.predefined[type] = tk.createCustomCursor(image, point, name);
            }
            catch (Exception e) {
                CursorUtils.predefined[type] = Cursor.getDefaultCursor();
                throw new RuntimeException(e);
            }
        }
        return predefined[type];
    }
}

