/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.table;

import java.awt.EventQueue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import jgnash.engine.Account;
import jgnash.engine.Comparators;
import jgnash.engine.Transaction;
import jgnash.message.Message;
import jgnash.message.MessageProperty;
import jgnash.ui.register.AccountBalanceDisplayManager;
import jgnash.ui.register.table.RegisterTableModel;
import jgnash.ui.register.table.SortableTableModel;

public class SortedTableModel
extends RegisterTableModel
implements SortableTableModel {
    private static final long serialVersionUID = -7009845379286807436L;
    List<Transaction> transactions = new ArrayList<Transaction>();
    private int sortColumn = 0;
    private boolean ascending = true;
    private boolean[] sortedColumnMap;
    private boolean[] sortColumns;
    private Comparator<Transaction> comparator = Comparators.getTransactionByDate();
    private ReentrantLock lock = new ReentrantLock();

    public SortedTableModel(Account account, String[] names) {
        super(account, names);
        this.getTransactions();
    }

    private static boolean[] getSortableColumns() {
        return new boolean[]{true, true, true, true, true, false, true, true, false};
    }

    @Override
    protected void buildColumnMap() {
        super.buildColumnMap();
        if (this.sortColumns == null) {
            this.sortColumns = SortedTableModel.getSortableColumns();
        }
        this.sortedColumnMap = new boolean[this.getColumnCount()];
        int index = 0;
        for (int i = 0; i < this.columnVisible.length; ++i) {
            if (!this.columnVisible[i]) continue;
            this.sortedColumnMap[index] = this.sortColumns[i];
            ++index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTransactions() {
        this.lock.lock();
        try {
            this.transactions = this.account.getTransactions();
            Collections.sort(this.transactions, this.comparator);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        this.lock.lock();
        try {
            int n = this.transactions.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transaction getTransactionAt(int index) {
        this.lock.lock();
        try {
            if (this.ascending) {
                Transaction transaction = this.transactions.get(index);
                return transaction;
            }
            Transaction transaction = this.transactions.get(this.transactions.size() - index - 1);
            return transaction;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int convertRowIndexToAccount(int index) {
        this.lock.lock();
        try {
            int n = this.account.indexOf(this.getTransactionAt(index));
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Transaction t) {
        this.lock.lock();
        try {
            int n = this.transactions.indexOf(t);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBalanceAt(int index) {
        if (this.balanceCache.get(index) != null) {
            return AccountBalanceDisplayManager.convertToSelectedBalanceMode(this.account.getAccountType(), this.balanceCache.get(index));
        }
        if (index > 0 && this.balanceCache.get(index - 1) != null) {
            BigDecimal bal = this.balanceCache.get(index - 1);
            bal = bal.add(this.getTransactionAt(index).getAmount(this.account));
            this.balanceCache.set(index, bal);
            return bal;
        }
        BigDecimal bal = BigDecimal.ZERO;
        if (this.transactions != null) {
            this.lock.lock();
            try {
                for (int i = 0; i <= index; ++i) {
                    bal = bal.add(this.getTransactionAt(i).getAmount(this.account));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        this.balanceCache.set(index, bal);
        return AccountBalanceDisplayManager.convertToSelectedBalanceMode(this.account.getAccountType(), bal);
    }

    @Override
    public void messagePosted(final Message event) {
        if (event.getObject(MessageProperty.ACCOUNT) == this.account) {
            switch (event.getEvent()) {
                case FILE_CLOSING: {
                    this.unregister();
                    return;
                }
                case TRANSACTION_ADD: {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SortedTableModel.this.balanceCache.ensureCapacity(SortedTableModel.this.account.getTransactionCount());
                            SortedTableModel.this.addTransaction((Transaction)event.getObject(MessageProperty.TRANSACTION));
                        }
                    });
                    return;
                }
                case TRANSACTION_REMOVE: {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SortedTableModel.this.removeTransaction((Transaction)event.getObject(MessageProperty.TRANSACTION));
                        }
                    });
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTransaction(Transaction t) {
        this.lock.lock();
        try {
            int index = Collections.binarySearch(this.transactions, t, this.comparator);
            if (index < 0) {
                int i = -index - 1;
                this.transactions.add(i, t);
                if (i >= 1) {
                    this.balanceCache.clear(i - 1);
                } else {
                    this.balanceCache.clear();
                }
                this.fireTableRowsInserted(i, i);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransaction(Transaction t) {
        this.lock.lock();
        try {
            int i = this.transactions.indexOf(t);
            if (i >= 0) {
                this.transactions.remove(t);
                if (i >= 1) {
                    this.balanceCache.clear(i - 1);
                } else {
                    this.balanceCache.clear();
                }
                this.fireTableRowsDeleted(i, i);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isSortable(int col) {
        return this.sortedColumnMap[col];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sortColumn(int col, boolean ascending1) {
        this.ascending = ascending1;
        this.sortColumn = col;
        switch (this.getColumnMapping(col)) {
            case 0: {
                this.comparator = Comparators.getTransactionByDate();
                break;
            }
            case 1: {
                this.comparator = Comparators.getTransactionByNumber();
                break;
            }
            case 2: {
                this.comparator = Comparators.getTransactionByPayee();
                break;
            }
            case 3: {
                this.comparator = Comparators.getTransactionByMemo();
                break;
            }
            case 4: {
                this.comparator = new Comparators.TransactionByAccount(this.account);
                break;
            }
            case 6: 
            case 7: {
                this.comparator = Comparators.getTransactionByAmount();
                break;
            }
            default: {
                this.comparator = Comparators.getTransactionByDate();
            }
        }
        this.lock.lock();
        try {
            Collections.sort(this.transactions, this.comparator);
            this.balanceCache.clear();
        }
        finally {
            this.lock.unlock();
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getSortedColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean getAscending() {
        return this.ascending;
    }
}

