/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import jgnash.engine.ReconciledState;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionTag;
import jgnash.ui.register.AbstractTransactionEntryPanel;
import jgnash.ui.register.table.SplitsRegisterTableModel;

public class FeeTransactionEntryPanel
extends AbstractTransactionEntryPanel {
    FeeTransactionEntryPanel(SplitsRegisterTableModel model) {
        super(model);
    }

    @Override
    public TransactionEntry buildTransactionEntry() {
        TransactionEntry entry = new TransactionEntry();
        entry.setMemo(this.memoField.getText());
        entry.setDebitAccount(this.getAccount());
        entry.setCreditAccount(this.accountPanel.getSelectedAccount());
        entry.setDebitAmount(this.amountField.getDecimal().abs().negate());
        if (this.hasEqualCurrencies()) {
            entry.setCreditAmount(this.amountField.getDecimal().abs());
        } else {
            entry.setCreditAmount(this.accountPanel.getExchangedAmount().abs());
        }
        entry.setTransactionTag(TransactionTag.INVESTMENT_FEE);
        if (this.reconciledButton.isSelected()) {
            entry.setReconciled(this.account, ReconciledState.RECONCILED);
        } else {
            entry.setReconciled(this.account, ReconciledState.NOT_RECONCILED);
        }
        return entry;
    }

    @Override
    public void modifyTransaction(TransactionEntry entry) {
        this.oldEntry = entry;
        this.memoField.setText(entry.getMemo());
        this.accountPanel.setSelectedAccount(entry.getCreditAccount());
        this.amountField.setDecimal(entry.getDebitAmount().abs());
        this.accountPanel.setExchangedAmount(entry.getCreditAmount());
        this.reconciledButton.setSelected(entry.getReconciled(this.getAccount()) == ReconciledState.RECONCILED);
    }
}

