/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.JPanel;
import jgnash.engine.AbstractInvestmentTransactionEntry;
import jgnash.engine.Account;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.SecurityNode;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionEntryBuyX;
import jgnash.engine.TransactionFactory;
import jgnash.ui.register.AccountExchangePanel;
import jgnash.ui.register.invest.AbstractPriceQtyInvTransactionPanel;
import jgnash.ui.register.invest.FeePanel;
import jgnash.ui.util.ValidationFactory;

public final class BuySharePanel
extends AbstractPriceQtyInvTransactionPanel {
    private FeePanel feePanel;
    private AccountExchangePanel accountExchangePanel;

    BuySharePanel(Account account) {
        super(account);
        this.feePanel = new FeePanel(account);
        this.accountExchangePanel = new AccountExchangePanel(this.getAccount().getCurrencyNode(), this.totalField);
        this.accountExchangePanel.setSelectedAccount(this.getAccount());
        this.layoutMainPanel();
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BuySharePanel.this.updateTotalField();
            }
        };
        this.feePanel.addFocusListener(focusListener);
        this.feePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == BuySharePanel.this.feePanel) {
                    BuySharePanel.this.updateTotalField();
                }
            }
        });
        this.quantityField.addFocusListener(focusListener);
        this.priceField.addFocusListener(focusListener);
        this.datePanel.getDateField().addKeyListener(this.keyListener);
        this.feePanel.addKeyListener(this.keyListener);
        this.memoField.addKeyListener(this.keyListener);
        this.priceField.addKeyListener(this.keyListener);
        this.quantityField.addKeyListener(this.keyListener);
        this.securityCombo.addKeyListener(this.keyListener);
        this.reconciledButton.addKeyListener(this.keyListener);
        this.clearForm();
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("right:d, $lcgap, 50dlu:g, 8dlu, right:d, $lcgap, max(65dlu;min)", "f:d, $nlgap, f:d, $nlgap, f:d, $nlgap, f:d");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5, 7}});
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        JPanel subPanel = this.buildHorizontalSubPanel("max(48dlu;min):g(0.5), 8dlu, d, $lcgap, max(48dlu;min):g(0.5)", ValidationFactory.wrap(this.priceField), "Label.Quantity", ValidationFactory.wrap(this.quantityField));
        this.add("Label.Security", (Object)cc.xy(1, 1));
        this.add((Component)ValidationFactory.wrap(this.securityCombo), (Object)cc.xy(3, 1));
        this.add("Label.Date", (Object)cc.xy(5, 1));
        this.add((Component)this.datePanel, (Object)cc.xy(7, 1));
        this.add("Label.Price", (Object)cc.xy(1, 3));
        this.add((Component)subPanel, (Object)cc.xy(3, 3));
        this.add("Label.Fees", (Object)cc.xy(5, 3));
        this.add((Component)this.feePanel, (Object)cc.xy(7, 3));
        this.add("Label.Memo", (Object)cc.xy(1, 5));
        this.add((Component)this.memoField, (Object)cc.xy(3, 5));
        this.add("Label.Total", (Object)cc.xy(5, 5));
        this.add((Component)this.totalField, (Object)cc.xy(7, 5));
        this.add("Label.Account", (Object)cc.xy(1, 7));
        this.add((Component)this.accountExchangePanel, (Object)cc.xy(3, 7));
        this.add((Component)this.reconciledButton, (Object)cc.xyw(5, 7, 3));
    }

    void updateTotalField() {
        BigDecimal fee = this.feePanel.getDecimal();
        BigDecimal quantity = this.quantityField.getDecimal();
        BigDecimal price = this.priceField.getDecimal();
        BigDecimal value = quantity.multiply(price);
        value = value.add(fee);
        this.totalField.setDecimal(value);
    }

    @Override
    public void modifyTransaction(Transaction tran) {
        if (!(tran instanceof InvestmentTransaction)) {
            throw new IllegalArgumentException("bad tranType");
        }
        this.clearForm();
        this.datePanel.setDate(tran.getDate());
        List<TransactionEntry> entries = tran.getTransactionEntries();
        this.feePanel.setTransactionEntries(((InvestmentTransaction)tran).getInvestmentFeeEntries());
        for (TransactionEntry e : entries) {
            if (!(e instanceof TransactionEntryBuyX)) continue;
            AbstractInvestmentTransactionEntry entry = (AbstractInvestmentTransactionEntry)e;
            this.memoField.setText(e.getMemo());
            this.priceField.setDecimal(entry.getPrice());
            this.quantityField.setDecimal(entry.getQuantity());
            this.securityCombo.setSelectedNode(entry.getSecurityNode());
            if (entry.getCreditAccount().equals(this.account)) {
                this.accountExchangePanel.setSelectedAccount(entry.getDebitAccount());
                this.accountExchangePanel.setExchangedAmount(entry.getDebitAmount().abs());
                continue;
            }
            this.accountExchangePanel.setSelectedAccount(entry.getCreditAccount());
            this.accountExchangePanel.setExchangedAmount(entry.getCreditAmount());
        }
        this.updateTotalField();
        this.modTrans = tran;
        this.reconciledButton.setSelected(tran.getReconciled(this.getAccount()) == ReconciledState.RECONCILED);
    }

    @Override
    public Transaction buildTransaction() {
        BigDecimal exchangeRate = this.accountExchangePanel.getExchangeRate();
        List<TransactionEntry> fees = this.feePanel.getTransactions();
        return TransactionFactory.generateBuyXTransaction(this.accountExchangePanel.getSelectedAccount(), this.getAccount(), (SecurityNode)this.securityCombo.getSelectedNode(), this.priceField.getDecimal(), this.quantityField.getDecimal(), exchangeRate, this.datePanel.getDate(), this.memoField.getText(), this.reconciledButton.isSelected(), fees);
    }

    @Override
    public void clearForm() {
        super.clearForm();
        this.feePanel.clearForm();
        this.accountExchangePanel.setSelectedAccount(this.getAccount());
        this.updateTotalField();
    }
}

