/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import java.awt.Insets;
import javax.swing.JCheckBox;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.ReconcileManager;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.ui.register.AbstractTransactionPanel;

public abstract class AbstractInvTransactionPanel
extends AbstractTransactionPanel {
    JCheckBox reconciledButton;
    Transaction modTrans = null;
    Account account;

    AbstractInvTransactionPanel(Account account) {
        if (!account.memberOf(AccountGroup.INVEST)) {
            throw new RuntimeException(this.rb.getString("Message.ErrorInvalidAccountGroup"));
        }
        this.account = account;
        this.reconciledButton = new JCheckBox(this.rb.getString("Button.Reconciled"));
        this.reconciledButton.setHorizontalTextPosition(10);
        this.reconciledButton.setMargin(new Insets(0, 0, 0, 0));
    }

    @Override
    protected Account getAccount() {
        return this.account;
    }

    @Override
    public void enterAction() {
        if (this.validateForm()) {
            Engine engine = EngineFactory.getEngine("default");
            if (this.modTrans == null) {
                engine.addTransaction(this.buildTransaction());
            } else {
                Transaction newTrans = this.buildTransaction();
                newTrans.setDateEntered(this.modTrans.getDateEntered());
                ReconcileManager.reconcileTransaction(this.getAccount(), newTrans, this.reconciledButton.isSelected() ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
                if (engine.isTransactionValid(newTrans) && engine.removeTransaction(this.modTrans)) {
                    engine.addTransaction(newTrans);
                }
            }
            this.clearForm();
            this.focusFirstComponent();
        }
    }
}

