/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconcileManager;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionFactory;
import jgnash.engine.TransactionType;
import jgnash.ui.StaticUIMethods;
import jgnash.ui.register.AbstractExchangeTransactionPanel;
import jgnash.ui.register.PanelType;
import jgnash.ui.register.SplitsDialog;
import jgnash.ui.util.ValidationFactory;

public class TransactionPanel
extends AbstractExchangeTransactionPanel {
    private List<TransactionEntry> splits = null;
    private TransactionEntry modEntry = null;
    private final JButton splitsButton = new JButton(this.rb.getString("Button.Splits"));

    public TransactionPanel(Account account, PanelType panelType) {
        super(account, panelType);
        this.registerListener();
        this.layoutMainPanel();
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("right:d, $lcgap, m:g, 8dlu, right:d, $lcgap, max(48dlu;min)", "f:d, $nlgap, f:d, $nlgap, f:d, $nlgap, f:d");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5, 7}});
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        this.setBorder(Borders.DIALOG_BORDER);
        JPanel sub = this.buildHorizontalSubPanel("48dlu:g, $lcgap, d", this.accountPanel, this.splitsButton);
        this.add("Label.Payee", (Object)cc.xy(1, 1));
        this.add((Component)this.payeeField, (Object)cc.xy(3, 1));
        this.add("Label.Number", (Object)cc.xy(5, 1));
        this.add((Component)this.numberField, (Object)cc.xy(7, 1));
        this.add("Label.Account", (Object)cc.xy(1, 3));
        this.add((Component)sub, (Object)cc.xy(3, 3));
        this.add("Label.Date", (Object)cc.xy(5, 3));
        this.add((Component)this.datePanel, (Object)cc.xy(7, 3));
        this.add("Label.Memo", (Object)cc.xy(1, 5));
        this.add((Component)this.memoField, (Object)cc.xy(3, 5));
        this.add("Label.Amount", (Object)cc.xy(5, 5));
        this.add((Component)ValidationFactory.wrap(this.amountField), (Object)cc.xy(7, 5));
        this.add((Component)this.createBottomPanel(), (Object)cc.xyw(1, 7, 7));
        this.clearForm();
    }

    private void registerListener() {
        this.splitsButton.addActionListener(this);
        this.splitsButton.addKeyListener(this.keyListener);
    }

    @Override
    public void enterAction() {
        if (this.validateForm()) {
            if (this.modEntry != null && this.modTrans != null) {
                try {
                    Transaction t = (Transaction)this.modTrans.clone();
                    t.removeTransactionEntry(this.modEntry);
                    TransactionEntry e = this.buildTransactionEntry();
                    t.addTransactionEntry(e);
                    ReconcileManager.reconcileTransaction(this.getAccount(), t, this.reconciledButton.isSelected() ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
                    EngineFactory.getEngine("default").removeTransaction(this.modTrans);
                    EngineFactory.getEngine("default").addTransaction(t);
                    this.clearForm();
                    this.fireOkAction();
                    this.focusFirstComponent();
                }
                catch (CloneNotSupportedException e) {
                    Logger.getLogger(TransactionPanel.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            } else {
                super.enterAction();
            }
        }
    }

    private void splitsAction() {
        SplitsDialog dlg = SplitsDialog.getSplitsDialog(this, this.getAccount(), this.splits, this.panelType);
        dlg.setVisible(true);
        if (dlg.returnStatus) {
            this.splits = dlg.getSplits();
            if (!dlg.getSplits().isEmpty()) {
                this.accountPanel.setEnabled(false);
                this.amountField.setDecimal(dlg.getBalance().abs());
                this.amountField.setEditable(false);
            } else {
                this.accountPanel.setEnabled(true);
                this.amountField.setEditable(true);
            }
            this.splits = dlg.getSplits();
            if (this.splits.isEmpty()) {
                this.splits = null;
            }
        }
    }

    private TransactionEntry buildTransactionEntry() {
        TransactionEntry entry = new TransactionEntry();
        entry.setMemo(this.memoField.getText());
        int signum = this.amountField.getDecimal().signum();
        if (this.panelType == PanelType.DECREASE && signum >= 0 || this.panelType == PanelType.INCREASE && signum < 0) {
            entry.setCreditAccount(this.accountPanel.getSelectedAccount());
            entry.setDebitAccount(this.getAccount());
            if (this.hasEqualCurrencies()) {
                entry.setAmount(this.amountField.getDecimal().abs());
            } else {
                entry.setDebitAmount(this.accountPanel.getExchangedAmount().abs().negate());
            }
        } else {
            entry.setCreditAccount(this.getAccount());
            entry.setDebitAccount(this.accountPanel.getSelectedAccount());
            if (this.hasEqualCurrencies()) {
                entry.setAmount(this.amountField.getDecimal().abs());
            } else {
                entry.setCreditAmount(this.accountPanel.getExchangedAmount().abs());
            }
        }
        if (this.reconciledButton.isSelected()) {
            entry.setReconciled(this.account, ReconciledState.RECONCILED);
        } else {
            entry.setReconciled(this.account, ReconciledState.NOT_RECONCILED);
        }
        return entry;
    }

    @Override
    protected Transaction buildTransaction() {
        Transaction transaction;
        if (this.splits != null) {
            transaction = new Transaction();
            transaction.setDate(this.datePanel.getDate());
            transaction.setNumber(this.numberField.getText());
            transaction.setMemo(this.memoField.getText());
            transaction.setPayee(this.payeeField.getText());
            transaction.addTransactionEntries(this.splits);
        } else {
            int signum = this.amountField.getDecimal().signum();
            Account selectedAccount = this.modTrans != null && this.modTrans.areAccountsHidden() ? this.getOppositeSideAccount(this.modTrans) : this.accountPanel.getSelectedAccount();
            transaction = this.panelType == PanelType.DECREASE && signum >= 0 || this.panelType == PanelType.INCREASE && signum == -1 ? (this.hasEqualCurrencies() ? TransactionFactory.generateDoubleEntryTransaction(selectedAccount, this.getAccount(), this.amountField.getDecimal().abs(), this.datePanel.getDate(), this.memoField.getText(), this.payeeField.getText(), this.numberField.getText()) : TransactionFactory.generateDoubleEntryTransaction(selectedAccount, this.getAccount(), this.accountPanel.getExchangedAmount().abs(), this.amountField.getDecimal().abs().negate(), this.datePanel.getDate(), this.memoField.getText(), this.payeeField.getText(), this.numberField.getText())) : (this.hasEqualCurrencies() ? TransactionFactory.generateDoubleEntryTransaction(this.getAccount(), selectedAccount, this.amountField.getDecimal().abs(), this.datePanel.getDate(), this.memoField.getText(), this.payeeField.getText(), this.numberField.getText()) : TransactionFactory.generateDoubleEntryTransaction(this.getAccount(), selectedAccount, this.amountField.getDecimal().abs(), this.accountPanel.getExchangedAmount().abs().negate(), this.datePanel.getDate(), this.memoField.getText(), this.payeeField.getText(), this.numberField.getText()));
        }
        ReconcileManager.reconcileTransaction(this.getAccount(), transaction, this.reconciledButton.isSelected());
        return transaction;
    }

    @Override
    public void modifyTransaction(Transaction t) {
        if (t.areAccountsLocked()) {
            this.clearForm();
            StaticUIMethods.displayError(this.rb.getString("Message.TransactionModifyLocked"));
            return;
        }
        this.newTransaction(t);
        this.modTrans = t;
        if (!this.canModifyTransaction(t) && t.getTransactionType() == TransactionType.SPLITENTRY) {
            for (TransactionEntry entry : t.getTransactionEntries()) {
                if (!entry.getCreditAccount().equals(this.getAccount()) && !entry.getDebitAccount().equals(this.getAccount())) continue;
                this.modEntry = entry;
                break;
            }
            if (this.modEntry == null) {
                Logger logger = Logger.getLogger(TransactionPanel.class.getName());
                logger.warning("Was not able to modify the transaction");
            }
        }
    }

    public void newTransaction(Transaction t) {
        this.clearForm();
        this.splits = null;
        this.amountField.setDecimal(t.getAmount(this.getAccount()).abs());
        this.memoField.setText(t.getMemo());
        this.payeeField.setText(t.getPayee());
        this.numberField.setText(t.getNumber());
        this.datePanel.setDate(t.getDate());
        this.reconciledButton.setSelected(t.getReconciled(this.getAccount()) == ReconciledState.RECONCILED);
        if (t.getTransactionType() == TransactionType.SPLITENTRY) {
            this.accountPanel.setSelectedAccount(t.getCommonAccount());
            this.accountPanel.setEnabled(false);
            if (this.canModifyTransaction(t)) {
                this.splits = new ArrayList<TransactionEntry>();
                for (TransactionEntry entry : t.getTransactionEntries()) {
                    try {
                        this.splits.add((TransactionEntry)entry.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        Logger.getLogger(TransactionPanel.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                }
                this.amountField.setEditable(false);
                this.amountField.setDecimal(t.getAmount(this.getAccount()).abs());
            } else {
                this.splitsButton.setEnabled(false);
                this.payeeField.setEditable(false);
                this.numberField.setEnabled(false);
                this.datePanel.setEditable(false);
                this.amountField.setEditable(true);
                this.amountField.setDecimal(t.getAmount(this.getAccount()).abs());
                for (TransactionEntry entry : t.getTransactionEntries()) {
                    if (entry.getCreditAccount() == this.getAccount()) {
                        this.accountPanel.setExchangedAmount(entry.getDebitAmount().abs());
                    } else {
                        if (entry.getDebitAccount() != this.getAccount()) continue;
                        this.accountPanel.setExchangedAmount(entry.getCreditAmount());
                    }
                    break;
                }
            }
        } else if (t instanceof InvestmentTransaction) {
            Logger logger = Logger.getLogger(TransactionPanel.class.getName());
            logger.warning("unsupported transaction type");
        } else {
            this.accountPanel.setEnabled(!t.areAccountsHidden());
            this.amountField.setEnabled(true);
            this.datePanel.setEditable(true);
        }
        if (t.getTransactionType() == TransactionType.DOUBLEENTRY) {
            TransactionEntry entry = t.getTransactionEntries().get(0);
            if (this.panelType == PanelType.DECREASE) {
                this.accountPanel.setSelectedAccount(entry.getCreditAccount());
                this.accountPanel.setExchangedAmount(entry.getCreditAmount());
            } else {
                this.accountPanel.setSelectedAccount(entry.getDebitAccount());
                this.accountPanel.setExchangedAmount(entry.getDebitAmount().abs());
            }
        }
    }

    public Account getOppositeSideAccount(Transaction t) {
        TransactionEntry entry = t.getTransactionEntries().get(0);
        if (entry.getCreditAccount().equals(this.getAccount())) {
            return entry.getDebitAccount();
        }
        return entry.getCreditAccount();
    }

    @Override
    protected boolean canModifyTransaction(Transaction t) {
        boolean result = false;
        switch (t.getTransactionType()) {
            case DOUBLEENTRY: {
                result = true;
                break;
            }
            case SPLITENTRY: {
                if (!t.getCommonAccount().equals(this.getAccount())) break;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public void clearForm() {
        this.splits = null;
        this.modEntry = null;
        this.amountField.setEditable(true);
        this.accountPanel.setEnabled(true);
        this.splitsButton.setEnabled(true);
        this.datePanel.setEditable(true);
        this.numberField.setEnabled(true);
        this.reconciledButton.setEnabled(true);
        this.payeeField.setEditable(true);
        super.clearForm();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.splitsButton) {
            this.splitsAction();
        }
    }
}

