/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import jgnash.engine.ReconciledState;
import jgnash.engine.TransactionEntry;
import jgnash.ui.register.AbstractTransactionEntryPanel;
import jgnash.ui.register.PanelType;
import jgnash.ui.register.table.SplitsRegisterTableModel;

public class SplitTransactionEntryPanel
extends AbstractTransactionEntryPanel {
    private PanelType panelType;

    public SplitTransactionEntryPanel(SplitsRegisterTableModel model, PanelType type) {
        super(model);
        this.panelType = type;
    }

    @Override
    public TransactionEntry buildTransactionEntry() {
        TransactionEntry entry = new TransactionEntry();
        entry.setMemo(this.memoField.getText());
        int signum = this.amountField.getDecimal().signum();
        if (this.panelType == PanelType.DECREASE && signum >= 0 || this.panelType == PanelType.INCREASE && signum < 0) {
            entry.setCreditAccount(this.accountPanel.getSelectedAccount());
            entry.setDebitAccount(this.getAccount());
            if (this.hasEqualCurrencies()) {
                entry.setAmount(this.amountField.getDecimal().abs());
            } else {
                entry.setDebitAmount(this.amountField.getDecimal().abs().negate());
                entry.setCreditAmount(this.accountPanel.getExchangedAmount().abs());
            }
        } else {
            entry.setCreditAccount(this.getAccount());
            entry.setDebitAccount(this.accountPanel.getSelectedAccount());
            if (this.hasEqualCurrencies()) {
                entry.setAmount(this.amountField.getDecimal().abs());
            } else {
                entry.setCreditAmount(this.amountField.getDecimal().abs());
                entry.setDebitAmount(this.accountPanel.getExchangedAmount().abs().negate());
            }
        }
        if (this.reconciledButton.isSelected()) {
            entry.setReconciled(this.account, ReconciledState.RECONCILED);
        } else {
            entry.setReconciled(this.account, ReconciledState.NOT_RECONCILED);
        }
        return entry;
    }

    @Override
    public void modifyTransaction(TransactionEntry entry) {
        this.oldEntry = entry;
        this.memoField.setText(entry.getMemo());
        if (this.panelType == PanelType.DECREASE) {
            this.accountPanel.setSelectedAccount(entry.getCreditAccount());
            this.amountField.setDecimal(entry.getDebitAmount().abs());
            this.accountPanel.setExchangedAmount(entry.getCreditAmount());
        } else {
            this.accountPanel.setSelectedAccount(entry.getDebitAccount());
            this.amountField.setDecimal(entry.getCreditAmount());
            this.accountPanel.setExchangedAmount(entry.getDebitAmount().abs());
        }
        this.reconciledButton.setSelected(entry.getReconciled(this.getAccount()) == ReconciledState.RECONCILED);
    }
}

