/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.recurring;

import java.awt.EventQueue;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jgnash.engine.EngineFactory;
import jgnash.engine.recurring.Reminder;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.util.Resource;

public class RecurringTableModel
extends AbstractTableModel
implements MessageListener {
    private static final long serialVersionUID = -4775197077477737505L;
    private List<Reminder> reminders;
    private final Resource rb = Resource.get();
    private final String[] names = new String[]{this.rb.getString("Column.Description"), this.rb.getString("Column.Freq"), this.rb.getString("Column.Enabled")};
    private final Class<?>[] classes = new Class[]{String.class, String.class, String.class};
    private final Object lock = new Object();
    private char enabledSymbol = (char)10003;

    public RecurringTableModel() {
        this.registerListeners();
        this.reminders = EngineFactory.getEngine("default") != null ? EngineFactory.getEngine("default").getReminders() : Collections.emptyList();
    }

    private void registerListeners() {
        MessageBus.getInstance().registerListener(this, MessageChannel.REMINDER, MessageChannel.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.names.length;
        }
    }

    protected void setEnabledSymbol(char symbol) {
        this.enabledSymbol = symbol;
    }

    protected char getEnabledSymbol() {
        return this.enabledSymbol;
    }

    protected Reminder getReminderAt(int row) {
        return this.reminders.get(row);
    }

    @Override
    public String getColumnName(int column) {
        return this.names[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.classes[column];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.reminders.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object object = this.lock;
        synchronized (object) {
            switch (columnIndex) {
                case 0: {
                    return this.reminders.get(rowIndex).getDescription();
                }
                case 1: {
                    return this.reminders.get(rowIndex).getReminderType().toString();
                }
                case 2: {
                    if (this.reminders.get(rowIndex).isEnabled()) {
                        return Character.valueOf(this.enabledSymbol);
                    }
                    return null;
                }
            }
            return "Error";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireTableDataChanged() {
        Object object = this.lock;
        synchronized (object) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RecurringTableModel.super.fireTableDataChanged();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadReminders() {
        Object object = this.lock;
        synchronized (object) {
            this.reminders = EngineFactory.getEngine("default").getReminders();
        }
    }

    @Override
    public void messagePosted(final Message event) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                switch (event.getEvent()) {
                    case REMINDER_ADD: 
                    case REMINDER_REMOVE: 
                    case FILE_LOAD_SUCCESS: {
                        RecurringTableModel.this.loadReminders();
                        RecurringTableModel.this.fireTableDataChanged();
                        break;
                    }
                    case FILE_CLOSING: {
                        Object object = RecurringTableModel.this.lock;
                        synchronized (object) {
                            RecurringTableModel.this.reminders = Collections.emptyList();
                        }
                        RecurringTableModel.this.fireTableDataChanged();
                        break;
                    }
                }
            }
        });
    }
}

