/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import jgnash.engine.CommodityNode;
import jgnash.engine.EngineFactory;
import jgnash.engine.SecurityNode;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageProperty;
import jgnash.ui.components.AbstractCommodityComboBox;

public class SecurityComboBox
extends AbstractCommodityComboBox<SecurityNode> {
    public SecurityComboBox() {
        SwingWorker<List<SecurityNode>, Void> worker = new SwingWorker<List<SecurityNode>, Void>(){

            @Override
            public List<SecurityNode> doInBackground() {
                return EngineFactory.getEngine("default").getSecurities();
            }

            @Override
            public void done() {
                try {
                    SecurityComboBox.this.model.addAll((Collection)this.get());
                    if (SecurityComboBox.this.model.getSize() > 0) {
                        SecurityComboBox.this.setSelectedIndex(0);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    Logger.getLogger(SecurityComboBox.class.getName()).severe(e.getLocalizedMessage());
                }
            }
        };
        worker.execute();
        MessageBus.getInstance().registerListener(this, MessageChannel.COMMODITY);
    }

    public SecurityNode getSelectedSecurityNode() {
        return (SecurityNode)this.getSelectedItem();
    }

    @Override
    public void messagePosted(final Message event) {
        final CommodityNode node = (CommodityNode)event.getObject(MessageProperty.COMMODITY);
        if (node instanceof SecurityNode) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case CURRENCY_ADD: {
                            SecurityComboBox.this.model.addElement((SecurityNode)node);
                            return;
                        }
                        case CURRENCY_REMOVE: {
                            SecurityComboBox.this.model.removeElement(node);
                            return;
                        }
                        case CURRENCY_MODIFY: {
                            SecurityComboBox.this.updateNode((SecurityNode)node);
                            return;
                        }
                    }
                }
            });
        }
    }
}

